/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac.semantic;

import java.util.HashMap;
import java.util.Map;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.CFGVisualizer;
import org.checkerframework.dataflow.cfg.node.Node;
import uk.ac.cam.acr31.features.javac.semantic.PossibleTreeSet;

public class PossibleTreeSetStore
implements Store<PossibleTreeSetStore> {
    private Map<Node, PossibleTreeSet> contents;

    private PossibleTreeSetStore(Map<Node, PossibleTreeSet> contents) {
        this.contents = contents;
    }

    PossibleTreeSetStore() {
        this(new HashMap<Node, PossibleTreeSet>());
    }

    PossibleTreeSet getInformation(Node n) {
        return this.contents.getOrDefault(n, new PossibleTreeSet());
    }

    void setInformation(Node n, PossibleTreeSet val) {
        if (val.isEmpty()) {
            this.contents.remove(n);
        } else {
            this.contents.put(n, val);
        }
    }

    @Override
    public PossibleTreeSetStore copy() {
        return new PossibleTreeSetStore(new HashMap<Node, PossibleTreeSet>(this.contents));
    }

    @Override
    public PossibleTreeSetStore leastUpperBound(PossibleTreeSetStore other) {
        Node n;
        HashMap<Node, PossibleTreeSet> newContents = new HashMap<Node, PossibleTreeSet>();
        for (Map.Entry<Node, PossibleTreeSet> e : other.contents.entrySet()) {
            n = e.getKey();
            PossibleTreeSet otherVal = e.getValue();
            if (this.contents.containsKey(n)) {
                newContents.put(n, otherVal.leastUpperBound(this.contents.get(n)));
                continue;
            }
            newContents.put(n, otherVal);
        }
        for (Map.Entry<Node, PossibleTreeSet> e : this.contents.entrySet()) {
            n = e.getKey();
            PossibleTreeSet thisVal = e.getValue();
            if (other.contents.containsKey(n)) continue;
            newContents.put(n, thisVal);
        }
        return new PossibleTreeSetStore(newContents);
    }

    @Override
    public PossibleTreeSetStore widenedUpperBound(PossibleTreeSetStore previous) {
        return this.leastUpperBound(previous);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PossibleTreeSetStore)) {
            return false;
        }
        PossibleTreeSetStore other = (PossibleTreeSetStore)o;
        return this.contents.equals(other.contents);
    }

    public int hashCode() {
        return this.contents.hashCode();
    }

    public String toString() {
        return this.contents.toString();
    }

    @Override
    public boolean canAlias(FlowExpressions.Receiver a, FlowExpressions.Receiver b) {
        return true;
    }

    @Override
    public void visualize(CFGVisualizer<?, PossibleTreeSetStore, ?> viz) {
    }
}

