/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac.semantic;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class TypeAnalysis {
    private final CompilationUnitTree compilationUnitTree;
    private final ProcessingEnvironment processingEnvironment;

    public TypeAnalysis(CompilationUnitTree compilationUnitTree, ProcessingEnvironment processingEnvironment) {
        this.compilationUnitTree = compilationUnitTree;
        this.processingEnvironment = processingEnvironment;
    }

    public TypeMirror getTypeMirror(Tree typeDecl) {
        Trees trees = Trees.instance(this.processingEnvironment);
        TreePath path = TreePath.getPath(this.compilationUnitTree, typeDecl);
        return trees.getTypeMirror(path);
    }

    private boolean canCheckAssignability(TypeMirror type) {
        return type.getKind() != TypeKind.EXECUTABLE && type.getKind() != TypeKind.PACKAGE;
    }

    public boolean isAssignable(TypeMirror typeA, TypeMirror typeB) {
        if (!this.canCheckAssignability(typeA) || !this.canCheckAssignability(typeB)) {
            return false;
        }
        return this.processingEnvironment.getTypeUtils().isAssignable(typeA, typeB);
    }

    public String getApproxTypeName(Tree tree) {
        return this.getTypeMirror(tree).toString();
    }

    public Types getTypes() {
        return this.processingEnvironment.getTypeUtils();
    }
}

