/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac.semantic;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import javax.lang.model.type.TypeMirror;
import uk.ac.cam.acr31.features.javac.graph.FeatureGraph;
import uk.ac.cam.acr31.features.javac.proto.GraphProtos;
import uk.ac.cam.acr31.features.javac.semantic.TypeAnalysis;

public class TypeScanner
extends TreeScanner<Void, Void> {
    private final FeatureGraph graph;
    private final TypeAnalysis typeAnalysis;

    public TypeScanner(FeatureGraph graph, TypeAnalysis typeAnalysis) {
        this.graph = graph;
        this.typeAnalysis = typeAnalysis;
    }

    public static void addToGraph(CompilationUnitTree compilationUnitTree, FeatureGraph graph, TypeAnalysis typeAnalysis) {
        TypeScanner typeScanner = new TypeScanner(graph, typeAnalysis);
        compilationUnitTree.accept(typeScanner, null);
    }

    private void addTypeEdge(Tree tree) {
        GraphProtos.FeatureNode typeNode;
        TypeMirror mirror;
        GraphProtos.FeatureNode featureNode = this.graph.lookupNode(tree);
        if (featureNode != null && (mirror = this.typeAnalysis.getTypeMirror(tree)) != null && (typeNode = this.graph.createFeatureNodeForType(this.typeAnalysis.getTypes(), GraphProtos.FeatureNode.NodeType.TYPE, mirror)) != null) {
            this.graph.addEdge(featureNode, typeNode, GraphProtos.FeatureEdge.EdgeType.HAS_TYPE);
        }
    }

    @Override
    public Void visitVariable(VariableTree tree, Void ignored) {
        this.addTypeEdge(tree.getType());
        this.addTypeEdge(tree.getInitializer());
        return (Void)super.visitVariable(tree, ignored);
    }

    @Override
    public Void visitAssignment(AssignmentTree tree, Void ignored) {
        this.addTypeEdge(tree.getExpression());
        this.addTypeEdge(tree.getVariable());
        return (Void)super.visitAssignment(tree, ignored);
    }

    @Override
    public Void visitBinary(BinaryTree tree, Void ignored) {
        this.addTypeEdge(tree.getLeftOperand());
        this.addTypeEdge(tree.getRightOperand());
        return (Void)super.visitBinary(tree, ignored);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree tree, Void ignored) {
        for (ExpressionTree expressionTree : tree.getArguments()) {
            this.addTypeEdge(expressionTree);
        }
        return (Void)super.visitMethodInvocation(tree, ignored);
    }
}

