/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac.syntactic;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import uk.ac.cam.acr31.features.javac.graph.FeatureGraph;
import uk.ac.cam.acr31.features.javac.proto.GraphProtos;
import uk.ac.cam.acr31.features.javac.syntactic.IdentifierCollector;

public class ComputedFromScanner
extends TreeScanner<Void, Void> {
    private final FeatureGraph graph;

    public static void addToGraph(CompilationUnitTree tree, FeatureGraph graph) {
        ComputedFromScanner computedFromScanner = new ComputedFromScanner(graph);
        tree.accept(computedFromScanner, null);
    }

    private ComputedFromScanner(FeatureGraph graph) {
        this.graph = graph;
    }

    @Override
    public Void visitAssignment(AssignmentTree node, Void ignored) {
        IdentifierCollector rhsCollector = new IdentifierCollector();
        node.getExpression().accept(rhsCollector, null);
        IdentifierCollector lhsCollector = new IdentifierCollector();
        node.getVariable().accept(lhsCollector, null);
        for (IdentifierTree lhs : lhsCollector.identifiers) {
            for (IdentifierTree rhs : rhsCollector.identifiers) {
                this.graph.addIdentifierEdge(lhs, rhs, GraphProtos.FeatureEdge.EdgeType.COMPUTED_FROM);
            }
        }
        return null;
    }

    @Override
    public Void visitVariable(VariableTree node, Void ignored) {
        ExpressionTree initializer = node.getInitializer();
        if (initializer == null) {
            return null;
        }
        IdentifierCollector rhsCollector = new IdentifierCollector();
        initializer.accept(rhsCollector, null);
        for (IdentifierTree rhs : rhsCollector.identifiers) {
            this.graph.addIdentifierEdge(node, rhs, GraphProtos.FeatureEdge.EdgeType.COMPUTED_FROM);
        }
        return null;
    }
}

