/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac.syntactic;

import com.google.common.collect.ImmutableMap;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uk.ac.cam.acr31.features.javac.Symbols;
import uk.ac.cam.acr31.features.javac.graph.FeatureGraph;
import uk.ac.cam.acr31.features.javac.proto.GraphProtos;
import uk.ac.cam.acr31.features.javac.syntactic.IdentifierCollector;

public class FormalArgScanner
extends TreeScanner<Void, Void> {
    private final FeatureGraph graph;
    private final Map<Symbol.MethodSymbol, MethodTree> methodSymbols;

    public static void addToGraph(CompilationUnitTree compilationUnitTree, FeatureGraph graph) {
        ImmutableMap methodSymbols = MethodSymbolCollector.collect(compilationUnitTree);
        FormalArgScanner formalArgScanner = new FormalArgScanner(graph, methodSymbols);
        compilationUnitTree.accept(formalArgScanner, null);
    }

    private FormalArgScanner(FeatureGraph graph, Map<Symbol.MethodSymbol, MethodTree> methodSymbols) {
        this.graph = graph;
        this.methodSymbols = methodSymbols;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void ignored) {
        Symbols.getSymbol(node).filter(this.methodSymbols::containsKey).map(this.methodSymbols::get).ifPresent(mth -> this.process(node.getArguments(), mth.getParameters()));
        return (Void)super.visitMethodInvocation(node, ignored);
    }

    @Override
    public Void visitNewClass(NewClassTree node, Void ignored) {
        Symbols.getSymbol(node).filter(this.methodSymbols::containsKey).map(this.methodSymbols::get).ifPresent(mth -> this.process(node.getArguments(), mth.getParameters()));
        return (Void)super.visitNewClass(node, ignored);
    }

    private void process(List<? extends ExpressionTree> arguments, List<? extends VariableTree> parameters) {
        Iterator<? extends ExpressionTree> argumentIterator = arguments.iterator();
        Iterator<? extends VariableTree> parameterIterator = parameters.iterator();
        while (argumentIterator.hasNext() && parameterIterator.hasNext()) {
            ExpressionTree argument = argumentIterator.next();
            VariableTree parameter = parameterIterator.next();
            IdentifierCollector c = new IdentifierCollector();
            argument.accept(c, null);
            for (IdentifierTree identifierTree : c.identifiers) {
                this.graph.addIdentifierEdge(identifierTree, parameter, GraphProtos.FeatureEdge.EdgeType.FORMAL_ARG_NAME);
            }
        }
    }

    private static class MethodSymbolCollector
    extends TreeScanner<Void, Void> {
        private ImmutableMap.Builder<Symbol.MethodSymbol, MethodTree> methodSymbols = ImmutableMap.builder();

        private MethodSymbolCollector() {
        }

        @Override
        public Void visitMethod(MethodTree node, Void ignored) {
            Symbols.getSymbol(node).ifPresent(sym -> this.methodSymbols.put((Symbol.MethodSymbol)sym, node));
            return (Void)super.visitMethod(node, ignored);
        }

        private static ImmutableMap<Symbol.MethodSymbol, MethodTree> collect(CompilationUnitTree compilationUnitTree) {
            MethodSymbolCollector methodSymbolCollector = new MethodSymbolCollector();
            compilationUnitTree.accept(methodSymbolCollector, null);
            return methodSymbolCollector.methodSymbols.build();
        }
    }
}

