/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac.syntactic;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import uk.ac.cam.acr31.features.javac.graph.FeatureGraph;
import uk.ac.cam.acr31.features.javac.proto.GraphProtos;
import uk.ac.cam.acr31.features.javac.syntactic.IdentifierCollector;

public class GuardedByScanner
extends TreeScanner<Void, Void> {
    private final FeatureGraph graph;

    public static void addToGraph(CompilationUnitTree compilationUnitTree, FeatureGraph featureGraph) {
        GuardedByScanner guardedByVisitor = new GuardedByScanner(featureGraph);
        compilationUnitTree.accept(guardedByVisitor, null);
    }

    private GuardedByScanner(FeatureGraph graph) {
        this.graph = graph;
    }

    @Override
    public Void visitIf(IfTree node, Void ignored) {
        this.findIdentifiers(node.getCondition(), node.getThenStatement(), GraphProtos.FeatureEdge.EdgeType.GUARDED_BY);
        this.findIdentifiers(node.getCondition(), node.getElseStatement(), GraphProtos.FeatureEdge.EdgeType.GUARDED_BY_NEGATION);
        return (Void)super.visitIf(node, ignored);
    }

    private void findIdentifiers(Tree root, Tree node, GraphProtos.FeatureEdge.EdgeType edgeType) {
        if (node == null) {
            return;
        }
        IdentifierCollector ic = new IdentifierCollector();
        node.accept(ic, null);
        for (IdentifierTree identifierTree : ic.identifiers) {
            this.graph.addEdge(identifierTree, root, edgeType);
        }
    }
}

