/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac.syntactic;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import uk.ac.cam.acr31.features.javac.Symbols;
import uk.ac.cam.acr31.features.javac.graph.FeatureGraph;
import uk.ac.cam.acr31.features.javac.proto.GraphProtos;

public class LastLexicalUseScanner
extends TreeScanner<Void, Void> {
    private ImmutableMultimap.Builder<Symbol, Tree> symbolMap = ImmutableListMultimap.builder();

    public static void addToGraph(CompilationUnitTree compilationUnitTree, FeatureGraph featureGraph) {
        LastLexicalUseScanner lastLexicalUseScanner = new LastLexicalUseScanner();
        compilationUnitTree.accept(lastLexicalUseScanner, null);
        Map symbolMap = lastLexicalUseScanner.symbolMap.build().asMap();
        for (Collection commonIds : ((ImmutableMap)symbolMap).values()) {
            Iterator idIterator = commonIds.iterator();
            Tree prevItem = (Tree)idIterator.next();
            while (idIterator.hasNext()) {
                Tree next = (Tree)idIterator.next();
                featureGraph.addIdentifierEdge(prevItem, next, GraphProtos.FeatureEdge.EdgeType.LAST_LEXICAL_USE);
                prevItem = next;
            }
        }
    }

    @Override
    public Void visitVariable(VariableTree node, Void ignored) {
        Symbols.getSymbol(node).ifPresent(sym -> this.symbolMap.put((Symbol)sym, node));
        return (Void)super.visitVariable(node, ignored);
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void ignored) {
        Symbols.getSymbol(node).filter(sym -> sym.kind == Kinds.Kind.VAR).ifPresent(sym -> this.symbolMap.put((Symbol)sym, node));
        return (Void)super.visitIdentifier(node, ignored);
    }
}

