/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac.syntactic;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.util.TreeScanner;
import java.util.List;
import uk.ac.cam.acr31.features.javac.graph.FeatureGraph;
import uk.ac.cam.acr31.features.javac.proto.GraphProtos;
import uk.ac.cam.acr31.features.javac.syntactic.IdentifierCollector;

public class ReturnsToScanner
extends TreeScanner<Void, Void> {
    private final FeatureGraph graph;

    public static void addToGraph(CompilationUnitTree compilationUnitTree, FeatureGraph featureGraph) {
        ReturnsToScanner returnsToScanner = new ReturnsToScanner(featureGraph);
        compilationUnitTree.accept(returnsToScanner, null);
    }

    private ReturnsToScanner(FeatureGraph graph) {
        this.graph = graph;
    }

    @Override
    public Void visitMethod(MethodTree node, Void ignored) {
        if (node.getBody() == null) {
            return null;
        }
        ReturnCollector returnCollector = new ReturnCollector();
        node.getBody().accept(returnCollector, null);
        if (returnCollector.identifiers != null) {
            GraphProtos.FeatureNode dest = this.graph.lookupNode(node);
            for (IdentifierTree identifierTree : returnCollector.identifiers) {
                GraphProtos.FeatureNode featureNode = this.graph.lookupNode(identifierTree);
                if (featureNode == null) continue;
                for (GraphProtos.FeatureNode succ : this.graph.successors(featureNode, GraphProtos.FeatureEdge.EdgeType.ASSOCIATED_TOKEN)) {
                    this.graph.addEdge(succ, dest, GraphProtos.FeatureEdge.EdgeType.RETURNS_TO);
                }
            }
        }
        return (Void)super.visitMethod(node, ignored);
    }

    private static class ReturnCollector
    extends TreeScanner<Void, Void> {
        List<IdentifierTree> identifiers;

        private ReturnCollector() {
        }

        @Override
        public Void visitReturn(ReturnTree node, Void ignored) {
            if (node.getExpression() == null) {
                return null;
            }
            IdentifierCollector ic = new IdentifierCollector();
            node.getExpression().accept(ic, null);
            this.identifiers = ic.identifiers;
            return null;
        }
    }
}

