/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac.syntactic;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.Optional;
import uk.ac.cam.acr31.features.javac.Optionals;
import uk.ac.cam.acr31.features.javac.Symbols;
import uk.ac.cam.acr31.features.javac.graph.FeatureGraph;
import uk.ac.cam.acr31.features.javac.proto.GraphProtos;

public class SymbolScanner
extends TreeScanner<Void, Void> {
    private final FeatureGraph featureGraph;

    public SymbolScanner(FeatureGraph featureGraph) {
        this.featureGraph = featureGraph;
    }

    public static void addToGraph(CompilationUnitTree compilationUnitTree, FeatureGraph featureGraph) {
        compilationUnitTree.accept(new SymbolScanner(featureGraph), null);
    }

    @Override
    public Void visitClass(ClassTree node, Void ignored) {
        Void result = (Void)super.visitClass(node, ignored);
        this.addNode(node);
        return result;
    }

    @Override
    public Void visitNewClass(NewClassTree node, Void ignored) {
        Void result = (Void)super.visitNewClass(node, ignored);
        this.addNode(node);
        return result;
    }

    @Override
    public Void visitMethod(MethodTree node, Void ignored) {
        Void result = (Void)super.visitMethod(node, ignored);
        this.addNode(node);
        return result;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void ignored) {
        Void result = (Void)super.visitMethodInvocation(node, ignored);
        this.addNode(node);
        return result;
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void ignored) {
        Void result = (Void)super.visitIdentifier(node, ignored);
        this.addNode(node);
        return result;
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void ignored) {
        Void result = (Void)super.visitMemberSelect(node, ignored);
        this.addNode(node);
        return result;
    }

    @Override
    public Void visitVariable(VariableTree node, Void ignored) {
        Void result = (Void)super.visitVariable(node, ignored);
        this.addNode(node);
        return result;
    }

    public Void visitPackage(PackageTree node, Void ignored) {
        Void result = (Void)super.visitPackage(node, (Object)ignored);
        this.addNode(node);
        return result;
    }

    private void addNode(Tree node) {
        Optional<GraphProtos.FeatureNode> featureNode = Symbols.getSymbol(node).map(sym -> this.featureGraph.createFeatureNode(SymbolScanner.toSymbolType(sym), (Symbol)sym));
        Optional<GraphProtos.FeatureNode> target = Optional.ofNullable(this.featureGraph.lookupNode(node)).map(this.featureGraph::toIdentifierNode);
        Optionals.ifBothPresent(featureNode, target, (f, t) -> {
            if (this.featureGraph.predecessors((GraphProtos.FeatureNode)t, GraphProtos.FeatureEdge.EdgeType.ASSOCIATED_SYMBOL).isEmpty()) {
                this.featureGraph.addEdge((GraphProtos.FeatureNode)f, (GraphProtos.FeatureNode)t, GraphProtos.FeatureEdge.EdgeType.ASSOCIATED_SYMBOL);
            }
        });
    }

    private static GraphProtos.FeatureNode.NodeType toSymbolType(Symbol symbol) {
        switch (1.$SwitchMap$com$sun$tools$javac$code$Kinds$Kind[symbol.kind.ordinal()]) {
            case 1: {
                return GraphProtos.FeatureNode.NodeType.SYMBOL_VAR;
            }
            case 2: {
                return GraphProtos.FeatureNode.NodeType.SYMBOL_MTH;
            }
            case 3: {
                return GraphProtos.FeatureNode.NodeType.SYMBOL_TYP;
            }
        }
        return GraphProtos.FeatureNode.NodeType.SYMBOL;
    }
}

