/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac.testing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import uk.ac.cam.acr31.features.javac.graph.FeatureGraph;
import uk.ac.cam.acr31.features.javac.proto.GraphProtos;
import uk.ac.cam.acr31.features.javac.testing.SourceSpan;

public class FeatureGraphChecks {
    public static Set<GraphProtos.FeatureNode> findNodes(FeatureGraph graph, SourceSpan span) {
        return graph.findNode(span.start(), span.end());
    }

    public static Set<GraphProtos.FeatureNode> findNodes(FeatureGraph graph, SourceSpan span, GraphProtos.FeatureNode.NodeType type) {
        return graph.findNode(span.start(), span.end()).stream().filter(n -> n.getType() == type).collect(ImmutableSet.toImmutableSet());
    }

    public static GraphProtos.FeatureNode findNode(FeatureGraph graph, SourceSpan span, String ... contents) {
        Set<GraphProtos.FeatureNode> s2 = FeatureGraphChecks.findNodes(graph, span);
        GraphProtos.FeatureNode found = null;
        for (String c : contents) {
            found = s2.stream().filter(n -> n.getContents().equals(c)).findFirst().orElseThrow();
            s2 = graph.successors(found);
        }
        return found;
    }

    private static Optional<GraphProtos.FeatureEdge> anyEdgeBetween(FeatureGraph graph, GraphProtos.FeatureNode source, GraphProtos.FeatureNode destination, GraphProtos.FeatureEdge.EdgeType edgeType) {
        return graph.edges(source, destination).stream().filter(e -> e.getType().equals(edgeType)).findAny();
    }

    public static GraphProtos.FeatureEdge edgeBetween(FeatureGraph graph, SourceSpan source, SourceSpan destination, GraphProtos.FeatureEdge.EdgeType edgeType) {
        Set<GraphProtos.FeatureNode> sourceNodes = FeatureGraphChecks.findNodes(graph, source);
        Set<GraphProtos.FeatureNode> destinationNodes = FeatureGraphChecks.findNodes(graph, destination);
        for (GraphProtos.FeatureNode sourceNode : sourceNodes) {
            for (GraphProtos.FeatureNode destinationNode : destinationNodes) {
                Optional<GraphProtos.FeatureEdge> edge = FeatureGraphChecks.anyEdgeBetween(graph, sourceNode, destinationNode, edgeType);
                if (!edge.isPresent()) continue;
                return edge.get();
            }
        }
        throw new AssertionError((Object)("Failed to find an edge from " + source + " to " + destination + " with type " + edgeType));
    }

    public static boolean isEdgeBetween(FeatureGraph graph, GraphProtos.FeatureNode source, GraphProtos.FeatureNode destination, GraphProtos.FeatureEdge.EdgeType edgeType) {
        return FeatureGraphChecks.anyEdgeBetween(graph, source, destination, edgeType).isPresent();
    }

    public static boolean isAcyclic(FeatureGraph graph, GraphProtos.FeatureEdge.EdgeType edgeType) {
        HashSet nodes = graph.nodes().stream().filter(node -> !graph.successors((GraphProtos.FeatureNode)node, edgeType).isEmpty() || !graph.predecessors((GraphProtos.FeatureNode)node, edgeType).isEmpty()).collect(Collectors.toCollection(HashSet::new));
        while (!nodes.isEmpty()) {
            Optional<GraphProtos.FeatureNode> possibleLeaf = nodes.stream().filter(node -> Sets.intersection(graph.successors((GraphProtos.FeatureNode)node, edgeType), nodes).isEmpty()).findAny();
            if (!possibleLeaf.isPresent()) {
                return false;
            }
            nodes.remove(possibleLeaf.get());
        }
        return true;
    }

    public static GraphProtos.FeatureNode findAssociatedTypeNode(FeatureGraph graph, SourceSpan span) {
        return (GraphProtos.FeatureNode)FeatureGraphChecks.findNodes(graph, span).stream().flatMap(node -> graph.successors((GraphProtos.FeatureNode)node, GraphProtos.FeatureEdge.EdgeType.HAS_TYPE).stream()).findFirst().orElseThrow(() -> new AssertionError((Object)"Could not find type node"));
    }
}

