/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.features.javac.testing;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.IOError;
import java.io.IOException;
import java.net.URI;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import uk.ac.cam.acr31.features.javac.testing.AutoValue_TestCompilation;
import uk.ac.cam.acr31.features.javac.testing.SourceSpan;

@AutoValue
public abstract class TestCompilation {
    public abstract JCTree.JCCompilationUnit compilationUnit();

    public abstract Context context();

    public abstract String source();

    private static TestCompilation create(JCTree.JCCompilationUnit compilationUnit, Context context, String source) {
        return new AutoValue_TestCompilation(compilationUnit, context, source);
    }

    public static TestCompilation compile(String fileName, String ... lines) {
        JavacTool javacTool = JavacTool.create();
        Context context = new Context();
        final String source = Joiner.on("\n").join(lines);
        ImmutableList<1> compilationUnits = ImmutableList.of(new SimpleJavaFileObject(URI.create(fileName), JavaFileObject.Kind.SOURCE){

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                return source;
            }
        });
        DiagnosticListener diagnosticListener = diagnostic -> {
            throw new AssertionError((Object)("Compilation failed: " + diagnostic.toString()));
        };
        JavacTask task = javacTool.getTask(null, null, diagnosticListener, null, null, compilationUnits, context);
        try {
            JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)Iterables.getOnlyElement(task.parse());
            task.analyze();
            return TestCompilation.create(compilationUnit, context, source);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public SourceSpan sourceSpan(String target, String followedBy) {
        return this.sourceSpan("", target, followedBy);
    }

    public SourceSpan sourceSpan(String target) {
        return this.sourceSpan("", target, "");
    }

    public SourceSpan sourceSpan(String prefix, String target, String followedBy) {
        int base = this.source().indexOf(prefix + target + followedBy);
        if (base == -1) {
            throw new AssertionError((Object)("Failed to find '" + prefix + target + followedBy + "' in source."));
        }
        return SourceSpan.create(base + prefix.length(), base + prefix.length() + target.length());
    }
}

