# Output checker

This problem may have multiple correct answers.
For each input file, one correct answer is provided in a corresponding `*.ans` file.
The C++ source code of the judge program is provided as `output_checker.cc` and `testlib.h`.

## Usage

Assume the executable of the judge program is named `output_checker.out`:

```sh
$ output_checker.out <input file> <program output> <answer file>
```

* `<input file>` is the input file (a `*.in` file in this directory).
* `<program output>` is the file storing the output of your program for the input file.
* `<answer file>` is the corresponding answer file to the input file (a `*.ans` file in this directory).

If the program output is a correct answer for the given input file,
`output_checker.out` exits with exit code `0`, which is stored in the shell variable `$?`.
Otherwise, it displays an error message and exits with a non-zero exit code.

## Example

If your program executable is named `solve` and you want to test it with `01.in`:

```sh
./solve < 01.in > 01.out
./output_checker.out 01.in 01.out 01.ans
echo $?
```

Note: do not execute any other commands between `./output_checker.out ...` and `echo $?`,
otherwise the exit code of `output_checker.out` will be overwritten.

If `echo $?` prints `0`, your program's answer for `01.in` is judged correct.