#include <vector>
#include <algorithm>
#include "testlib.h"

using namespace std;

int main(int argc, char *argv[]) {
    setName("Validate bird output.");
    registerTestlibCmd(argc, argv);

    const int MIN_N = 2, MAX_N = 200000;
    const int MIN_BIRD = 0, MAX_BIRD = 200000;
    const int MAX_M_REQUIRING_EXAMPLE = 200000;

    // load and check input
    vector<int> input_seasons;
    const int n = inf.readInt(2, MAX_N);
    bool has_nonzero_season = false;
    inf.readEoln();
    for (int i = 0; i < n; ++i) {
        if (i) inf.readChar(' ');
        int temp = inf.readInt(MIN_BIRD, MAX_BIRD);
        if (temp > 0) has_nonzero_season = true;
        input_seasons.push_back(temp);
    }
    if (!has_nonzero_season) {
        quitf(_fail, "Input error: no birds!");
    }
    inf.readEoln();
    inf.readEof();
    const long long expected_solution = ans.readLong();
    // process ans
    {
        ans.readEoln();
        if (expected_solution <= MAX_M_REQUIRING_EXAMPLE) {
            for (int i = 0; i < expected_solution; ++i) {
                ans.readInt();
                ans.readChar(' ');
                ans.readInt();
                ans.readEoln();
            }
        }
        ans.readEof();
    }
    
    const long long got_solution = ouf.readLong();
    if (got_solution != expected_solution) {
        quitf(_wa, "Wrong bird number (expected: '%lld', found: '%lld').",
              expected_solution, got_solution);
    }
    if (got_solution <= MAX_M_REQUIRING_EXAMPLE) {
        // Validate the output example.
        vector<int> output_seasons(n, 0);
        for (int i = 0; i < got_solution; ++i) {
            int va, vb;
            va = ouf.readInt(1, n);
            --va;  // Slide to 0-indexed
            vb = ouf.readInt(1, n);
            --vb;  // Slide to 0-indexed
            if (va > vb) {
                // [0, vb]
                ++output_seasons[0];
                if (vb < n - 1) --output_seasons[vb + 1];
                // [va, n - 1]
                ++output_seasons[va];
            } else {
                ++output_seasons[va];
                if (vb < n - 1) --output_seasons[vb + 1];
            }
        }
        // imos
        for (int i = 1; i < n; ++i) output_seasons[i] += output_seasons[i - 1];
        for (int i = 0; i < n; ++i) {
            if (output_seasons[i] != input_seasons[i]) {
                quitf(_wa, "The example is not equal to the input.");
            }
        }
    }
    ouf.seekEof();
    quitf(_ok, "%lld birds.", got_solution);
    return 0;
}
