# Interactor

This problem is an interactive problem.

Your program is expected to communicate with an interactor program through the standard input and output.
The C++ source code of the interactor program is provided as `interactor.cc` and `validate_domjudge.h`.

## Usage

Assume the executable of the interactor program is named `interactor.out`:

```sh
$ ./interactor.out <input data> <answer file> <feedback dir>
```

* `<input data>` is the input file (a `*.in` file in this directory).
* `<answer file>` is the corresponding answer file to the input file (a `*.ans` file in this directory).
* `<feedback dir>` is a directory used by the interactor.

The interactor's standard input and output must be connected to your program's standard output and input, respectively.
If your program produces valid output for the interactor at each step of the communication and eventually reaches a correct answer, the interactor exits with
exit code `42`, which is stored in the shell variable `$?`.
Otherwise, it exits with another exit code.

## Example

If your program executable is named `solve` and you want to test it with `01.in`:

```sh
mkdir feedback
mkfifo fifo
./solve < fifo | ./interactor.out 01.in 01.ans feedback > fifo
echo $?
```

Note: do not execute any other commands between the `./solve | ./interactor.out ...`
pipeline and `echo $?`, otherwise the exit code of `interactor.out` will be overwritten.

If `echo $?` prints `42`, your program's answer for `01.in` is judged correct.
If the program output is incorrect, `echo $?` will print `43` instead.

## Testing Tool

For your convenience, a command-line tool for testing interactions is provided as `run-tool`.
To use this testing tool, first compile `interactor.cc` and `validate_domjudge.h` into the executable `interactor.out`.
The usage of the tool and the format of its input file will be displayed by executing `run-tool` with no arguments:

```sh
./run-tool
```
