#include <string>
#include <cstring>
#include <vector>
#include <cmath>
#include "validate_domjudge.h"

using namespace std;
using ll = long long;

const int measure_limit = 300;
const int M = 4000;

struct Point { int x, y, z; };

int dot(Point p1, Point p2) {
  return p1.x * p2.x + p1.y * p2.y + p1.z * p2.z;
}

int sq(int w) { return w * w; }

int dist(Point pi, Point pj) {
  return sq(pi.x - pj.x) + sq(pi.y - pj.y) + sq(pi.z - pj.z);
}

int main(int argc, char **argv) {
  init_io(argc, argv);

  int n;
  if (!(judge_in >> n)) {
    judge_error("Input error: Unable to read n");
  }

  if (n < 2 || n > 100) {
    judge_error("Input error: n is violating the constraint");
  }
  std::vector<Point> vp(n);
  for (int i = 0; i < n; ++i) {
    int x, y, z;
    if (!(judge_in >> x >> y >> z)) {
      judge_error("Input error: Unable to read the coordinates for star %d", i + 1);
    }
    if (x < -M || x > M) {
      judge_error("Input error: x-coordinate of star %d is violating the constraint", i + 1);
    }
    if (y < -M || y > M) {
      judge_error("Input error: y-coordinate of star %d is violating the constraint", i + 1);
    }
    if (z < -M || z > M) {
      judge_error("Input error: z-coordinate of star %d is violating the constraint", i + 1);
    }
    vp[i] = Point{x, y, z};
  }
  for (int i = 0; i < n; ++i) {
    Point pi = vp[i];
    if (dist(pi, {0, 0, 0}) == 0) {
      judge_error("Input error: star %d is at the origin", i + 1);
    }
  }
  for (int i = 0; i < n; ++i) {
    for (int j = i + 1; j < n; ++j) {
      Point pi = vp[i], pj = vp[j];
      if (dist(pi, pj) == 0) {
        judge_error("Input error: stars %d and %d are at the same coordinates", i + 1, j + 1);
      }
    }
  }

  jprintln("%d", n);
  string line2;
  for (int i = 0; i < n; ++i) {
    if (i) line2 += " ";
    Point p = vp[i];
    int norm = dot(p, p);
    line2 += std::to_string(norm);
  }
  jprintln("%s", line2.c_str());

  int measure_count = 0;
  while (true) {
    string op;
    if (!author_out.get(op)) {
      wrong_answer("operation is not given");
    }

    if (op == "measure") {
      measure_count++;
      if (measure_count > measure_limit) {
        wrong_answer("measurement limit exceeded");
      }

      int i, j;
      if (!author_out.get(i)) {
        wrong_answer("i is not given or unable to parse as an integer");
      }
      if (!author_out.get(j)) {
        wrong_answer("j is not given or unable to parse as an integer");
      }
      if (i < 1 || i > n) wrong_answer("i is out of range: i=%d", i);
      if (j < 1 || j > n) wrong_answer("j is out of range: j=%d", j);
      if (i == j) wrong_answer("i and j are identical: i=%d, j=%d", i, j);

      i--; j--;
      Point pi = vp[i], pj = vp[j];
      int sqlen = dist(pi, pj);
      jprintln("%d", sqlen);
    }
    else if (op == "answer") {
      for (int i = 0; i < n; ++i) {
        for (int j = i + 1; j < n; ++j) {
          int guess;
          if (!author_out.get(guess)) {
            wrong_answer("guess for i=%d,j=%d is not given or unable to parse as an integer", i + 1, j + 1);
          }

          Point pi = vp[i], pj = vp[j];
          int expected = dist(pi, pj);
          if (guess != expected) {
            wrong_answer("wrong guess for i=%d,j=%d is given: expected=%d, given=%d", i + 1, j + 1, expected, guess);
          }
        }
      }
      accept();
    }
    else {
      wrong_answer("invalid operation type: %s", op.c_str());
    }
  }
}
