#include "testlib.h"
using namespace std;

void check(int t, int n, int m, const vector<string>& grid, const vector<string>& out_grid) {
  for (int i = 0; i < n; ++i) {
    // check row length
    if ((int)out_grid[i].size() != m) {
      quitf(_wa, "Case %d: Row %d length is %d, expected %d", t + 1, i + 1, (int)out_grid[i].size(), m);
    }
    for (int j = 0; j < m; ++j) {
      char c = out_grid[i][j];
      // check cell value
      if (c != 'I' && c != 'C' && c != 'P') {
        quitf(_wa, "Case %d: Cell (%d, %d) is '%c', expected 'I', 'C', or 'P'", t + 1, i + 1, j + 1, c);
      }
      // check consistency with input
      if (grid[i][j] != '?' && grid[i][j] != c) {
        quitf(_wa, "Case %d: Cell (%d, %d) is '%c', expected '%c'", t + 1, i + 1, j + 1, c, grid[i][j]);
      }
    }
  }

  // check ICPC condition
  for (int i = 0; i < n - 1; ++i) {
    for (int j = 0; j < m - 1; ++j) {
      int I = 0, C = 0, P = 0;
      for (unsigned char ch : {out_grid[i][j], out_grid[i][j + 1], out_grid[i + 1][j], out_grid[i + 1][j + 1]}) {
        if (ch == 'I')
          I++;
        else if (ch == 'C')
          C++;
        else if (ch == 'P')
          P++;
      }
      if (I != 1 || C != 2 || P != 1) {
        quitf(_wa,
              "Case %d: 2x2 block with top-left corner (%d, %d) has %d I's, %d C's, and %d P's, "
              "expected 1 I, 2 C's, and 1 P",
              t + 1, i + 1, j + 1, I, C, P);
      }
    }
  }
}

int main(int argc, char* argv[]) {
  setName("special validator for problem J");
  registerTestlibCmd(argc, argv);

  int T = inf.readInt();

  for (int t = 0; t < T; ++t) {
    // read input
    int n = inf.readInt();
    int m = inf.readInt();
    inf.readEoln();
    vector<string> grid(n);
    for (int i = 0; i < n; ++i) grid[i] = inf.readLine();

    // read output and answer
    string out_yn = ouf.readToken("yes|no");
    string ans_yn = ans.readToken("yes|no");
    // ouf.readEoln();
    // ans.readEoln();
    vector<string> out_grid, ans_grid;
    if (out_yn == "yes") {
      out_grid.resize(n);
      for (int i = 0; i < n; ++i) out_grid[i] = ouf.readToken();
    }
    if (ans_yn == "yes") {
      ans_grid.resize(n);
      for (int i = 0; i < n; ++i) ans_grid[i] = ans.readToken();
    }

    // validate
    if (out_yn == "no") {
      if (ans_yn == "no")
        continue;
      else
        quitf(_wa, "Case %d: Answered \"no\" for a feasible input", t + 1);
    } else {
      check(t, n, m, grid, out_grid);
    }
  }

  // EOF check
  if (ouf.seekEof())
    quitf(_ok, "Validated all testcases");
  else
    quitf(_wa, "Participant output contains extra tokens");
}
