#include "testlib.h"

// $ ./output_checker in.txt out.txt ans.txt

using namespace std;

int main(int argc, char *argv[]) {
    setName("special validator for problem L");
    registerTestlibCmd(argc, argv);

    int num_tests = inf.readInt();
    double max_error = 0.0;

    for (int test_number = 1; test_number <= num_tests; test_number++) {
        string judge, contestant;
        ans.readWordTo(judge);
        ouf.readWordTo(contestant);

        if (judge == "no" && contestant == "no") {
            // OK.
        } else if (judge == "no" || contestant == "no") {
            quitf(_wa, "[test %d] expected: '%s', found: '%s'",
                    test_number, judge.c_str(), contestant.c_str());
        } else {
            double judge_d = stringToDouble(ans, judge);
            double contestant_d = stringToDouble(ouf, contestant);
            double error = doubleDelta(judge_d, contestant_d);

            // 問題設定では 1e-7 の誤差を許す.
            // チェッカーでは少し広くとって 1.1e-7 の誤差を判定する.
            if (error > 1.1e-7) {
                quitf(_wa, "[test %d] expected: '%s', found: '%s', error: %.12f",
                        test_number, judge.c_str(), contestant.c_str(), error);
            }
            if (max_error < error) {
                max_error = error;
            }
        }
    }

    if (ouf.seekEof()) {
        quitf(_ok, "%d test cases. Max error: %e", num_tests, max_error);
    } else {
        quitf(_wa, "Participant output contains extra tokens");
    }
}
