/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.util;

import com.google.appengine.tools.util.Option;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;

public abstract class Action {
    private final String[] names;
    private List<String> args;
    protected List<Option> extraOptions;
    protected String shortDescription;
    private String helpString = null;

    public Action(String ... names) {
        this.names = names;
    }

    public Action(List<Option> options, String ... names) {
        this.names = names;
        this.extraOptions = options;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getNameString() {
        return Joiner.on(" ").join(this.names);
    }

    public List<Option> getOptions() {
        return this.extraOptions;
    }

    public void setOptions(List<Option> extraOptions) {
        this.extraOptions = extraOptions;
    }

    public void setShortDescription(String description) {
        this.shortDescription = description;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    protected void setArgs(List<String> args) {
        this.args = args;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public abstract void apply();

    public String getHelpString() {
        if (this.helpString == null) {
            this.helpString = Joiner.on('\n').join(this.getHelpLines());
        }
        return this.helpString;
    }

    protected List<String> getHelpLines() {
        return ImmutableList.of();
    }
}

