/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.LinkedList;
import java.util.List;

public abstract class Option {
    private final String shortName;
    private final String longName;
    private final boolean isFlag;
    private Style style;
    private List<String> values;

    public Option(String shortName, String longName, boolean isFlag) {
        this.shortName = shortName;
        this.longName = longName;
        this.isFlag = isFlag;
        this.values = new LinkedList<String>();
    }

    public boolean isFlag() {
        return this.isFlag;
    }

    public Style getArgStyle() {
        return this.style;
    }

    public String getValue() {
        return Iterables.getLast(this.values, null);
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public String toString() {
        String string = this.shortName;
        String string2 = this.longName;
        boolean bl = this.isFlag;
        String string3 = String.valueOf((Object)this.style);
        String string4 = String.valueOf(this.values);
        return new StringBuilder(66 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Option{shortName='").append(string).append('\'').append(", longName='").append(string2).append('\'').append(", isFlag=").append(bl).append(", style=").append(string3).append(", values='").append(string4).append('\'').append('}').toString();
    }

    public abstract void apply();

    public List<String> getHelpLines() {
        return ImmutableList.of();
    }

    boolean parse(String[] args, int currentArg) {
        String argVal = args[currentArg];
        if (this.shortName != null) {
            String string = String.valueOf(this.shortName);
            if (argVal.equals(string.length() != 0 ? "-".concat(string) : new String("-"))) {
                if (this.isFlag()) {
                    return true;
                }
                if (currentArg + 1 == args.length) {
                    throw new IllegalArgumentException(String.valueOf(this.shortName).concat(" requires an argument.\n"));
                }
                this.values.add(args[currentArg + 1]);
                this.style = Style.Short;
                return true;
            }
        }
        if (this.longName != null) {
            if (this.isFlag()) {
                String string = String.valueOf(this.longName);
                return argVal.equals(string.length() != 0 ? "--".concat(string) : new String("--"));
            }
            String string = this.longName;
            if (!argVal.startsWith(new StringBuilder(3 + String.valueOf(string).length()).append("--").append(string).append("=").toString())) {
                return false;
            }
            String[] tokens = argVal.split("=", 2);
            if (tokens.length == 1) {
                String string2 = this.longName;
                String string3 = this.longName;
                throw new IllegalArgumentException(new StringBuilder(43 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" requires an argument, for example, \"").append(string3).append("=FOO\"\n").toString());
            }
            this.values.add(tokens[1]);
            this.style = Style.Long;
            return true;
        }
        return false;
    }

    public static enum Style {
        Short,
        Long;

    }
}

