/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

public class Canonicalize {
    private static final Comparator<OnestoreEntity.Property> PROPERTY_NAME_COMPARATOR = new Comparator<OnestoreEntity.Property>(){

        @Override
        public int compare(OnestoreEntity.Property p1, OnestoreEntity.Property p2) {
            return p1.getName().compareTo(p2.getName());
        }
    };

    public static OnestoreEntity.EntityProto canonicalizeEntity(@Nullable OnestoreEntity.EntityProto entity) {
        if (entity == null) {
            return null;
        }
        OnestoreEntity.EntityProto canonical = (OnestoreEntity.EntityProto)entity.clone();
        canonical.clearProperty().mutablePropertys().addAll(Canonicalize.canonicalizeProperties(entity.propertys()));
        canonical.clearRawProperty().mutableRawPropertys().addAll(Canonicalize.canonicalizeProperties(entity.rawPropertys()));
        return canonical;
    }

    private static List<OnestoreEntity.Property> canonicalizeProperties(List<OnestoreEntity.Property> properties) {
        return Ordering.from(PROPERTY_NAME_COMPARATOR).immutableSortedCopy(Lists.transform(properties, new Function<OnestoreEntity.Property, OnestoreEntity.Property>(){

            @Override
            public OnestoreEntity.Property apply(OnestoreEntity.Property property) {
                return Canonicalize.canonicalizeProperty(property);
            }
        }));
    }

    private static OnestoreEntity.Property canonicalizeProperty(OnestoreEntity.Property property) {
        OnestoreEntity.Property canonical = property;
        if (property.getMeaningEnum() == OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
            try {
                byte[] entityValueBytes = property.getValue().getStringValueAsBytes();
                OnestoreEntity.EntityProto entityValue = OnestoreEntity.EntityProto.parser().parsePartialFrom(entityValueBytes);
                byte[] canonicalBytes = Canonicalize.canonicalizeEntity(entityValue).toByteArray();
                canonical = (OnestoreEntity.Property)canonical.clone();
                canonical.getMutableValue().setStringValueAsBytes(canonicalBytes);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                // empty catch block
            }
        }
        return canonical;
    }

    private Canonicalize() {
    }
}

