/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3ResourceRefFromRepConverter;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.UnifiedIndexValue;
import com.google.common.collect.ImmutableList;
import com.google.storage.onestore.v3.OnestoreEntity;

public class AppEngV3QueryFromRepConverter {
    public static final AppEngV3QueryFromRepConverter INSTANCE = new AppEngV3QueryFromRepConverter();

    private AppEngV3QueryFromRepConverter() {
    }

    public DatastoreV3Pb.CompiledCursor convertCursor(Cursor cursor) throws InvalidConversionException {
        if (cursor.equals(Cursor.EMPTY)) {
            return DatastoreV3Pb.CompiledCursor.getDefaultInstance();
        }
        if (cursor.isRawIndex()) {
            DatastoreV3Pb.CompiledCursor apiCursor = new DatastoreV3Pb.CompiledCursor();
            OnestoreEntity.IndexPosition apiRawIndexCursor = apiCursor.getMutableAbsolutePosition();
            byte[] rawIndexKey = cursor.rawIndexKey();
            if (rawIndexKey != null) {
                apiRawIndexCursor.setKeyAsBytes(rawIndexKey);
            }
            apiRawIndexCursor.setBefore(cursor.before());
            apiRawIndexCursor.setBeforeAscending(cursor.beforeAscending());
            return apiCursor;
        }
        if (cursor.isRegular()) {
            DatastoreV3Pb.CompiledCursor apiCursor = new DatastoreV3Pb.CompiledCursor();
            OnestoreEntity.IndexPostfix apiPostfixCursor = apiCursor.getMutablePostfixPosition();
            EntityRef key = cursor.key();
            if (key != null) {
                apiPostfixCursor.setKey(AppEngV3ResourceRefFromRepConverter.INSTANCE.convertEntityRef(key));
            }
            ImmutableList<PropertyPath> propertyPaths = cursor.propertyPaths();
            ImmutableList<UnifiedIndexValue> indexValues = cursor.indexValues();
            for (int index = 0; index < indexValues.size(); ++index) {
                PropertyPath propertyPath = (PropertyPath)propertyPaths.get(index);
                UnifiedIndexValue indexValue = (UnifiedIndexValue)indexValues.get(index);
                OnestoreEntity.IndexPostfix_IndexValue apiPair = new OnestoreEntity.IndexPostfix_IndexValue();
                apiPair.setPropertyNameAsBytes(propertyPath.asPropertyNameWithDelimiterAmbiguity().bytes());
                apiPair.setValue(this.convertIndexValue(indexValue));
                apiPostfixCursor.addIndexValue(apiPair);
            }
            apiPostfixCursor.setBefore(cursor.before());
            apiPostfixCursor.setBeforeAscending(cursor.beforeAscending());
            return apiCursor;
        }
        throw new AssertionError();
    }

    public OnestoreEntity.PropertyValue convertIndexValue(UnifiedIndexValue indexValue) {
        return indexValue.datastoreIndexValue();
    }
}

