/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.common.base.Strings;
import com.google.storage.onestore.v3.OnestoreEntity;

public class AppEngV3ResourceRefFromRepConverter {
    public static final AppEngV3ResourceRefFromRepConverter INSTANCE = new AppEngV3ResourceRefFromRepConverter();

    private AppEngV3ResourceRefFromRepConverter() {
    }

    public OnestoreEntity.Reference convertEntityRef(EntityRef entityRef) {
        OnestoreEntity.Reference v3EntityRef;
        EntityRef parentEntityRef = entityRef.parent();
        if (parentEntityRef.path().isEmpty()) {
            v3EntityRef = new OnestoreEntity.Reference();
            PartitionRef partitionRef = entityRef.partitionRef();
            DatabaseRef databaseRef = partitionRef.databaseRef();
            String databaseId = databaseRef.databaseId();
            String namespaceId = partitionRef.namespace();
            v3EntityRef.setApp(databaseRef.appId());
            if (!Strings.isNullOrEmpty(databaseId)) {
                v3EntityRef.setDatabaseId(databaseId);
            }
            if (!Strings.isNullOrEmpty(namespaceId)) {
                v3EntityRef.setNameSpace(namespaceId);
            }
            v3EntityRef.setPath(new OnestoreEntity.Path());
        } else {
            v3EntityRef = this.convertEntityRef(parentEntityRef);
        }
        OnestoreEntity.Path.Element v3PathElement = v3EntityRef.getPath().addElement();
        String collectionId = entityRef.collectionId();
        EntityRef.ResourceId resourceId = entityRef.resourceId();
        byte[] collectionIdBytes = ConverterHelper.convertStringToBytesIfNonUtf8("collection id", collectionId);
        if (collectionIdBytes == null) {
            v3PathElement.setType(collectionId);
        } else {
            v3PathElement.setTypeAsBytes(collectionIdBytes);
        }
        if (resourceId != null) {
            String stringResourceId = resourceId.asString();
            if (stringResourceId == null) {
                v3PathElement.setId(resourceId.asLong());
            } else {
                byte[] bytesResourceId = ConverterHelper.convertStringToBytesIfNonUtf8("resource id", stringResourceId);
                if (bytesResourceId == null) {
                    v3PathElement.setName(stringResourceId);
                } else {
                    v3PathElement.setNameAsBytes(bytesResourceId);
                }
            }
        }
        return v3EntityRef;
    }

    public OnestoreEntity.PropertyValue.ReferenceValue convertEntityRefForValue(EntityRef entityRef) {
        OnestoreEntity.PropertyValue.ReferenceValue v3EntityRef;
        EntityRef parentEntityRef = entityRef.parent();
        if (parentEntityRef.pathElements().isEmpty()) {
            v3EntityRef = new OnestoreEntity.PropertyValue.ReferenceValue();
            PartitionRef partitionRef = entityRef.partitionRef();
            DatabaseRef databaseRef = partitionRef.databaseRef();
            v3EntityRef.setApp(databaseRef.appId());
            String databaseId = databaseRef.databaseId();
            String namespaceId = partitionRef.namespace();
            if (!Strings.isNullOrEmpty(databaseId)) {
                v3EntityRef.setDatabaseId(databaseId);
            }
            if (!Strings.isNullOrEmpty(namespaceId)) {
                v3EntityRef.setNameSpace(namespaceId);
            }
        } else {
            v3EntityRef = this.convertEntityRefForValue(parentEntityRef);
        }
        OnestoreEntity.PropertyValue.ReferenceValuePathElement v3PathElement = v3EntityRef.addPathElement();
        String collectionId = entityRef.collectionId();
        EntityRef.ResourceId resourceId = entityRef.resourceId();
        v3PathElement.setType(collectionId);
        if (resourceId != null) {
            String stringResourceId = resourceId.asString();
            if (stringResourceId == null) {
                v3PathElement.setId(resourceId.asLong());
            } else {
                v3PathElement.setName(stringResourceId);
            }
        }
        return v3EntityRef;
    }

    public OnestoreEntity.Path convertEntityRefPath(EntityRef.Path path) {
        OnestoreEntity.Path v3Path = new OnestoreEntity.Path();
        for (EntityRef.PathElement pathElement : path.elements()) {
            OnestoreEntity.Path.Element v3PathElement = v3Path.addElement();
            String collectionId = pathElement.collectionId();
            EntityRef.ResourceId resourceId = pathElement.resourceId();
            byte[] collectionIdBytes = ConverterHelper.convertStringToBytesIfNonUtf8("collection id", collectionId);
            if (collectionIdBytes == null) {
                v3PathElement.setType(collectionId);
            } else {
                v3PathElement.setTypeAsBytes(collectionIdBytes);
            }
            if (resourceId == null) continue;
            String stringResourceId = resourceId.asString();
            if (stringResourceId == null) {
                v3PathElement.setId(resourceId.asLong());
                continue;
            }
            byte[] bytesResourceId = ConverterHelper.convertStringToBytesIfNonUtf8("resource id", stringResourceId);
            if (bytesResourceId == null) {
                v3PathElement.setName(stringResourceId);
                continue;
            }
            v3PathElement.setNameAsBytes(bytesResourceId);
        }
        return v3Path;
    }
}

