/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.validator;

import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.appengv3.AppEngV3DatabaseRefExtractor;
import com.google.cloud.datastore.core.appengv3.UserValueObfuscator;
import com.google.cloud.datastore.core.config.DatastoreCustomizableConfigUtils;
import com.google.cloud.datastore.core.config.proto1api.DatastoreCustomizableConfigPb;
import com.google.cloud.datastore.core.exception.ProblemCode;
import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.names.ProjectIds;
import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntitySize;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.UnifiedIndexValue;
import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.cloud.datastore.core.rep.validator.BaseDatastoreValidator;
import com.google.cloud.datastore.core.rep.validator.DatabaseRefValidator;
import com.google.cloud.datastore.core.rep.validator.ValidationConstraint;
import com.google.cloud.datastore.core.rep.validator.ValidationUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.primitives.Booleans;
import com.google.io.protocol.ProtocolMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class EntityV3Validator
extends BaseDatastoreValidator {
    private final UserValueObfuscator obfuscator;

    public EntityV3Validator(Config.DatastoreConfig config, UserValueObfuscator obfuscator) {
        super(config);
        this.obfuscator = obfuscator;
    }

    public UserValueObfuscator userValueObfuscator() {
        return this.obfuscator;
    }

    public void validateEntity(ValidationConstraint constraint, int maxDepthOverride, OnestoreEntity.EntityProto entity) throws ValidationException {
        int maxDepth = maxDepthOverride != 0 ? maxDepthOverride : (this.config.getUseMaxArrayAndEntityValueDepth() ? this.config.getMaxArrayAndEntityValueDepth() : this.config.getMaxEntityValueDepth());
        this.validateEntity(constraint, maxDepth, entity, 0, 0);
    }

    private void validateEntity(ValidationConstraint constraint, int maxDepth, OnestoreEntity.EntityProto entity, int prefixLength, int depth) throws ValidationException {
        Collection properties;
        ValidationException.validateAssertion(depth <= maxDepth, ProblemCode.VALUE_NESTED_TOO_DEEPLY, this.config.getUseMaxArrayAndEntityValueDepth() ? "At most %s nested array/entity values are supported." : "At most %s nested entity values are supported.", maxDepth);
        if (entity.hasKey()) {
            OnestoreEntity.Reference key = entity.getKey();
            String appId = key.getApp();
            if (appId.isEmpty()) {
                if (this.config.getEnableAppEngV3ValidatorValidateKeyWithoutAppIsEmpty()) {
                    ValidationException.validateAssertion(key.getDatabaseId().isEmpty(), ProblemCode.NON_EMPTY_ENTITY_REF_WITHOUT_APP, "Entity key has database_id but no app.", new Object[0]);
                    ValidationException.validateAssertion(key.getNameSpace().isEmpty(), ProblemCode.NON_EMPTY_ENTITY_REF_WITHOUT_APP, "Entity key has name_space but no app.", new Object[0]);
                    ValidationException.validateAssertion(key.getPath().elements().isEmpty(), ProblemCode.NON_EMPTY_ENTITY_REF_WITHOUT_APP, "Entity key has path but no app.", new Object[0]);
                }
                ValidationException.validateAssertion(constraint.allowMissingKey(), "Entity is missing key.", new Object[0]);
            } else {
                this.validateKey(constraint, key);
                constraint = constraint.withPartitionId(ProjectIds.parseAppId(appId).partitionId());
            }
        } else {
            ValidationException.validateAssertion(constraint.allowMissingKey(), "Entity is missing key.", new Object[0]);
        }
        ValidationException.validateAssertion(this.entityDoesV3GroupMatchKey(entity), ProblemCode.ENTITY_GROUP_DOES_NOT_MATCH_KEY, "OnestoreEntity.EntityProto entity_group does not match key.", new Object[0]);
        ValidationException.validateAssertion(!entity.getOwner().hasNickname(), "nickname is not supported yet", new Object[0]);
        ValidationException.validateAssertion(!this.obfuscator.containsInvalidObfuscatedUserId(entity.getOwner()), "Invalid user id in owner.", new Object[0]);
        LinkedListMultimap<String, OnestoreEntity.Property> propertiesByName = LinkedListMultimap.create();
        for (OnestoreEntity.Property property : entity.propertys()) {
            this.validateProperty(constraint, property, true, prefixLength, depth, maxDepth);
            propertiesByName.put(property.getName(), property);
        }
        for (OnestoreEntity.Property property : entity.rawPropertys()) {
            this.validateProperty(constraint, property, false, prefixLength, depth, maxDepth);
            propertiesByName.put(property.getName(), property);
        }
        for (String propertyName : propertiesByName.keySet()) {
            properties = propertiesByName.get((Object)propertyName);
            if (properties.size() <= 1) continue;
            for (OnestoreEntity.Property property : properties) {
                ValidationException.validateAssertion(property.isMultiple(), "Repeated property does not have multiple flag set.", new Object[0]);
            }
        }
        ValidationException.validateAssertion(entity.propertySize() <= this.config.getMaxIndexedProperties(), "Too many indexed properties", new Object[0]);
        for (String propertyName : propertiesByName.keySet()) {
            properties = propertiesByName.get((Object)propertyName);
            for (OnestoreEntity.Property prop : properties) {
                if (!prop.getMeaningEnum().equals(OnestoreEntity.Property.Meaning.EMPTY_LIST)) continue;
                ValidationException.validateAssertion(properties.size() == 1, "An empty list must have only one property", new Object[0]);
                ValidationException.validateAssertion(prop.getValue().equals(OnestoreEntity.PropertyValue.getDefaultInstance()), "An empty list must not have a value set", new Object[0]);
                ValidationException.validateAssertion(!prop.isMultiple(), "Empty lists cannot be multiple", new Object[0]);
            }
        }
        if (this.config.getEnableAppEngV3ValidateEntityNoUnknownFields()) {
            ValidationException.validateAssertion(entity.getUnknownFields().asMap().isEmpty(), ProblemCode.ENTITY_WITH_UNKNOWN_FIELDS, "Unknown fields in an entity.", new Object[0]);
            this.validateNoUnknownFieldsRecursive(entity);
        }
    }

    @VisibleForTesting
    <T extends ProtocolMessage<T>> void validateNoUnknownFieldsRecursive(ProtocolMessage<T> message) throws ValidationException {
        if (message == null) {
            return;
        }
        if (!message.getUnknownFields().asMap().isEmpty()) {
            String string = String.valueOf(message.getClass().getSimpleName());
            throw new ValidationException(string.length() != 0 ? "Unknown fields in a nested Onestore ".concat(string) : new String("Unknown fields in a nested Onestore "), ProblemCode.ENTITY_WITH_UNKNOWN_FIELDS);
        }
        Map<Descriptors.FieldDescriptor, Object> fields = message.getAllFields();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : fields.entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
            if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
            Object fieldValue = entry.getValue();
            if (fieldDescriptor.isRepeated()) {
                List nestedMessages = (List)fieldValue;
                for (ProtocolMessage nestedMessage : nestedMessages) {
                    this.validateNoUnknownFieldsRecursive(nestedMessage);
                }
                continue;
            }
            ProtocolMessage nestedMessage = (ProtocolMessage)fieldValue;
            this.validateNoUnknownFieldsRecursive(nestedMessage);
        }
    }

    private boolean entityDoesV3GroupMatchKey(OnestoreEntity.EntityProto v3Entity) {
        if (!this.config.getEnableAppEngV3ValidatorValidateEntityGroupMatchesKey()) {
            return true;
        }
        if (v3Entity.getEntityGroup().elements().isEmpty()) {
            return true;
        }
        List<OnestoreEntity.Path.Element> v3GroupPathElements = v3Entity.getEntityGroup().elements();
        List<OnestoreEntity.Path.Element> v3KeyPathElements = v3Entity.getKey().getPath().elements();
        if (v3KeyPathElements.isEmpty()) {
            return false;
        }
        return v3GroupPathElements.get(0).equals(v3KeyPathElements.get(0));
    }

    public void validateNoNameCollisionStrict(OnestoreEntity.EntityProto entity) throws ValidationException {
        boolean allowPathDelimiter = true;
        for (OnestoreEntity.Property property : entity.propertys()) {
            if (property.getMeaningEnum() != OnestoreEntity.Property.Meaning.ENTITY_PROTO) continue;
            allowPathDelimiter = false;
            break;
        }
        if (!allowPathDelimiter) {
            this.validateNoPathDelimiter(entity);
        }
    }

    private void validateNoPathDelimiter(OnestoreEntity.EntityProto entity) throws ValidationException {
        for (OnestoreEntity.Property property : entity.propertys()) {
            boolean hasDelimiter = false;
            for (byte b : property.getNameAsBytes()) {
                if (b != 46) continue;
                hasDelimiter = true;
                break;
            }
            ValidationException.validateAssertion(!hasDelimiter, "property.name contains a path delimiter, and the entity contains one or more indexed entity value.", new Object[0]);
            if (property.getMeaningEnum() != OnestoreEntity.Property.Meaning.ENTITY_PROTO) continue;
            try {
                this.validateNoPathDelimiter(OnestoreEntity.EntityProto.parser().parsePartialFrom(property.getValue().getStringValueAsBytes()));
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {}
        }
    }

    public void validateNoNameCollisionRelaxed(OnestoreEntity.EntityProto entity) throws ValidationException {
        HashSet<String> entityNames = new HashSet<String>();
        HashSet<String> namePrefixes = new HashSet<String>();
        for (OnestoreEntity.Property property : entity.propertys()) {
            this.checkNameCollision(entityNames, namePrefixes, property);
            if (property.getMeaningEnum() != OnestoreEntity.Property.Meaning.ENTITY_PROTO) continue;
            try {
                this.validateNoNameCollisionRelaxed(OnestoreEntity.EntityProto.parser().parsePartialFrom(property.getValue().getStringValueAsBytes()));
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {}
        }
    }

    private void checkNameCollision(Set<String> entityNames, Set<String> namePrefixes, OnestoreEntity.Property property) throws ValidationException {
        int index;
        String name = property.getName();
        if (property.getMeaningEnum() == OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
            ValidationException.validateAssertion(!namePrefixes.contains(name), "Entity has a nested entity property named '%s' as well as a property prefixed with '%s.', this results in name collision.", name, name);
            entityNames.add(name);
        }
        while ((index = name.lastIndexOf(46)) > 0) {
            ValidationException.validateAssertion(!entityNames.contains(name = name.substring(0, index)), "Entity has a nested entity property named '%s' as well as a property prefixed with '%s.', this results in name collision.", name, name);
            namePrefixes.add(name);
        }
    }

    public void validateNamespace(ValidationConstraint constraint, String namespace) throws ValidationException {
        ValidationException.validateAssertion(!namespace.isEmpty(), "The namespace is the empty string.", new Object[0]);
        ValidationException.validateAssertion(namespace.length() <= 100, "The namespace is longer than %d bytes.", 100);
        this.validatePartitionIdDimension(constraint, namespace, "namespace");
    }

    public void validateDatabase(ValidationConstraint constraint, String database) throws ValidationException {
        ValidationException.validateAssertion(database.length() <= 100, "The database is longer than %d bytes.", 100);
        this.validatePartitionIdDimension(constraint, database, "database");
    }

    public void validateQueryKey(OnestoreEntity.Reference key, DatabaseRef internalDatabase, @Nullable String namespace, boolean validateNamespaces, String desc, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws ValidationException {
        this.validateKey(ValidationConstraint.LOOKUP.withConfigOverrides(configOverrides), key);
        DatabaseRef databaseInKey = AppEngV3DatabaseRefExtractor.INSTANCE.extract(key);
        DatabaseRefValidator.INSTANCE.validateDatabaseRefMatch(databaseInKey, internalDatabase);
        ValidationException.validateAssertion(!validateNamespaces || namespace == null && !key.hasNameSpace() || "__all__".equals(namespace) || namespace != null && namespace.equals(key.getNameSpace()), "The query namespace is '%s' but %s namespace is '%s'.", namespace, desc, key.getNameSpace());
    }

    public void validateKey(ValidationConstraint constraint, OnestoreEntity.Reference key) throws ValidationException {
        int keySizeLimit;
        boolean finalElementComplete;
        OnestoreEntity.Path path;
        int numKeyPathElements;
        this.validateAppId(constraint, key.getApp());
        if (key.hasNameSpace()) {
            this.validateNamespace(constraint, key.getNameSpace());
        }
        if (!this.config.getAllowDatabases()) {
            ValidationException.validateAssertion(key.getDatabaseId().isEmpty(), ProblemCode.NO_DB_SUPPORT, "Database support is not enabled.", new Object[0]);
        }
        if (key.hasDatabaseId()) {
            this.validateDatabase(constraint, key.getDatabaseId());
        }
        ValidationException.validateAssertion((numKeyPathElements = (path = key.getPath()).elementSize()) != 0, "Key path is empty.", new Object[0]);
        ValidationException.validateAssertion(numKeyPathElements <= 100, "Key path is too long. Cannot exceed %d elements.", 100);
        int numIncompleteElements = 0;
        for (int pathIndex = 0; pathIndex < numKeyPathElements; ++pathIndex) {
            OnestoreEntity.Path.Element element = path.getElement(pathIndex);
            this.validateKind(constraint, ByteString.copyFrom(element.getTypeAsBytes()));
            boolean elementHasName = element.hasName();
            if (element.hasId()) {
                ValidationException.validateAssertion(!elementHasName, "Key path element has both id (%d) and name (\"%s\").", element.getId(), element.getName());
                if (pathIndex < numKeyPathElements - 1) {
                    ValidationException.validateAssertion(element.getId() != 0L, "Key path element id is invalid. Must not be zero.", new Object[0]);
                    continue;
                }
                if (element.getId() != 0L) continue;
                ++numIncompleteElements;
                continue;
            }
            if (elementHasName) {
                String desc = "key path element name";
                ByteString name = ByteString.copyFrom(element.getNameAsBytes());
                if (constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateKeyNameUtf8()) {
                    ValidationUtils.INSTANCE.validateStringUtf8(name, ProblemCode.KEY_NAME_NOT_UTF8, desc);
                }
                this.validateStringNotEmpty(name, desc);
                this.validateLength(name, this.config.getMaxIndexedValueBytes(), desc);
                if (constraint.allowReservedKey()) continue;
                this.validateStringNotReserved(name, desc);
                continue;
            }
            ++numIncompleteElements;
        }
        OnestoreEntity.Path.Element finalElement = key.getPath().getElement(numKeyPathElements - 1);
        boolean bl = finalElementComplete = finalElement.hasId() && finalElement.getId() != 0L || finalElement.hasName();
        if (!constraint.allowCompleteKey()) {
            String string = String.valueOf(V3Paths.toPathString(key));
            ValidationException.validateAssertion(!finalElementComplete, string.length() != 0 ? "Key path element must not be complete: ".concat(string) : new String("Key path element must not be complete: "), new Object[0]);
        }
        if (!constraint.allowIncompleteKey(this.config.getAllowIncompleteKeyPathsInQueryFilters())) {
            String string = String.valueOf(V3Paths.toPathString(key));
            ValidationException.validateAssertion(finalElementComplete, ProblemCode.INCOMPLETE_KEY_PATHS_IN_QUERY_FILTERS, string.length() != 0 ? "Key path element must not be incomplete: ".concat(string) : new String("Key path element must not be incomplete: "), new Object[0]);
        }
        String string = String.valueOf(V3Paths.toPathString(key));
        ValidationException.validateAssertion(numIncompleteElements == (finalElementComplete ? 0 : 1), string.length() != 0 ? "Key path element must not be incomplete: ".concat(string) : new String("Key path element must not be incomplete: "), new Object[0]);
        if (constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateEntityRefIntraPartition()) {
            String constraintPartitionId = constraint.partitionId();
            String keyPartitionId = ProjectIds.parseAppId(key.getApp()).partitionId();
            ValidationException.validateAssertion(constraintPartitionId == null || constraintPartitionId.equals(keyPartitionId), ProblemCode.CROSS_PARTITION_ENTITY_REF, "Entity key's app id's partition id '%s' does not match containing entity's '%s'.", keyPartitionId, constraintPartitionId);
        }
        if ((keySizeLimit = constraint.getCustomizableConfig(this.config).getMaxEntityKeySizeBytes()) > 0) {
            this.validateLength(EntitySize.keySize(key), keySizeLimit, ProblemCode.KEY_SIZE_OVER_LIMIT, "entity key");
        }
    }

    public void validateReference(ValidationConstraint constraint, OnestoreEntity.PropertyValue.ReferenceValue ref) throws ValidationException {
        this.validateKey(constraint.withContext(ValidationConstraint.Context.IN_KEY_VALUE), V3Paths.toReference(ref));
    }

    public void validateCursor(ValidationConstraint constraint, Cursor compiledCursor, DatabaseRef internalDatabase, @Nullable String namespace, @Nullable String kind, boolean allowInMemoryOps, boolean validateNamespaces) throws ValidationException {
        ValidationException.validateAssertion(!allowInMemoryOps, "Cursors can only be used with perfect plans.", new Object[0]);
        if (compiledCursor.isRegular()) {
            if (compiledCursor.key() != null) {
                OnestoreEntity.Reference key = compiledCursor.key().v3Reference();
                this.validateQueryKey(key, internalDatabase, namespace, validateNamespaces, "cursor.postfix_position", constraint.configOverrides());
                if (kind != null) {
                    String keyKind = V3Paths.kind(key);
                    ValidationException.validateAssertion(kind.equals(keyKind), "The query kind is %s but cursor.postfix_position.key kind is %s.", kind, keyKind);
                }
            }
            ImmutableList<PropertyPath> propertyPaths = compiledCursor.propertyPaths();
            ImmutableList<UnifiedIndexValue> indexValues = compiledCursor.indexValues();
            for (int index = 0; index < indexValues.size(); ++index) {
                PropertyPath propertyPath = (PropertyPath)propertyPaths.get(index);
                UnifiedIndexValue indexValue = (UnifiedIndexValue)indexValues.get(index);
                ValidationException.validateAssertion(!propertyPath.isKey(), "index data should not include primary key", new Object[0]);
                ValidationException.validateAssertion(indexValue.isDatastore(), "invalid index value in cursor", new Object[0]);
                OnestoreEntity.PropertyValue v3Value = indexValue.datastoreIndexValue();
                this.validatePropertyValueUnion(v3Value, propertyPath.asStringLossy());
                this.validatePropertyValueComposite(constraint, v3Value);
            }
        }
    }

    public void validateProperty(ValidationConstraint constraint, OnestoreEntity.Property property, boolean indexed) throws ValidationException {
        this.validateProperty(constraint, property, indexed, 0, 0, Integer.MAX_VALUE);
    }

    private void validateProperty(ValidationConstraint constraint, OnestoreEntity.Property property, boolean indexed, int prefixLength, int depth, int maxDepth) throws ValidationException {
        OnestoreEntity.PropertyValue value = property.getValue();
        ByteString name = ByteString.copyFrom(property.getNameAsBytes());
        if (this.config.getEnableAppEngV3ValidatePropertyNameUtf8()) {
            ValidationException.validateAssertion(name.isValidUtf8(), ProblemCode.PROPERTY_NAME_NOT_UTF8, "Property name is not UTF-8.", new Object[0]);
        }
        ValidationException.validateAssertion(!property.hasStashed(), "Property \"%s\" has field stashed", property.getName());
        ValidationException.validateAssertion(!property.hasComputed(), "Property \"%s\" has field computed", property.getName());
        if (indexed) {
            ValidationException.validateAssertion(constraint.allowUnindexableValue() || this.isIndexablePropertyMeaning(property.getMeaningEnum()), "Property \"%s\" has a value meaning %s that cannot be indexed.", property.getName(), property.getMeaningEnum().toString());
        }
        this.validatePropertyName(constraint, ByteString.copyFrom(property.getNameAsBytes()), prefixLength, "");
        this.validatePropertyValueUnion(value, property.getName());
        this.validatePropertyValueComposite(constraint, value);
        if (this.config.getUseMaxArrayAndEntityValueDepth() && property.isMultiple()) {
            ValidationException.validateAssertion(++depth <= maxDepth, "At most %s nested array/entity values are supported.", maxDepth);
        }
        if (value.hasStringValue()) {
            this.validatePropertyValueString(constraint, property, indexed);
            if (property.getMeaningEnum() == OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
                this.validateEntityValue(constraint, indexed, property, prefixLength + name.size() + ".".length(), depth + 1, maxDepth);
            }
        }
        this.validatePropertyValueUnionMatchesMeaning(property, constraint.configOverrides());
        this.validatePropertyValueMeaningUri(property);
        if (!constraint.allowIndexOnlyMeaning()) {
            ValidationException.validateAssertion(property.getMeaningEnum() != OnestoreEntity.Property.Meaning.INDEX_VALUE, "Projection property cannot be used.", new Object[0]);
        }
    }

    private void validatePropertyValueMeaningUri(OnestoreEntity.Property property) throws ValidationException {
        if (!this.config.getEnableAppEngV3ValidatorValidateMeaningUriZlib()) {
            return;
        }
        if (!property.hasMeaningUri()) {
            return;
        }
        String propertyName = property.getName();
        String uriMeaning = property.getMeaningUri();
        ValidationException.validateAssertion(uriMeaning.equals("ZLIB"), "Unknown meaning_uri \"%s\" for property %s.", uriMeaning, propertyName);
        ValidationException.validateAssertion(property.getValue().hasStringValue(), "Property %s has meaning_uri but its value is not a string.", propertyName);
        ValidationException.validateAssertion(property.getMeaningEnum() == OnestoreEntity.Property.Meaning.BLOB, "Property %s has meaning_uri but its meaning is not BLOB.", propertyName);
    }

    private void validatePropertyValueUnionMatchesMeaning(OnestoreEntity.Property property, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws ValidationException {
        if (!DatastoreCustomizableConfigUtils.getCustomizableConfig(this.config, configOverrides).getEnableAppEngV3ValidatorValidateValueMeaningMatchesType()) {
            if (property.getMeaningEnum() == OnestoreEntity.Property.Meaning.BLOB || property.getMeaningEnum() == OnestoreEntity.Property.Meaning.TEXT || property.getMeaningEnum() == OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
                ValidationException.validateAssertion(property.getValue().hasStringValue(), ProblemCode.PROPERTY_VALUE_MEANING_DOES_NOT_MATCH_TYPE, "BLOB / ENTITY_PROTO / TEXT raw property %s must have a string value", property.getName());
            }
            return;
        }
        OnestoreEntity.PropertyValue v3Value = property.getValue();
        switch (property.getMeaningEnum()) {
            case NO_MEANING: {
                ValidationException.validateAssertion(!DatastoreCustomizableConfigUtils.getCustomizableConfig(this.config, configOverrides).getEnableValidateGeoPointSameMeaning() || !v3Value.hasPointValue(), ProblemCode.GEO_POINT_HAS_UNEXPECTED_MEANING, "OnestoreEntity.PropertyValue meaning does not match value fields.", new Object[0]);
                break;
            }
            case INDEX_VALUE: {
                break;
            }
            case EMPTY_LIST: {
                ValidationException.validateAssertion(Booleans.countTrue(v3Value.hasInt64Value(), v3Value.hasStringValue(), v3Value.hasBooleanValue(), v3Value.hasDoubleValue(), v3Value.hasPointValue(), v3Value.hasUserValue(), v3Value.hasReferenceValue()) == 0, "OnestoreEntity.PropertyValue meaning does not match value fields.", new Object[0]);
                break;
            }
            case BLOB: 
            case TEXT: 
            case BYTESTRING: 
            case ATOM_CATEGORY: 
            case ATOM_LINK: 
            case ATOM_TITLE: 
            case ATOM_CONTENT: 
            case ATOM_SUMMARY: 
            case ATOM_AUTHOR: 
            case GD_EMAIL: 
            case GD_IM: 
            case GD_PHONENUMBER: 
            case GD_POSTALADDRESS: 
            case BLOBKEY: 
            case ENTITY_PROTO: {
                ValidationException.validateAssertion(property.getValue().hasStringValue(), "%s property %s must have a string value", property.getMeaningEnum(), property.getName());
                break;
            }
            case GD_WHEN: 
            case GD_RATING: {
                ValidationException.validateAssertion(v3Value.hasInt64Value(), "OnestoreEntity.PropertyValue meaning does not match value fields.", new Object[0]);
                break;
            }
            case GEORSS_POINT: {
                ValidationException.validateAssertion(v3Value.hasPointValue(), "OnestoreEntity.PropertyValue meaning does not match value fields.", new Object[0]);
            }
        }
    }

    private void validatePropertyValueUnion(OnestoreEntity.PropertyValue value, String propertyName) throws ValidationException {
        int numValues = Booleans.countTrue(value.hasInt64Value(), value.hasStringValue(), value.hasBooleanValue(), value.hasDoubleValue(), value.hasPointValue(), value.hasUserValue(), value.hasReferenceValue());
        ValidationException.validateAssertion(numValues <= 1, "The value \"%s\" has multiple types set.", propertyName);
    }

    private void validatePropertyValueComposite(ValidationConstraint constraint, OnestoreEntity.PropertyValue value) throws ValidationException {
        if (value.hasReferenceValue()) {
            this.validateReference(constraint.withContext(ValidationConstraint.Context.IN_KEY_VALUE), value.getReferenceValue());
        } else if (value.hasPointValue()) {
            if (constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateGeoPoint()) {
                this.validateGeoPoint(value.getPointValue());
            }
        } else if (value.hasUserValue()) {
            OnestoreEntity.PropertyValue.UserValue v3UserValue = value.getUserValue();
            ValidationException.validateAssertion(!v3UserValue.hasNickname(), "nickname is not supported yet", new Object[0]);
            ValidationException.validateAssertion(!this.obfuscator.containsInvalidObfuscatedUserId(v3UserValue), "Invalid user id in user value.", new Object[0]);
            this.validateUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.email", v3UserValue.getEmailAsBytes());
            this.validateUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.authDomain", v3UserValue.getAuthDomainAsBytes());
            if (v3UserValue.hasFederatedIdentity()) {
                this.validateUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.federatedIdentity", v3UserValue.getFederatedIdentityAsBytes());
            }
            if (v3UserValue.hasFederatedProvider()) {
                this.validateUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.federatedProvider", v3UserValue.getFederatedProviderAsBytes());
            }
        }
    }

    private void validateUserFieldBytesAreValidUtf8(String fieldName, byte[] bytes) throws ValidationException {
        if (!this.config.getEnableAppEngV3ValidateUserFieldValuesUtf8()) {
            return;
        }
        ValidationException.validateAssertion(ByteString.copyFrom(bytes).isValidUtf8(), ProblemCode.USER_FIELD_VALUE_NOT_UTF8, "Non-UTF-8 bytes in user field %s.", fieldName);
    }

    private void validatePropertyValueString(ValidationConstraint constraint, OnestoreEntity.Property property, boolean indexed) throws ValidationException {
        OnestoreEntity.Property.Meaning v3Meaning;
        ByteString byteString = ByteString.copyFrom(property.getValue().getStringValueAsBytes());
        OnestoreEntity.Property.Meaning meaning = v3Meaning = property.hasMeaning() ? property.getMeaningEnum() : null;
        if (v3Meaning == OnestoreEntity.Property.Meaning.NO_MEANING) {
            v3Meaning = null;
        }
        if (!byteString.isValidUtf8() && !this.mayStringValueWithMeaningBeNonUtf8(constraint, v3Meaning)) {
            if (v3Meaning == null) {
                ValidationException.validateAssertion(!constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateValueStringUtf8(), ProblemCode.PROPERTY_VALUE_STRING_NOT_UTF8, "Ordinary OnestoreEntity.PropertyValue.string_value is not UTF-8.", new Object[0]);
            } else {
                ValidationException.validateAssertion(!constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateValueStringUtf8WithMeaning(), ProblemCode.PROPERTY_VALUE_STRING_WITH_MEANING_NOT_UTF8, "OnestoreEntity.PropertyValue.string_value with meaning %s is not UTF-8.", v3Meaning);
            }
        }
        if (v3Meaning == OnestoreEntity.Property.Meaning.ATOM_LINK) {
            this.validateLength(byteString, this.config.getMaxAtomLinkBytes(), "Url value");
            return;
        }
        int maxLength = indexed && property.getMeaningEnum() != OnestoreEntity.Property.Meaning.ENTITY_PROTO ? this.config.getMaxIndexedValueBytes() : this.config.getMaxRawPropertyBytes();
        String string = property.getName();
        this.validateLength(byteString, maxLength, new StringBuilder(20 + String.valueOf(string).length()).append("value of property \"").append(string).append("\"").toString());
    }

    private boolean mayStringValueWithMeaningBeNonUtf8(ValidationConstraint constraint, @Nullable OnestoreEntity.Property.Meaning v3Meaning) {
        return v3Meaning == null || v3Meaning == OnestoreEntity.Property.Meaning.TEXT || v3Meaning == OnestoreEntity.Property.Meaning.ENTITY_PROTO || v3Meaning == OnestoreEntity.Property.Meaning.BLOB || v3Meaning == OnestoreEntity.Property.Meaning.BYTESTRING || constraint.allowIndexOnlyMeaning();
    }

    private void validateEntityValue(ValidationConstraint constraint, boolean indexed, OnestoreEntity.Property property, int newPrefixLength, int newDepth, int maxDepth) throws ValidationException {
        if (!indexed) {
            if (!this.config.getEnableAppEngV3ValidateUnindexedValueEntityProto()) {
                return;
            }
            constraint = constraint.withContext(ValidationConstraint.Context.IN_UNINDEXED_VALUE);
        }
        try {
            OnestoreEntity.EntityProto v3Entity;
            try {
                v3Entity = OnestoreEntity.EntityProto.parser().parsePartialFrom(property.getValue().getStringValueAsBytes());
            }
            catch (InvalidProtocolBufferException e) {
                String string = property.getName();
                throw new ValidationException(new StringBuilder(48 + String.valueOf(string).length()).append("Property ").append(string).append(" does not contain a well formed entity.").toString(), ProblemCode.PROTO_SERIALIZATION_FAILURE);
            }
            this.validateEntity(constraint.withContext(ValidationConstraint.Context.IN_ENTITY_VALUE), maxDepth, v3Entity, newPrefixLength, newDepth);
        }
        catch (ValidationException exception) {
            if (indexed || exception instanceof UnindexedNestedEntityValidationException) {
                throw exception;
            }
            String string = property.getName();
            throw new UnindexedNestedEntityValidationException(new StringBuilder(44 + String.valueOf(string).length()).append("Property ").append(string).append(" contains an invalid nested entity.").toString(), exception);
        }
    }

    public void validateKeyValue(OnestoreEntity.PropertyValue value, DatabaseRef expectedDatabase, @Nullable String namespace, String desc) throws ValidationException {
        ValidationException.validateAssertion(value.hasReferenceValue(), "%s value must be a Key", desc);
        OnestoreEntity.PropertyValue.ReferenceValue refVal = value.getReferenceValue();
        DatabaseRef dbName = AppEngV3DatabaseRefExtractor.INSTANCE.extract(value.getReferenceValue());
        DatabaseRefValidator.INSTANCE.validateDatabaseRefMatch(dbName, expectedDatabase);
        ValidationException.validateAssertion(namespace == null && !refVal.hasNameSpace() || "__all__".equals(namespace) || refVal.getNameSpace().equals(namespace), "%s namespace is %s but query namespace is %s", desc, refVal.getNameSpace(), namespace);
    }

    public void validateGeoPoint(OnestoreEntity.PropertyValue.PointValue point) throws ValidationException {
        this.validateGeoPoint(point.getX(), point.getY());
    }

    private boolean isIndexablePropertyMeaning(OnestoreEntity.Property.Meaning meaning) {
        return meaning != OnestoreEntity.Property.Meaning.BLOB && meaning != OnestoreEntity.Property.Meaning.TEXT && (this.config.getEnableIndexedEntityValues() || meaning != OnestoreEntity.Property.Meaning.ENTITY_PROTO);
    }

    private boolean isIndexablePropertySize(OnestoreEntity.Property property) {
        if (!property.getValue().hasStringValue() || property.getMeaningEnum() == OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
            return true;
        }
        int maxBytes = property.getMeaningEnum() == OnestoreEntity.Property.Meaning.ATOM_LINK ? this.config.getMaxAtomLinkBytes() : this.config.getMaxIndexedValueBytes();
        return property.getValue().getStringValueAsBytes().length <= maxBytes;
    }

    public boolean isIndexableProperty(OnestoreEntity.Property property) {
        return this.isIndexablePropertyMeaning(property.getMeaningEnum()) && this.isIndexablePropertySize(property);
    }

    public static class UnindexedNestedEntityValidationException
    extends ValidationException {
        public UnindexedNestedEntityValidationException(String message, ValidationException cause) {
            super(message, ProblemCode.INVALID_UNINDEXED_PROPERTY_VALUE, cause);
        }
    }
}

