/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.auth.rules;

import com.google.cloud.datastore.core.appengv3.AppEngV3DatabaseRefExtractor;
import com.google.cloud.datastore.core.auth.rules.ResourcePathUtils;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.evaluators.ExternalFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionGuard;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionPathValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.v1.SourcePosition;
import com.google.storage.onestore.v3.OnestoreEntity;

public abstract class BaseResourceFunction
implements ExternalFunction {
    private final FunctionGuard<ListenableFuture<ExecutionResponse>> guard = new FunctionGuard(this.name(), this);
    private final DatabaseRef databaseRef;
    private final Function<OnestoreEntity.Reference, ExpressionValue> loader;

    BaseResourceFunction(DatabaseRef databaseRef, Function<OnestoreEntity.Reference, ExpressionValue> loader) {
        this.databaseRef = databaseRef;
        this.loader = loader;
    }

    @Override
    public ListenableFuture<ExecutionResponse> execute(ExecutionRequest request) {
        try {
            request = this.guard.check(request).executionRequest();
        }
        catch (EvaluationException e) {
            return Futures.immediateFailedFuture(e);
        }
        try {
            ExpressionPathValue pathValue = request.getArguments(0).getPathValue();
            OnestoreEntity.Reference key = BaseResourceFunction.pathToReference(pathValue, request.getSourcePosition(), this.databaseRef);
            return Futures.immediateFuture(ExecutionResponse.newBuilder().setValue(this.loader.apply(key)).build());
        }
        catch (EvaluationException e) {
            return Futures.immediateFailedFuture(e);
        }
    }

    static OnestoreEntity.Reference pathToReference(ExpressionPathValue pathValue, SourcePosition sourcePosition, DatabaseRef databaseRef) throws EvaluationException {
        ImmutableList<String> segments = ExpressionValueUtils.getPathSegments(sourcePosition, pathValue);
        OnestoreEntity.Reference key = ResourcePathUtils.makeReference(segments);
        Preconditions.checkArgument(databaseRef.databaseId().equals(key.getDatabaseId()), "Access to [%s] database is not allowed while authorizing access to [%s] database", (Object)key.getDatabaseId(), (Object)databaseRef.databaseId());
        AppEngV3DatabaseRefExtractor.set(key, databaseRef);
        return key;
    }
}

