/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.auth.rules;

import com.google.cloud.datastore.core.auth.rules.Constants;
import com.google.cloud.datastore.core.auth.rules.EntityToExpressionValueConverter;
import com.google.cloud.datastore.core.auth.rules.ExistsResourceFunction;
import com.google.cloud.datastore.core.auth.rules.GetAfterResourceFunction;
import com.google.cloud.datastore.core.auth.rules.GetResourceFunction;
import com.google.cloud.datastore.core.auth.rules.ResourcePathUtils;
import com.google.cloud.datastore.core.auth.rules.RulesAuthorizerImpl;
import com.google.cloud.datastore.core.auth.rules.RulesRequestContext;
import com.google.cloud.datastore.core.auth.rules.Trackable;
import com.google.cloud.datastore.core.auth.rules.TrackingLoader;
import com.google.cloud.datastore.core.auth.rules.TrackingVariableSupplier;
import com.google.cloud.datastore.core.auth.rules.ValueResourceFunction;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.firebase.rules.runtime.common.EvaluationListener;
import com.google.firebase.rules.runtime.common.Evaluator;
import com.google.firebase.rules.runtime.common.ExecutionContext;
import com.google.firebase.rules.runtime.common.FieldAccessListener;
import com.google.firebase.rules.runtime.common.ParentPointer;
import com.google.firebase.rules.runtime.evaluators.AuthRuleEvaluator;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.PathUtils;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.ExpressionMapValue;
import com.google.firebase.rules.runtime.v1.ExpressionPathSegmentValue;
import com.google.firebase.rules.runtime.v1.ExpressionPathValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.protobuf.util.Timestamps;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class DatastoreRuleContextBuilder
extends AuthRuleEvaluator.RuleContext.Builder {
    private final RulesRequestContext requestContext;
    private final EntityToExpressionValueConverter entityToExpressionValueConverter;
    private final ExpressionMapValue.Builder requestVariable = ExpressionMapValue.newBuilder();
    private final TrackingVariableSupplier requestVariableTracker = TrackingVariableSupplier.lazyMap(this.requestVariable);
    private boolean trackRequestVariableAccess;

    private DatastoreRuleContextBuilder(RulesRequestContext requestContext, EntityToExpressionValueConverter entityToExpressionValueConverter) {
        this.requestContext = requestContext;
        this.entityToExpressionValueConverter = Preconditions.checkNotNull(entityToExpressionValueConverter);
        this.supplyRequestField(Constants.RequestFields.TIME, ExpressionValueUtils.createValue((Object)Timestamps.fromMillis(requestContext.startTime().toEpochMilli())));
        this.supplyRequestField(Constants.RequestFields.AUTH, this.makeAuthField(requestContext.rulesValidatedSecurityContext()));
        this.supplyRequestField(Constants.RequestFields.HEADERS, ExpressionValueUtils.createValue(requestContext.httpRequestHeaders()));
        this.supplyRequestField(Constants.RequestFields.IN_TRANSACTION, ExpressionValueUtils.createValue(requestContext.transactionHandle() != null));
    }

    public DatastoreRuleContextBuilder supplyResource(Supplier<ListenableFuture<ExpressionValue>> supplier) {
        this.supplyVariable(Constants.Variables.RESOURCE.getName(), supplier);
        return this;
    }

    public DatastoreRuleContextBuilder supplyResource(ExpressionValue resource) {
        this.supplyVariable(Constants.Variables.RESOURCE.getName(), resource);
        return this;
    }

    public DatastoreRuleContextBuilder path(OnestoreEntity.Reference reference) {
        ExpressionPathValue pathValue = DatastoreRuleContextBuilder.makeReferencePath(reference).build();
        this.path(pathValue);
        return this;
    }

    @Override
    public AuthRuleEvaluator.RuleContext.Builder path(ExpressionPathValue pathValue) {
        this.supplyRequestField(Constants.RequestFields.PATH, DatastoreRuleContextBuilder.pathToRequestPath(pathValue));
        return super.path(pathValue);
    }

    public Trackable trackDynamicCalls() {
        TrackingLoader trackingLoader = new TrackingLoader();
        this.supplyFunction(new GetResourceFunction(this.requestContext.databaseRef(), trackingLoader));
        this.supplyFunction(new ValueResourceFunction(this.requestContext.databaseRef(), trackingLoader));
        this.supplyFunction(new ExistsResourceFunction(this.requestContext.databaseRef(), trackingLoader));
        this.supplyFunction(new GetAfterResourceFunction(this.requestContext.databaseRef(), trackingLoader));
        return trackingLoader;
    }

    public Trackable trackRequestVariableAccess() {
        this.trackRequestVariableAccess = true;
        return this.requestVariableTracker;
    }

    public Trackable trackResourceAccess() {
        TrackingVariableSupplier trackingVariableSupplier = TrackingVariableSupplier.undefined();
        this.supplyVariable(Constants.Variables.RESOURCE.getName(), trackingVariableSupplier);
        return trackingVariableSupplier;
    }

    public DatastoreRuleContextBuilder trackFieldAccesses() {
        this.listeners(ImmutableList.of(() -> new TrackingFieldAccessListener(this.requestContext)));
        return this;
    }

    public DatastoreRuleContextBuilder supplyRequestField(Constants.RequestFields field, ExpressionValue value) {
        this.requestVariable.putFields(field.getName(), value);
        return this;
    }

    public DatastoreRuleContextBuilder supplyTransaction(@Nullable Long transaction) {
        return this.supplyRequestField(Constants.RequestFields.IN_TRANSACTION, ExpressionValueUtils.createValue(transaction != null));
    }

    public DatastoreRuleContextBuilder supplyRequestResource(OnestoreEntity.EntityProto entityProto) {
        if (entityProto == null) {
            this.supplyRequestField(Constants.RequestFields.RESOURCE, ExpressionValueUtils.NULL);
        } else {
            this.supplyRequestField(Constants.RequestFields.RESOURCE, this.entityToExpressionValueConverter.convert(entityProto));
        }
        return this;
    }

    public AuthRuleEvaluator.RuleContext build(Constants.ActionIds operation) {
        this.service("cloud.firestore");
        this.supplyRequestField(Constants.RequestFields.METHOD, ExpressionValueUtils.createValue((Object)operation.id()));
        if (!this.trackRequestVariableAccess) {
            ExpressionValue requestVariable = ExpressionValueUtils.createValue(this.requestVariable.build());
            this.supplyVariable(Constants.Variables.REQUEST.getName(), requestVariable);
        } else {
            this.supplyVariable(Constants.Variables.REQUEST.getName(), this.requestVariableTracker);
        }
        this.method(operation.id());
        return super.build();
    }

    @Override
    @Deprecated
    public AuthRuleEvaluator.RuleContext build() {
        throw new UnsupportedOperationException("Please call the overloaded build instead.");
    }

    public static DatastoreRuleContextBuilder builder(RulesRequestContext requestContext, EntityToExpressionValueConverter entityToExpressionValueConverter) {
        return new DatastoreRuleContextBuilder(requestContext, entityToExpressionValueConverter);
    }

    static PathUtils.Builder makeReferencePath(EntityRef reference) {
        PathUtils.Builder builder = PathUtils.pathBuilder();
        for (String segment : ResourcePathUtils.partitionRefToPathSegment(reference.partitionRef())) {
            builder.appendSegment(segment);
        }
        for (EntityRef.PathElement element : reference.pathElements()) {
            builder.appendSegment(element.collectionId());
            if (element.resourceId() != null) {
                if (element.resourceId().isLong()) {
                    builder.appendSegment(ResourcePathUtils.idToSegment(element.resourceId().asLong()));
                    continue;
                }
                builder.appendSegment(element.resourceId().asString());
                continue;
            }
            Preconditions.checkArgument(Iterables.getLast(reference.pathElements()) == element, "The incomplete path element can only be the last element of the reference. %s ", (Object)reference);
            builder.appendCapture();
        }
        return builder;
    }

    static PathUtils.Builder makeReferencePath(OnestoreEntity.Reference reference) {
        PathUtils.Builder builder = PathUtils.pathBuilder();
        for (String segment : ResourcePathUtils.partitionRefToPathSegment(PartitionRef.createFromReference(reference))) {
            builder.appendSegment(segment);
        }
        for (OnestoreEntity.Path.Element element : reference.getPath().elements()) {
            builder.appendSegment(element.getType());
            if (element.hasName()) {
                builder.appendSegment(element.getName());
                continue;
            }
            if (element.hasId()) {
                builder.appendSegment(ResourcePathUtils.idToSegment(element.getId()));
                continue;
            }
            Preconditions.checkArgument(Iterables.getLast(reference.getPath().elements()) == element, "The incomplete path element can only be the last element of the reference. %s ", (Object)reference);
            builder.appendCapture();
        }
        return builder;
    }

    static ExpressionValue pathToRequestPath(ExpressionPathValue path) {
        ExpressionPathValue.Builder pathBuilder = ExpressionPathValue.newBuilder();
        block5: for (int i = 0; i < path.getSegmentsCount(); ++i) {
            ExpressionPathSegmentValue segment = path.getSegments(i);
            switch (segment.getKindCase()) {
                case GLOB_CAPTURE: {
                    return RulesAuthorizerImpl.EXPECTED_UNDEFINED;
                }
                case CAPTURE: {
                    if (i == path.getSegmentsCount() - 1) continue block5;
                    return RulesAuthorizerImpl.EXPECTED_UNDEFINED;
                }
                case SIMPLE: {
                    pathBuilder.addSegments(segment);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported path segment type");
                }
            }
        }
        return ExpressionValueUtils.createValue(pathBuilder.build());
    }

    private static class TrackingFieldAccessListener
    implements EvaluationListener {
        private final RulesRequestContext requestContext;
        private final FieldAccessListener fieldAccessListener;

        private TrackingFieldAccessListener(RulesRequestContext requestContext) {
            this.requestContext = requestContext;
            this.fieldAccessListener = new FieldAccessListener();
        }

        @Override
        public void beforeExpression(Expression expression, ParentPointer<ExecutionContext> contextParentPointer) {
            this.fieldAccessListener.beforeExpression(expression, contextParentPointer);
        }

        @Override
        public void afterSinglePermissionEvaluation(Evaluator.Context context, boolean allow, Expression expression) {
            if (allow) {
                this.requestContext.rulesAccessCollector().registerFieldAccesses(this.fieldAccessListener.fieldAccesses());
            }
        }
    }
}

