/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.auth.rules;

import com.google.cloud.datastore.core.auth.rules.ResourcePathUtils;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.ResourceRef;
import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.ValueToLegacyMapValueConverter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.flogger.GoogleLogger;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.v1.ExpressionListValue;
import com.google.firebase.rules.runtime.v1.ExpressionMapValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.Timestamps;
import com.google.storage.onestore.v3.OnestoreEntity;
import com.google.type.LatLng;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class EntityToExpressionValueConverter {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/cloud/datastore/core/auth/rules/EntityToExpressionValueConverter");
    private static final ValueToLegacyMapValueConverter VALUE_TO_LEGACY_MAP_VALUE_CONVERTER = new ValueToLegacyMapValueConverter();

    public ExpressionValue convert(OnestoreEntity.EntityProto entityProto) {
        return this.convert(entityProto, "data");
    }

    private ExpressionValue convert(OnestoreEntity.EntityProto entityProto, @Nullable String userDefinedDataField) {
        HashMap<String, ExpressionValueHolder> expressionValues = new HashMap<String, ExpressionValueHolder>();
        for (OnestoreEntity.Property property : entityProto.propertys()) {
            ExpressionValue expressionValue = this.convertProperty(property);
            this.addExpression(expressionValues, property, expressionValue);
        }
        for (OnestoreEntity.Property property : entityProto.rawPropertys()) {
            ExpressionValue expressionValue = this.convertProperty(property);
            this.addExpression(expressionValues, property, expressionValue);
        }
        ExpressionMapValue.Builder fieldMap = ExpressionMapValue.newBuilder();
        for (Map.Entry entry : expressionValues.entrySet()) {
            fieldMap.putFields((String)entry.getKey(), ((ExpressionValueHolder)entry.getValue()).toExpressionValue());
        }
        if (userDefinedDataField != null) {
            ExpressionMapValue.Builder builder;
            fieldMap = builder = ExpressionMapValue.newBuilder().putFields("data", ExpressionValue.newBuilder().setMapValue(fieldMap).build());
        }
        if (entityProto.hasKey() && entityProto.getKey().hasPath() && entityProto.getKey().getPath().elementSize() > 0 && !V3Paths.hasIncompleteLastElement(entityProto.getKey())) {
            fieldMap.putFields(ReservedName.NAME.asString(), ExpressionValueUtils.segmentsToPathExpressions(ResourcePathUtils.referenceToPathSegments(entityProto.getKey())));
            fieldMap.putFields("id", ExpressionValueUtils.createValue((Object)V3Paths.name(entityProto.getKey())));
        }
        return ExpressionValueUtils.createValue(fieldMap.build());
    }

    private void addExpression(Map<String, ExpressionValueHolder> expressionValuesMap, OnestoreEntity.Property property, ExpressionValue expressionValue) {
        if (expressionValue != null) {
            ExpressionValueHolder expressionValueHolder = expressionValuesMap.get(property.getName());
            if (expressionValueHolder == null) {
                expressionValuesMap.put(property.getName(), new ExpressionValueHolder(expressionValue, property));
            } else {
                expressionValueHolder.addExpressionValue(expressionValue);
            }
        }
    }

    @Nullable
    ExpressionValue convertProperty(OnestoreEntity.Property property) {
        OnestoreEntity.PropertyValue value = property.getValue();
        OnestoreEntity.Property.Meaning meaning = property.getMeaningEnum();
        return this.convertPropertyValue(value, meaning, property.getName());
    }

    @Nullable
    ExpressionValue convertPropertyValue(OnestoreEntity.PropertyValue value, OnestoreEntity.Property.Meaning meaning, String name) {
        if (meaning == OnestoreEntity.Property.Meaning.EMPTY_LIST && value.equals(OnestoreEntity.PropertyValue.getDefaultInstance())) {
            return ExpressionValueUtils.createValue(ExpressionListValue.getDefaultInstance());
        }
        if (value.equals(OnestoreEntity.PropertyValue.getDefaultInstance())) {
            return ExpressionValueUtils.NULL;
        }
        if (value.hasBooleanValue()) {
            return ExpressionValueUtils.createValue(value.isBooleanValue());
        }
        if (value.hasDoubleValue()) {
            return ExpressionValueUtils.createValue(value.getDoubleValue());
        }
        if (value.hasInt64Value()) {
            if (meaning == OnestoreEntity.Property.Meaning.GD_WHEN) {
                return ExpressionValueUtils.createValue((Object)Timestamps.fromMicros(value.getInt64Value()));
            }
            return ExpressionValueUtils.createValue(value.getInt64Value());
        }
        if (value.hasPointValue()) {
            if (meaning == OnestoreEntity.Property.Meaning.GEORSS_POINT) {
                LatLng latLng = LatLng.newBuilder().setLatitude(value.getPointValue().getX()).setLongitude(value.getPointValue().getY()).build();
                return ExpressionValueUtils.createValue((Object)latLng);
            }
            ExpressionMapValue.Builder mapValue = ExpressionMapValue.newBuilder();
            mapValue.putFields("x", ExpressionValueUtils.createValue(value.getPointValue().getX()));
            mapValue.putFields("y", ExpressionValueUtils.createValue(value.getPointValue().getY()));
            return ExpressionValueUtils.createValue(mapValue.build());
        }
        if (value.hasStringValue()) {
            if (meaning == OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
                byte[] serializedEntityV3 = value.getStringValueAsBytes();
                try {
                    OnestoreEntity.EntityProto entity = OnestoreEntity.EntityProto.parser().parsePartialFrom(serializedEntityV3);
                    return this.convert(entity, null);
                }
                catch (InvalidProtocolBufferException exception) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/cloud/datastore/core/auth/rules/EntityToExpressionValueConverter", "convertPropertyValue", 178, "EntityToExpressionValueConverter.java")).log("Unable to convert serialized bytes to entity for property: [%s]", name);
                    return null;
                }
            }
            if (meaning == OnestoreEntity.Property.Meaning.BLOB || meaning == OnestoreEntity.Property.Meaning.BYTESTRING) {
                return ExpressionValueUtils.createValue((Object)ByteString.copyFrom(value.getStringValueAsBytes()));
            }
            return ExpressionValueUtils.createValue((Object)value.getStringValue());
        }
        if (value.hasUserValue()) {
            return null;
        }
        if (value.hasReferenceValue()) {
            return ExpressionValueUtils.createValue(ExpressionValueUtils.segmentsToPathExpressions(ResourcePathUtils.referenceValueToPathSegment(value.getReferenceValue())));
        }
        String string = String.valueOf(value);
        throw new IllegalArgumentException(new StringBuilder(17 + String.valueOf(string).length()).append("Unknown type for ").append(string).toString());
    }

    ExpressionValue convertRepValue(Value value) {
        switch (value.type()) {
            case NULL: {
                return ExpressionValueUtils.NULL;
            }
            case BOOLEAN: {
                return ExpressionValueUtils.createValue(value.asBoolean());
            }
            case LONG: {
                return ExpressionValueUtils.createValue(value.asLong());
            }
            case DOUBLE: {
                return ExpressionValueUtils.createValue(value.asDouble());
            }
            case TIMESTAMP: {
                return ExpressionValueUtils.createValue((Object)value.asTimestamp());
            }
            case STRING: {
                return ExpressionValueUtils.createValue((Object)value.asString());
            }
            case BYTES: {
                return ExpressionValueUtils.createValue((Object)value.asBytes());
            }
            case ENTITY_REF: {
                return ExpressionValueUtils.segmentsToPathExpressions(ResourcePathUtils.entityRefToPathSegment(value.asEntityRef()));
            }
            case RESOURCE_REF: {
                ResourceRef resourceRef = value.asResourceRef();
                if (resourceRef instanceof EntityRef) {
                    return ExpressionValueUtils.segmentsToPathExpressions(ResourcePathUtils.entityRefToPathSegment((EntityRef)resourceRef));
                }
                if (resourceRef instanceof DatabaseRef) {
                    return ExpressionValueUtils.segmentsToPathExpressions(ResourcePathUtils.databaseRefToPathSegment((DatabaseRef)resourceRef));
                }
                if (resourceRef instanceof PartitionRef) {
                    return ExpressionValueUtils.segmentsToPathExpressions(ResourcePathUtils.partitionRefToPathSegment((PartitionRef)resourceRef));
                }
                String string = String.valueOf(resourceRef);
                throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string).length()).append("Unknown resource reference type ").append(string).toString());
            }
            case GEO_POINT: {
                return ExpressionValueUtils.createValue((Object)value.asGeoPoint());
            }
            case ARRAY: {
                ExpressionListValue.Builder listValue = ExpressionListValue.newBuilder();
                for (Value elem : value.asArray()) {
                    listValue.addValues(Preconditions.checkNotNull(this.convertRepValue(elem)));
                }
                return ExpressionValue.newBuilder().setListValue(listValue).build();
            }
            case MAP: {
                ExpressionMapValue.Builder mapValue = ExpressionMapValue.newBuilder();
                for (Map.Entry elem : value.asMap().entrySet()) {
                    mapValue.putFields((String)elem.getKey(), Preconditions.checkNotNull(this.convertRepValue((Value)elem.getValue())));
                }
                return ExpressionValue.newBuilder().setMapValue(mapValue).build();
            }
            case ENTITY: {
                ExpressionMapValue.Builder mapValue = ExpressionMapValue.newBuilder();
                for (Map.Entry elem : value.asEntity().propertyMap().entrySet()) {
                    mapValue.putFields((String)elem.getKey(), Preconditions.checkNotNull(this.convertRepValue((Value)elem.getValue())));
                }
                EntityRef ref = value.asEntity().ref();
                if (!ref.path().isEmpty() && ref.lastPathElement().resourceId() != null) {
                    mapValue.putFields(ReservedName.NAME.asString(), ExpressionValueUtils.createValue(ExpressionValueUtils.segmentsToPathExpressions(ResourcePathUtils.entityRefToPathSegment(ref))));
                }
                return ExpressionValue.newBuilder().setMapValue(mapValue).build();
            }
            case LEGACY_TIMESTAMP_MICROSECONDS: 
            case LEGACY_USER: {
                return this.convertRepValue(VALUE_TO_LEGACY_MAP_VALUE_CONVERTER.shallowConvertValue(value));
            }
        }
        String string = String.valueOf((Object)value.type());
        throw new IllegalArgumentException(new StringBuilder(19 + String.valueOf(string).length()).append("Unknown value type ").append(string).toString());
    }

    private static class ExpressionValueHolder {
        private final List<ExpressionValue> expressionValues = Lists.newArrayList();
        private final boolean multiple;

        public ExpressionValueHolder(ExpressionValue expressionValue, OnestoreEntity.Property property) {
            this.expressionValues.add(expressionValue);
            this.multiple = property.isMultiple();
        }

        public void addExpressionValue(ExpressionValue expressionValue) {
            Preconditions.checkArgument(this.multiple, "Cannot have multiple expression value when the property is not marked as multiple.");
            this.expressionValues.add(expressionValue);
        }

        public ExpressionValue toExpressionValue() {
            if (this.multiple) {
                return ExpressionValueUtils.createValue(ExpressionListValue.newBuilder().addAllValues(this.expressionValues).build());
            }
            return this.expressionValues.get(0);
        }
    }
}

