/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.auth.rules;

import com.google.cloud.datastore.core.auth.rules.EntityToExpressionValueConverter;
import com.google.cloud.datastore.core.auth.rules.LookupHandlers;
import com.google.cloud.datastore.core.auth.rules.LookupsToAuthorize;
import com.google.cloud.datastore.core.auth.rules.RulesRequestContext;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.storage.onestore.v3.OnestoreEntity;

class LazyCollectingSupplier
implements Supplier<ListenableFuture<ExpressionValue>> {
    private final EntityToExpressionValueConverter entityToExpressionValueConverter;
    private final RulesRequestContext requestContext;
    private final ReadResult readResult;
    private ExpressionValue expressionValue;

    public LazyCollectingSupplier(EntityToExpressionValueConverter entityToExpressionValueConverter, RulesRequestContext requestContext, ReadResult readResult) {
        this.entityToExpressionValueConverter = entityToExpressionValueConverter;
        this.requestContext = requestContext;
        this.readResult = readResult;
    }

    @Override
    public ListenableFuture<ExpressionValue> get() {
        return Futures.immediateFuture(this.getExpressionValue());
    }

    public synchronized ExpressionValue getExpressionValue() {
        if (this.expressionValue == null) {
            this.expressionValue = this.readResult.exists() ? this.entityToExpressionValueConverter.convert(this.readResult.entity()) : ExpressionValueUtils.NULL;
            this.requestContext.rulesAccessCollector().registerLookup(LookupsToAuthorize.Lookup.builder().accessType(LookupsToAuthorize.AccessType.GET).key(LookupHandlers.referenceToKey(this.readResult.reference())).updateVersion(this.readResult.exists() ? this.readResult.updateVersion() : 0L).build());
        }
        return this.expressionValue;
    }

    public boolean exists() {
        this.requestContext.rulesAccessCollector().registerLookup(LookupsToAuthorize.Lookup.builder().accessType(LookupsToAuthorize.AccessType.EXISTS).key(LookupHandlers.referenceToKey(this.readResult.reference())).updateVersion(this.readResult.exists() ? this.readResult.updateVersion() : 0L).build());
        return this.readResult.exists();
    }

    public OnestoreEntity.Reference getKey() {
        return this.readResult.reference();
    }
}

