/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.auth.rules;

import com.google.cloud.datastore.core.auth.rules.LookupManager;
import com.google.cloud.datastore.core.auth.rules.LookupsToAuthorize;
import com.google.cloud.datastore.core.auth.rules.RulesAuthorizer;
import com.google.cloud.datastore.core.auth.rules.RulesRequestContext;
import com.google.cloud.datastore.core.auth.rules.RulesStats;
import com.google.cloud.datastore.core.cloudv1.converter.EntityV3V1Converter;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.names.ProjectIdAppIdResolver;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.datastore.v1.Key;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.concurrent.TimeUnit;

class LookupHandlers {
    private static final ProjectIdAppIdResolver RESOLVER = ProjectIdAppIdResolver.PROJECT_ID_RESOLVER;

    LookupHandlers() {
    }

    static RulesAuthorizer.LookupHandler accessCollectorDecorator(final RulesRequestContext requestContext, final RulesAuthorizer.LookupHandler delegate, final Ticker ticker) {
        return new RulesAuthorizer.LookupHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ReadResult lookup(OnestoreEntity.Reference key) {
                boolean success = false;
                long updateVersion = 0L;
                Stopwatch stopwatch = Stopwatch.createStarted(ticker);
                try {
                    ReadResult result = delegate.lookup(key);
                    success = true;
                    if (result.exists()) {
                        updateVersion = result.updateVersion();
                    }
                    ReadResult readResult = result;
                    return readResult;
                }
                finally {
                    long elapsedInMicroSeconds = stopwatch.elapsed(TimeUnit.MICROSECONDS);
                    requestContext.rulesAccessCollector().registerLookup(LookupsToAuthorize.Lookup.builder().accessType(LookupsToAuthorize.AccessType.GET).key(LookupHandlers.referenceToKey(key)).updateVersion(updateVersion).build(), elapsedInMicroSeconds, success);
                    requestContext.stats().accumulate(RulesStats.RulesCategory.RULES_READ_COUNT, 1L);
                    requestContext.stats().accumulate(RulesStats.RulesCategory.RULES_ACCESS_COUNT, 1L);
                    requestContext.stats().accumulate(RulesStats.RulesCategory.RULES_READ_LATENCY_US, elapsedInMicroSeconds);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ReadResult exists(OnestoreEntity.Reference key) {
                boolean success = false;
                long updateVersion = 0L;
                Stopwatch stopwatch = Stopwatch.createStarted(ticker);
                try {
                    ReadResult exists = delegate.exists(key);
                    success = true;
                    if (exists.exists()) {
                        updateVersion = exists.updateVersion();
                    }
                    ReadResult readResult = exists;
                    return readResult;
                }
                finally {
                    long elapsedInMicroSeconds = stopwatch.elapsed(TimeUnit.MICROSECONDS);
                    requestContext.rulesAccessCollector().registerLookup(LookupsToAuthorize.Lookup.builder().accessType(LookupsToAuthorize.AccessType.EXISTS).key(LookupHandlers.referenceToKey(key)).updateVersion(updateVersion).build(), elapsedInMicroSeconds, success);
                    requestContext.stats().accumulate(RulesStats.RulesCategory.RULES_EXISTS_COUNT, 1L);
                    requestContext.stats().accumulate(RulesStats.RulesCategory.RULES_ACCESS_COUNT, 1L);
                    requestContext.stats().accumulate(RulesStats.RulesCategory.RULES_EXISTS_LATENCY_US, elapsedInMicroSeconds);
                }
            }
        };
    }

    static RulesAuthorizer.LookupHandler limitingDecorator(final RulesAuthorizer.LookupHandler delegate, final LookupManager.AccessLimitManager accessLimitManager) {
        return new RulesAuthorizer.LookupHandler(){

            @Override
            public ReadResult lookup(OnestoreEntity.Reference key) {
                accessLimitManager.beforeGet();
                return delegate.lookup(key);
            }

            @Override
            public ReadResult exists(OnestoreEntity.Reference key) {
                accessLimitManager.beforeExists();
                return delegate.exists(key);
            }
        };
    }

    static Key referenceToKey(OnestoreEntity.Reference key) {
        try {
            return EntityV3V1Converter.INSTANCE.toV1Key(RESOLVER, key).build();
        }
        catch (InvalidConversionException e) {
            throw new RuntimeException(e);
        }
    }
}

