/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.auth.rules;

import com.google.cloud.datastore.core.auth.rules.BaseResourceFunction;
import com.google.cloud.datastore.core.auth.rules.DatastoreRuleContextBuilder;
import com.google.cloud.datastore.core.auth.rules.EntityToExpressionValueConverter;
import com.google.cloud.datastore.core.auth.rules.ExistsResourceFunction;
import com.google.cloud.datastore.core.auth.rules.FirebaseRulesAuthorizerOptions;
import com.google.cloud.datastore.core.auth.rules.GetAfterResourceFunction;
import com.google.cloud.datastore.core.auth.rules.GetResourceFunction;
import com.google.cloud.datastore.core.auth.rules.LazyCollectingSupplier;
import com.google.cloud.datastore.core.auth.rules.LookupHandlers;
import com.google.cloud.datastore.core.auth.rules.RulesAuthorizer;
import com.google.cloud.datastore.core.auth.rules.RulesRequestContext;
import com.google.cloud.datastore.core.auth.rules.ValueResourceFunction;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.common.base.Function;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.v1.ExpressionPathValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.v1.SourcePosition;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

class LookupManager {
    private final AccessLimitManager rpcAccessLimitManager;
    @GuardedBy(value="this")
    private final Map<RulesAuthorizer.LookupHandler, LookupCaches> lookupCaches = new HashMap<RulesAuthorizer.LookupHandler, LookupCaches>();
    private final RulesRequestContext requestContext;
    private final EntityToExpressionValueConverter entityToExpressionValueConverter;
    private final FirebaseRulesAuthorizerOptions configurationOptions;
    private final Ticker ticker;

    LookupManager(RulesRequestContext requestContext, EntityToExpressionValueConverter entityToExpressionValueConverter, FirebaseRulesAuthorizerOptions configurationOptions, Ticker ticker) {
        this.requestContext = requestContext;
        this.entityToExpressionValueConverter = entityToExpressionValueConverter;
        this.configurationOptions = configurationOptions;
        this.rpcAccessLimitManager = new AccessLimitManager(configurationOptions.maxAllowedAccess());
        this.ticker = ticker;
    }

    DatastoreRuleContextBuilder addDynamicLookupFunctionsAndVariables(RulesAuthorizer.LookupHandler lookupHandler, DatastoreRuleContextBuilder ruleContextBuilder, LazyCollectingSupplier resourceUnderAuthorization, Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> writeBatch) {
        LookupCaches cache = this.getCaches(this.requestContext, lookupHandler);
        AccessLimitManager perEntityAccessLimitManager = new AccessLimitManager(this.configurationOptions.maxPerEntityAllowedAccess());
        Function loader = reference -> {
            LookupCaches lookupCaches = cache;
            synchronized (lookupCaches) {
                if (reference.equals(resourceUnderAuthorization.getKey())) {
                    return resourceUnderAuthorization.getExpressionValue();
                }
                ExpressionValue value = (ExpressionValue)cache.lookupCache().getIfPresent(reference);
                if (value != null) {
                    return value;
                }
                perEntityAccessLimitManager.beforeGet();
                return cache.lookupCache().getUnchecked((OnestoreEntity.Reference)reference);
            }
        };
        ruleContextBuilder.supplyFunction(new GetResourceFunction(this.requestContext.databaseRef(), loader));
        ruleContextBuilder.supplyFunction(new ValueResourceFunction(this.requestContext.databaseRef(), loader));
        ruleContextBuilder.supplyFunction(new GetAfterResourceFunction(this.requestContext.databaseRef(), reference -> {
            if (!writeBatch.containsKey(reference)) {
                return (ExpressionValue)loader.apply(reference);
            }
            OnestoreEntity.EntityProto postWriteValue = (OnestoreEntity.EntityProto)writeBatch.get(reference);
            return postWriteValue == null ? ExpressionValueUtils.NULL : this.entityToExpressionValueConverter.convert(postWriteValue);
        }));
        ruleContextBuilder.supplyFunction(new ExistsResourceFunction(this.requestContext.databaseRef(), reference -> {
            LookupCaches lookupCaches = cache;
            synchronized (lookupCaches) {
                if (reference.equals(resourceUnderAuthorization.getKey())) {
                    return ExpressionValueUtils.createValue(resourceUnderAuthorization.exists());
                }
                ExpressionValue value = (ExpressionValue)cache.lookupCache().getIfPresent(reference);
                if (value != null) {
                    return ExpressionValueUtils.createValue(!ExpressionValueUtils.isNull(value));
                }
                value = (ExpressionValue)cache.existsCache().getIfPresent(reference);
                if (value != null) {
                    return value;
                }
                perEntityAccessLimitManager.beforeExists();
                return cache.existsCache().getUnchecked((OnestoreEntity.Reference)reference);
            }
        }));
        ruleContextBuilder.supplyResource(resourceUnderAuthorization);
        return ruleContextBuilder;
    }

    DatastoreRuleContextBuilder addDynamicLookupFunctionsAndVariables(RulesAuthorizer.LookupHandler lookupHandler, DatastoreRuleContextBuilder ruleContextBuilder, LazyCollectingSupplier resourceUnderAuthorization) {
        return this.addDynamicLookupFunctionsAndVariables(lookupHandler, ruleContextBuilder, resourceUnderAuthorization, Collections.emptyMap());
    }

    DatastoreRuleContextBuilder addDynamicLookupFunctionsAndVariables(RulesAuthorizer.LookupHandler lookupHandler, DatastoreRuleContextBuilder ruleContextBuilder, ExpressionPathValue resourcePath) {
        LookupCaches cache = this.getCaches(this.requestContext, lookupHandler);
        ruleContextBuilder.supplyFunction(new GetResourceFunction(this.requestContext.databaseRef(), cache.lookupCache()));
        ruleContextBuilder.supplyFunction(new ValueResourceFunction(this.requestContext.databaseRef(), cache.lookupCache()));
        ruleContextBuilder.supplyFunction(new ExistsResourceFunction(this.requestContext.databaseRef(), cache.existsCache()));
        ruleContextBuilder.supplyResource(() -> {
            try {
                return Futures.immediateFuture((ExpressionValue)cache.lookupCache.get(BaseResourceFunction.pathToReference(resourcePath, SourcePosition.getDefaultInstance(), this.requestContext.databaseRef())));
            }
            catch (EvaluationException | ExecutionException e) {
                return Futures.immediateFailedFuture(e);
            }
        });
        return ruleContextBuilder;
    }

    DatastoreRuleContextBuilder addDynamicLookupFunctionsAndVariables(RulesAuthorizer.LookupHandler lookupHandler, DatastoreRuleContextBuilder ruleContextBuilder, Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> writeBatch) {
        LookupCaches cache = this.getCaches(this.requestContext, lookupHandler);
        ruleContextBuilder.supplyFunction(new GetResourceFunction(this.requestContext.databaseRef(), cache.lookupCache()));
        ruleContextBuilder.supplyFunction(new ValueResourceFunction(this.requestContext.databaseRef(), cache.lookupCache()));
        ruleContextBuilder.supplyFunction(new ExistsResourceFunction(this.requestContext.databaseRef(), cache.existsCache()));
        ruleContextBuilder.supplyFunction(new GetAfterResourceFunction(this.requestContext.databaseRef(), reference -> {
            if (writeBatch.containsKey(reference)) {
                OnestoreEntity.EntityProto postWriteValue = (OnestoreEntity.EntityProto)writeBatch.get(reference);
                return postWriteValue == null ? ExpressionValueUtils.NULL : this.entityToExpressionValueConverter.convert(postWriteValue);
            }
            return (ExpressionValue)cache.lookupCache.getUnchecked(reference);
        }));
        return ruleContextBuilder;
    }

    DatastoreRuleContextBuilder addDynamicLookupFunctionsAndVariables(RulesAuthorizer.LookupHandler lookupHandler, DatastoreRuleContextBuilder ruleContextBuilder) {
        return this.addDynamicLookupFunctionsAndVariables(lookupHandler, ruleContextBuilder, Collections.emptyMap());
    }

    private synchronized LookupCaches getCaches(RulesRequestContext requestContext, RulesAuthorizer.LookupHandler lookupHandler) {
        LookupCaches cache = this.lookupCaches.get(lookupHandler);
        if (cache == null) {
            RulesAuthorizer.LookupHandler decoratedLookupHandler = LookupHandlers.limitingDecorator(LookupHandlers.accessCollectorDecorator(requestContext, lookupHandler, this.ticker), this.rpcAccessLimitManager);
            cache = new LookupCaches(decoratedLookupHandler, this.entityToExpressionValueConverter);
            this.lookupCaches.put(lookupHandler, cache);
        }
        return cache;
    }

    private static class LookupCaches {
        private final LoadingCache<OnestoreEntity.Reference, ExpressionValue> lookupCache;
        private final LoadingCache<OnestoreEntity.Reference, ExpressionValue> existsCache;

        LookupCaches(final RulesAuthorizer.LookupHandler lookupHandler, final EntityToExpressionValueConverter entityToExpressionValueConverter) {
            CacheLoader<OnestoreEntity.Reference, ExpressionValue> lookupCacheLoader = new CacheLoader<OnestoreEntity.Reference, ExpressionValue>(this){

                @Override
                public ExpressionValue load(OnestoreEntity.Reference key) throws Exception {
                    ReadResult lookup = lookupHandler.lookup(key);
                    return lookup == null ? ExpressionValueUtils.NULL : entityToExpressionValueConverter.convert(lookup.entity());
                }
            };
            this.lookupCache = CacheBuilder.newBuilder().build(lookupCacheLoader);
            CacheLoader<OnestoreEntity.Reference, ExpressionValue> existsCacheLoader = new CacheLoader<OnestoreEntity.Reference, ExpressionValue>(this){

                @Override
                public ExpressionValue load(OnestoreEntity.Reference key) throws Exception {
                    return ExpressionValueUtils.createValue(lookupHandler.exists(key).exists());
                }
            };
            this.existsCache = CacheBuilder.newBuilder().build(existsCacheLoader);
        }

        LoadingCache<OnestoreEntity.Reference, ExpressionValue> lookupCache() {
            return this.lookupCache;
        }

        LoadingCache<OnestoreEntity.Reference, ExpressionValue> existsCache() {
            return this.existsCache;
        }
    }

    static class AccessLimitManager {
        private final AtomicInteger accessCount = new AtomicInteger(0);
        private final int maxAllowedAccess;

        public AccessLimitManager(int maxAllowedAccess) {
            this.maxAllowedAccess = maxAllowedAccess;
        }

        public void beforeGet() {
            this.ensureTotalAccess();
        }

        public void beforeExists() {
            this.ensureTotalAccess();
        }

        private void ensureTotalAccess() {
            if (this.accessCount.incrementAndGet() > this.maxAllowedAccess) {
                int n = this.maxAllowedAccess;
                throw new RuntimeException(new StringBuilder(81).append("Cannot call firestore functions more than ").append(n).append(" during the rules evaluation").toString());
            }
        }
    }
}

