/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.auth.rules;

import com.google.cloud.datastore.core.cloudv1.converter.CloudDatastoreV1PropertyPathFromRepConverter;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.v1.ExpressionListValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import javax.annotation.Nullable;

public class PropertyMaskHelper {
    private PropertyMaskHelper() {
    }

    public static ExpressionValue convertPropertyMaskToExpressionValue(@Nullable PropertyMask propertyMask) {
        if (propertyMask == null || propertyMask.equals(PropertyMask.FULL)) {
            return ExpressionValueUtils.NULL;
        }
        ExpressionListValue.Builder listBuilder = ExpressionListValue.newBuilder();
        for (String propertyPathString : CloudDatastoreV1PropertyPathFromRepConverter.INSTANCE.convertPropertyMaskToPropertyPathStringSet(propertyMask)) {
            if (propertyPathString.endsWith(ReservedName.KEY.asString()) || propertyPathString.endsWith(ReservedName.NAME.asString())) continue;
            listBuilder.addValues(ExpressionValueUtils.createValue((Object)propertyPathString));
        }
        return ExpressionValueUtils.createValue(listBuilder.build());
    }
}

