/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.auth.rules;

import com.google.cloud.datastore.core.auth.rules.EntityToExpressionValueConverter;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.DatastoreExceptionHelper;
import com.google.cloud.datastore.core.rep.Condition;
import com.google.cloud.datastore.core.rep.ConditionVisitor;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.PropertyValueCondition;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.v1.ConstraintValue;
import com.google.firebase.rules.runtime.v1.ExpressionListValue;
import com.google.firebase.rules.runtime.v1.ExpressionMapValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.SimpleConstraint;
import com.google.firebase.rules.runtime.v1.Undefined;
import com.google.firebase.rules.v1.SourcePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class QueryToResourceConverter {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/cloud/datastore/core/auth/rules/QueryToResourceConverter");
    private final EntityToExpressionValueConverter entityToExpressionValueConverter;

    public QueryToResourceConverter(EntityToExpressionValueConverter entityToExpressionValueConverter) {
        this.entityToExpressionValueConverter = entityToExpressionValueConverter;
    }

    public Iterable<QueryConstraint> convert(Query query) throws DatastoreException {
        QueryConstraint queryConstraint = new QueryConstraint(this.entityToExpressionValueConverter);
        Condition condition = query.condition();
        boolean shortCircuited = queryConstraint.visitAllConditions(condition);
        if (shortCircuited) {
            throw DatastoreExceptionHelper.permissionDenied();
        }
        return ImmutableList.of(queryConstraint);
    }

    private static class PropertyConstraint {
        private final EntityToExpressionValueConverter entityToExpressionValueConverter;
        private final List<PropertyValueCondition> valueConditions;

        private PropertyConstraint(EntityToExpressionValueConverter entityToExpressionValueConverter) {
            this.entityToExpressionValueConverter = entityToExpressionValueConverter;
            this.valueConditions = new ArrayList<PropertyValueCondition>();
        }

        private void addCondition(PropertyValueCondition condition) {
            this.valueConditions.add(condition);
        }

        public ExpressionValue constraint() {
            Condition.Op op;
            if (!(this.valueConditions.size() != 1 || (op = this.valueConditions.get(0).op()) != Condition.Op.EQ && op != Condition.Op.REALLY_EQUALS || this.valueConditions.get(0).propertyPath().isArrayElements())) {
                return this.convertCondition(this.valueConditions.get(0));
            }
            ConstraintValue.Builder constraint = ConstraintValue.newBuilder();
            this.valueConditions.forEach(condition -> {
                try {
                    if (condition.propertyPath().isArrayElements()) {
                        constraint.addSimpleConstraints(ExpressionValueUtils.makeSimpleConstraint(PropertyConstraint.comparatorFromArrayConditionOp(condition.op()), Preconditions.checkNotNull(this.convertCondition((PropertyValueCondition)condition)), SourcePosition.getDefaultInstance()));
                    } else {
                        constraint.addSimpleConstraints(ExpressionValueUtils.makeSimpleConstraint(PropertyConstraint.comparatorFromConditionOp(condition.op()), Preconditions.checkNotNull(this.convertCondition((PropertyValueCondition)condition)), SourcePosition.getDefaultInstance()));
                    }
                }
                catch (EvaluationException e) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(e)).withInjectedLogSite("com/google/cloud/datastore/core/auth/rules/QueryToResourceConverter$PropertyConstraint", "lambda$constraint$0", 252, "QueryToResourceConverter.java")).log("Unable to convert %s to constraint.", condition);
                }
            });
            return ExpressionValue.newBuilder().setConstraintValue(constraint).build();
        }

        private ExpressionValue convertCondition(PropertyValueCondition condition) {
            return this.entityToExpressionValueConverter.convertRepValue(condition.value());
        }

        private static SimpleConstraint.Comparator comparatorFromArrayConditionOp(Condition.Op op) {
            switch (op) {
                case EQ: 
                case REALLY_EQUALS: {
                    return SimpleConstraint.Comparator.LIST_CONTAINS;
                }
            }
            String string = String.valueOf((Object)op);
            throw new IllegalArgumentException(new StringBuilder(30 + String.valueOf(string).length()).append("cannot convert ").append(string).append(" to comparator.").toString());
        }

        private static SimpleConstraint.Comparator comparatorFromConditionOp(Condition.Op op) {
            switch (op) {
                case EQ: 
                case REALLY_EQUALS: {
                    return SimpleConstraint.Comparator.EQ;
                }
                case RESERVED_NE: {
                    return SimpleConstraint.Comparator.NEQ;
                }
                case LT: {
                    return SimpleConstraint.Comparator.LT;
                }
                case LE: {
                    return SimpleConstraint.Comparator.LTE;
                }
                case GT: {
                    return SimpleConstraint.Comparator.GT;
                }
                case GE: {
                    return SimpleConstraint.Comparator.GTE;
                }
            }
            String string = String.valueOf((Object)op);
            throw new IllegalArgumentException(new StringBuilder(30 + String.valueOf(string).length()).append("cannot convert ").append(string).append(" to comparator.").toString());
        }
    }

    public static class QueryConstraint
    extends ConditionVisitor {
        private final EntityToExpressionValueConverter entityToExpressionValueConverter;
        private final Map<PropertyPath, PropertyConstraint> propertyConstraintMap = new HashMap<PropertyPath, PropertyConstraint>();

        private QueryConstraint(EntityToExpressionValueConverter entityToExpressionValueConverter) {
            this.entityToExpressionValueConverter = entityToExpressionValueConverter;
        }

        @Override
        protected boolean visit(Condition condition) {
            if (condition.op() == Condition.Op.AND) {
                return false;
            }
            if (!(condition instanceof PropertyValueCondition)) {
                return true;
            }
            if (condition.op() == Condition.Op.GEO_IN) {
                return false;
            }
            if (condition.op() == Condition.Op.RESERVED_OR || condition.op() == Condition.Op.RESERVED_NOT) {
                return true;
            }
            PropertyValueCondition propertyValueCondition = (PropertyValueCondition)condition;
            this.addPropertyCondition(propertyValueCondition);
            return false;
        }

        @Nullable
        public ExpressionValue keyConstraint() {
            PropertyConstraint condition = this.propertyConstraintMap.get(ReservedName.NAME.asPropertyPath());
            return condition == null ? null : condition.constraint();
        }

        public ExpressionValue resourceConstraint() {
            ExpressionValue.Builder resourceConstraint = ExpressionValue.newBuilder().setMapValue(ExpressionMapValue.newBuilder());
            this.propertyConstraintMap.forEach((propertyPath, propertyConstraint) -> {
                if (!propertyPath.equals(ReservedName.NAME.asPropertyPath())) {
                    QueryConstraint.resolveProperty(resourceConstraint, propertyPath, propertyConstraint);
                }
            });
            return resourceConstraint.build();
        }

        private void addPropertyCondition(PropertyValueCondition condition) {
            PropertyPath sanitizedPath = condition.propertyPath();
            if (condition.propertyPath().isArrayElements()) {
                sanitizedPath = condition.propertyPath().dropLastPathSegment();
            }
            sanitizedPath = QueryConstraint.sanitize(sanitizedPath);
            PropertyConstraint propertyConstraint = this.propertyConstraintMap.computeIfAbsent(sanitizedPath, path -> new PropertyConstraint(this.entityToExpressionValueConverter));
            propertyConstraint.addCondition(condition);
        }

        private static void resolveProperty(ExpressionValue.Builder parentValue, PropertyPath propertyPath, PropertyConstraint propertyConstraint) {
            PropertyPathSegment segment = Preconditions.checkNotNull(propertyPath).segment();
            if (segment instanceof PropertyPathSegment.Member) {
                QueryConstraint.resolveMember(parentValue, propertyPath, propertyConstraint);
            } else if (segment instanceof PropertyPathSegment.Index) {
                QueryConstraint.resolveIndex(parentValue, propertyPath, propertyConstraint);
            } else {
                String string = String.valueOf(propertyPath);
                throw new RuntimeException(new StringBuilder(27 + String.valueOf(string).length()).append("Invalid path segment type: ").append(string).toString());
            }
        }

        private static void resolveMember(ExpressionValue.Builder parentValue, PropertyPath propertyPath, PropertyConstraint propertyConstraint) {
            ExpressionValue constraint;
            PropertyPathSegment segment = propertyPath.segment();
            PropertyPath next = propertyPath.next();
            ExpressionMapValue.Builder mapValue = parentValue.getMapValueBuilder();
            String memberName = ((PropertyPathSegment.Member)segment).name().string();
            if (next != null) {
                ExpressionValue.Builder nestedValue = mapValue.containsFields(memberName) ? mapValue.getFieldsMap().get(memberName).toBuilder() : ExpressionValue.newBuilder();
                QueryConstraint.resolveProperty(nestedValue, next, propertyConstraint);
                constraint = nestedValue.build();
            } else {
                constraint = propertyConstraint.constraint();
            }
            mapValue.putFields(memberName, constraint);
        }

        private static void resolveIndex(ExpressionValue.Builder parentValue, PropertyPath propertyPath, PropertyConstraint propertyConstraint) {
            ExpressionValue constraint;
            PropertyPathSegment segment = propertyPath.segment();
            PropertyPath next = propertyPath.next();
            ExpressionListValue.Builder listValue = parentValue.getListValueBuilder();
            int index = ((PropertyPathSegment.Index)segment).index();
            if (next != null) {
                ExpressionValue.Builder nestedValue = listValue.getValuesCount() > index ? listValue.getValues(index).toBuilder() : ExpressionValue.newBuilder();
                QueryConstraint.resolveProperty(nestedValue, next, propertyConstraint);
                constraint = nestedValue.build();
            } else {
                constraint = propertyConstraint.constraint();
            }
            for (int i = 0; i <= index; ++i) {
                if (listValue.getValuesCount() > i) continue;
                listValue.addValuesBuilder().setUndefined(Undefined.getDefaultInstance());
            }
            listValue.setValues(index, constraint);
        }

        private static PropertyPath sanitize(PropertyPath propertyPath) {
            return propertyPath.isKey() ? ReservedName.NAME.asPropertyPath() : propertyPath;
        }
    }
}

