/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.auth.rules;

import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Iterator;
import javax.annotation.Nullable;

public class ResourcePathUtils {
    public static final String DEFAULT_DATABASE_NAME = "(default)";
    public static final String DATABASES = "databases";
    public static final String DOCUMENTS = "documents";
    public static final String DOCUMENTS_AT = "documents@";
    public static final String NUMERIC_ID_PREFIX = "__id";
    public static final String NUMERIC_ID_SUFFIX = "__";

    private ResourcePathUtils() {
    }

    public static String idToSegment(long id) {
        return new StringBuilder(26).append(NUMERIC_ID_PREFIX).append(id).append(NUMERIC_ID_SUFFIX).toString();
    }

    public static OnestoreEntity.Reference makeReference(Iterable<String> pathSegments) {
        Iterator<String> segmentIterator = pathSegments.iterator();
        OnestoreEntity.Reference reference = new OnestoreEntity.Reference();
        String nextPart = ResourcePathUtils.getPart(segmentIterator);
        if (!nextPart.equals(DATABASES)) {
            throw new IllegalArgumentException("Invalid document path.");
        }
        String database = ResourcePathUtils.getPart(segmentIterator);
        if (!database.equals(DEFAULT_DATABASE_NAME)) {
            reference.setDatabaseId(database);
        }
        if ((nextPart = ResourcePathUtils.getPart(segmentIterator)).startsWith(DOCUMENTS_AT)) {
            String namespace = nextPart.substring(DOCUMENTS_AT.length());
            if (Strings.isNullOrEmpty(namespace)) {
                throw new IllegalArgumentException("Namespace is not provided");
            }
            reference.setNameSpace(namespace);
        } else if (!nextPart.equals(DOCUMENTS)) {
            throw new IllegalArgumentException("Invalid document path.");
        }
        Preconditions.checkArgument(segmentIterator.hasNext(), "No document has been specified.");
        OnestoreEntity.Path path = new OnestoreEntity.Path();
        reference.setPath(path);
        while (segmentIterator.hasNext()) {
            String kind = segmentIterator.next();
            OnestoreEntity.Path.Element element = path.addElement();
            element.setType(kind);
            if (segmentIterator.hasNext()) {
                String idPart = segmentIterator.next();
                Long id = ResourcePathUtils.trySegmentToId(idPart);
                if (id != null) {
                    element.setId(id);
                    continue;
                }
                element.setName(idPart);
                continue;
            }
            throw new IllegalArgumentException("Incomplete paths are not allowed..");
        }
        return reference;
    }

    public static ImmutableList<String> referenceToPathSegments(OnestoreEntity.Reference reference) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(DATABASES);
        if (reference.hasDatabaseId()) {
            builder.add(reference.getDatabaseId());
        } else {
            builder.add(DEFAULT_DATABASE_NAME);
        }
        if (reference.hasNameSpace()) {
            String string = String.valueOf(DOCUMENTS_AT);
            String string2 = String.valueOf(reference.getNameSpace());
            builder.add(string2.length() != 0 ? string.concat(string2) : new String(string));
        } else {
            builder.add(DOCUMENTS);
        }
        for (OnestoreEntity.Path.Element element : reference.getPath().elements()) {
            builder.add(element.getType());
            if (element.hasName()) {
                builder.add(element.getName());
                continue;
            }
            if (element.hasId()) {
                builder.add(ResourcePathUtils.idToSegment(element.getId()));
                continue;
            }
            throw new IllegalArgumentException("Incomplete references are not convertible to segments.");
        }
        return builder.build();
    }

    public static ImmutableList<String> referenceValueToPathSegment(OnestoreEntity.PropertyValue.ReferenceValue referenceValue) {
        OnestoreEntity.Reference reference = new OnestoreEntity.Reference();
        reference.setApp(referenceValue.getApp());
        if (referenceValue.hasDatabaseId()) {
            reference.setDatabaseId(referenceValue.getDatabaseId());
        }
        if (referenceValue.hasNameSpace()) {
            reference.setNameSpace(referenceValue.getNameSpace());
        }
        for (OnestoreEntity.PropertyValue.ReferenceValuePathElement elementValue : referenceValue.pathElements()) {
            OnestoreEntity.Path.Element element = reference.getPath().addElement();
            element.setType(elementValue.getType());
            if (elementValue.hasName()) {
                element.setName(elementValue.getName());
                continue;
            }
            if (!elementValue.hasId()) continue;
            element.setId(elementValue.getId());
        }
        return ResourcePathUtils.referenceToPathSegments(reference);
    }

    public static ImmutableList<String> databaseRefToPathSegment(DatabaseRef databaseRef) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(DATABASES);
        String databaseId = databaseRef.databaseId();
        builder.add(databaseId.isEmpty() ? DEFAULT_DATABASE_NAME : databaseId);
        return builder.build();
    }

    public static ImmutableList<String> partitionRefToPathSegment(PartitionRef partitionRef) {
        String string;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(ResourcePathUtils.databaseRefToPathSegment(partitionRef.databaseRef()));
        String namespaceId = partitionRef.namespace();
        if (namespaceId.isEmpty()) {
            string = DOCUMENTS;
        } else {
            String string2 = String.valueOf(DOCUMENTS_AT);
            String string3 = String.valueOf(namespaceId);
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        builder.add(string);
        return builder.build();
    }

    public static ImmutableList<String> entityRefToPathSegment(EntityRef entityRef) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(ResourcePathUtils.partitionRefToPathSegment(entityRef.partitionRef()));
        for (EntityRef.PathElement element : entityRef.pathElements()) {
            builder.add(element.collectionId());
            if (element.resourceId() == null) {
                throw new IllegalArgumentException("Incomplete references are not convertible to segments.");
            }
            if (element.resourceId().isLong()) {
                builder.add(ResourcePathUtils.idToSegment(element.resourceId().asLong()));
                continue;
            }
            if (!element.resourceId().isString()) continue;
            builder.add(element.resourceId().asString());
        }
        return builder.build();
    }

    @Nullable
    private static Long trySegmentToId(String segment) {
        if (segment.startsWith(NUMERIC_ID_PREFIX) && segment.endsWith(NUMERIC_ID_SUFFIX)) {
            Long id = Longs.tryParse(segment.substring(NUMERIC_ID_PREFIX.length(), segment.length() - NUMERIC_ID_SUFFIX.length()));
            if (id == null) {
                throw new IllegalArgumentException("Invalid numerical id.");
            }
            return id;
        }
        return null;
    }

    private static String getPart(Iterator<String> parts) {
        Preconditions.checkArgument(parts.hasNext(), "Cannot parse the provided path.");
        return parts.next();
    }
}

