/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.auth.rules;

import com.google.cloud.datastore.core.auth.rules.Constants;
import com.google.cloud.datastore.core.auth.rules.DatastoreRuleContextBuilder;
import com.google.cloud.datastore.core.auth.rules.EntityToExpressionValueConverter;
import com.google.cloud.datastore.core.auth.rules.FirebaseRulesAuthorizerOptions;
import com.google.cloud.datastore.core.auth.rules.LazyCollectingSupplier;
import com.google.cloud.datastore.core.auth.rules.LookupManager;
import com.google.cloud.datastore.core.auth.rules.PropertyMaskHelper;
import com.google.cloud.datastore.core.auth.rules.PropertyPathToExpressionValue;
import com.google.cloud.datastore.core.auth.rules.QueryToResourceConverter;
import com.google.cloud.datastore.core.auth.rules.RulesAuthorizer;
import com.google.cloud.datastore.core.auth.rules.RulesExecutionTracker;
import com.google.cloud.datastore.core.auth.rules.RulesRequestContext;
import com.google.cloud.datastore.core.auth.rules.RulesStats;
import com.google.cloud.datastore.core.auth.rules.Trackable;
import com.google.cloud.datastore.core.auth.rules.Trackables;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.exception.DatastoreExceptionHelper;
import com.google.cloud.datastore.core.names.Names;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.Lookup;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.cloud.datastore.core.rep.Write;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.context.NonThrowingAutoCloseable;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.firebase.rules.runtime.evaluators.AuthRuleEvaluator;
import com.google.firebase.rules.runtime.evaluators.RuleClient;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.PathUtils;
import com.google.firebase.rules.runtime.v1.ExpressionListValue;
import com.google.firebase.rules.runtime.v1.ExpressionMapValue;
import com.google.firebase.rules.runtime.v1.ExpressionPathValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.runtime.v1.Undefined;
import com.google.net.rpc3.RpcException;
import com.google.net.util.error.Codes;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class RulesAuthorizerImpl
implements RulesAuthorizer {
    static final ExpressionValue EXPECTED_UNDEFINED = ExpressionValue.newBuilder().setUndefined(Undefined.getDefaultInstance()).build();
    static final String USER_DEFINED_DATA_FIELD = "data";
    static final String RESOURCE_ID_FIELD = "id";
    private final FirebaseRulesAuthorizerOptions firebaseRulesAuthorizerOptions;
    private final RuleClient ruleClient;
    private final Ticker ticker;
    private final EntityToExpressionValueConverter entityToExpressionValueConverter;
    private final QueryToResourceConverter queryToResourceConverter;
    private final String defaultReleaseName;

    public RulesAuthorizerImpl(FirebaseRulesAuthorizerOptions firebaseRulesAuthorizerOptions, RuleClient ruleClient, Ticker ticker, EntityToExpressionValueConverter entityToExpressionValueConverter, String defaultReleaseName) {
        this.firebaseRulesAuthorizerOptions = firebaseRulesAuthorizerOptions;
        this.ruleClient = ruleClient;
        this.ticker = ticker;
        this.entityToExpressionValueConverter = entityToExpressionValueConverter;
        this.defaultReleaseName = defaultReleaseName;
        this.queryToResourceConverter = new QueryToResourceConverter(entityToExpressionValueConverter);
    }

    @Override
    @Nullable
    public RulesAuthorizer.PerEntityReadAuthorizer checkAccess(RulesRequestContext requestContext, Lookup lookup) throws DatastoreException {
        AuthRuleEvaluator evaluator = this.getEvaluator(requestContext);
        try (NonThrowingAutoCloseable tracker = requestContext.phaseExecutionTimer().enter(RulesExecutionTracker.RulesPhase.EVALUATION);){
            RulesAuthorizer.PerEntityReadAuthorizer perEntityReadAuthorizer;
            ImmutableMap.Builder<OnestoreEntity.Reference, RequestAuthorizationResponse> authorizationResults = ImmutableMap.builder();
            for (OnestoreEntity.Reference reference : lookup.distinctKeys()) {
                DatastoreRuleContextBuilder rulesContextBuilder = this.makeGetRuleContext(requestContext, lookup, reference);
                Trackable dataAccessTracker = Trackables.of(rulesContextBuilder.trackDynamicCalls(), rulesContextBuilder.trackResourceAccess());
                RequestAuthorizationResponse response = RulesAuthorizerImpl.evaluateRequest(evaluator, rulesContextBuilder.build(Constants.ActionIds.GET));
                RulesAuthorizerImpl.checkFirstPhaseMaybeAuthorized(requestContext, response, dataAccessTracker);
                authorizationResults.put(reference, response);
            }
            ImmutableMap<OnestoreEntity.Reference, RequestAuthorizationResponse> authorizationStates = authorizationResults.build();
            if (authorizationStates.containsValue((Object)RequestAuthorizationResponse.AUTHORIZATION_UNKNOWN)) {
                perEntityReadAuthorizer = new GetAuthorizer(requestContext, lookup, evaluator, authorizationStates);
                return perEntityReadAuthorizer;
            }
            requestContext.stats().setLabel(RulesStats.RulesCategory.RULE_EVALUATION_OUTCOME, RulesStats.RuleEvaluationOutcome.RULES_FIRST_PHASE_ALLOWED);
            perEntityReadAuthorizer = PREAUTHORIZED;
            return perEntityReadAuthorizer;
        }
    }

    @Override
    public void checkAccess(RulesRequestContext requestContext, Query internalQuery, RulesAuthorizer.LookupHandler lookupHandler) throws DatastoreException {
        AuthRuleEvaluator evaluator = this.getEvaluator(requestContext);
        try (NonThrowingAutoCloseable tracker = requestContext.phaseExecutionTimer().enter(RulesExecutionTracker.RulesPhase.EVALUATION);){
            if (internalQuery.kind() != null && Names.isNameReserved(internalQuery.kind())) {
                throw DatastoreExceptionHelper.permissionDenied();
            }
            ImmutableList.Builder contextAndResources = ImmutableList.builder();
            Iterable<QueryToResourceConverter.QueryConstraint> constraints = this.queryToResourceConverter.convert(internalQuery);
            for (QueryToResourceConverter.QueryConstraint queryConstraint : constraints) {
                contextAndResources.add(this.toContextAndResource(requestContext, internalQuery, queryConstraint, evaluator.getRulesetAst().getVersion()));
            }
            this.evaluateQueryInTwoPhase(evaluator, (ImmutableList<RuleContextBuilderAndResource>)contextAndResources.build(), lookupHandler, requestContext, Constants.ActionIds.LIST);
        }
    }

    private RuleContextBuilderAndResource toContextAndResource(RulesRequestContext requestContext, Query internalQuery, QueryToResourceConverter.QueryConstraint queryConstraint, RulesetAst.Version rulesVersion) throws DatastoreException {
        DatastoreRuleContextBuilder requestBuilder = this.makeRulesContext(requestContext).supplyTransaction(requestContext.transactionHandle());
        ExpressionValue fields = internalQuery.propertyMask().equals(PropertyMask.FULL) ? this.propertyPathListToExpressionValue(internalQuery.projection()) : PropertyMaskHelper.convertPropertyMaskToExpressionValue(internalQuery.propertyMask());
        requestBuilder.supplyRequestField(Constants.RequestFields.IN_TRANSACTION, ExpressionValueUtils.createValue(requestContext.transactionHandle() != null)).supplyRequestField(Constants.RequestFields.FIELDS, fields);
        requestBuilder.supplyRequestField(Constants.RequestFields.QUERY, this.queryToExpression(internalQuery));
        ExpressionValue keyConstraint = queryConstraint.keyConstraint();
        if (keyConstraint != null && ExpressionValueUtils.isPath(keyConstraint)) {
            requestBuilder.path(keyConstraint.getPathValue());
            return RuleContextBuilderAndResource.lazy(requestBuilder, keyConstraint.getPathValue());
        }
        requestBuilder.path(RulesAuthorizerImpl.buildMatchPath(requestContext, internalQuery, rulesVersion));
        requestBuilder.trackFieldAccesses();
        HashMap<String, ExpressionValue> fieldsMap = new HashMap<String, ExpressionValue>();
        if (keyConstraint != null) {
            fieldsMap.put(ReservedName.NAME.asString(), keyConstraint);
        }
        fieldsMap.put(USER_DEFINED_DATA_FIELD, queryConstraint.resourceConstraint());
        ExpressionValue resource = ExpressionValueUtils.createValue(fieldsMap);
        return RuleContextBuilderAndResource.eager(requestBuilder, resource);
    }

    private static ExpressionPathValue buildMatchPath(RulesRequestContext requestContext, Query internalQuery, RulesetAst.Version rulesVersion) throws DatastoreException {
        EntityRef ancestorRef = internalQuery.ancestor() != null ? internalQuery.ancestor() : EntityRef.create(PartitionRef.createFromDatabaseRefAndNamespace(requestContext.databaseRef(), internalQuery.scope().namespace()), new EntityRef.PathElement[0]);
        PathUtils.Builder pathBuilder = DatastoreRuleContextBuilder.makeReferencePath(ancestorRef);
        if (!internalQuery.isShallow()) {
            if (internalQuery.semantics().equals((Object)Query.Semantics.FIRESTORE) && rulesVersion.equals(RulesetAst.Version.VERSION_2)) {
                pathBuilder.appendGlob();
            } else {
                if (internalQuery.semantics().equals((Object)Query.Semantics.FIRESTORE)) {
                    return pathBuilder.appendGlob().build();
                }
                throw DatastoreExceptionHelper.permissionDenied();
            }
        }
        if (!Strings.isNullOrEmpty(internalQuery.kind())) {
            pathBuilder.appendSegment(internalQuery.kind()).appendCapture();
        } else {
            pathBuilder.appendCapture().appendCapture();
        }
        return pathBuilder.build();
    }

    @Override
    public void checkWrite(RulesRequestContext requestContext, Write write) throws DatastoreException {
        NonThrowingAutoCloseable tracker = requestContext.phaseExecutionTimer().enter(RulesExecutionTracker.RulesPhase.EVALUATION);
        Throwable throwable = null;
        try {
            try {
                throw RulesAuthorizerImpl.firstPhaseDenied(requestContext);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (tracker != null) {
                RulesAuthorizerImpl.$closeResource(throwable, tracker);
            }
            throw throwable3;
        }
    }

    @Override
    public RulesAuthorizer.PerEntityWriteAuthorizer checkCommit(RulesRequestContext requestContext, Write write) throws DatastoreException {
        AuthRuleEvaluator evaluator = this.getEvaluator(requestContext);
        try (NonThrowingAutoCloseable tracker = requestContext.phaseExecutionTimer().enter(RulesExecutionTracker.RulesPhase.EVALUATION);){
            Object object;
            IdentityHashMap<OnestoreEntity.Reference, CommitAuthorizationInfo> authorizationStates = new IdentityHashMap<OnestoreEntity.Reference, CommitAuthorizationInfo>();
            if (requestContext.transactionHandle() == null) {
                throw DatastoreExceptionHelper.permissionDenied(null);
            }
            for (Mutation mutation : write.mutations()) {
                RequestAuthorizationResponse response;
                switch (mutation.op()) {
                    case DELETE: 
                    case DELETE_MUST_NOT_EXIST: 
                    case DELETE_MUST_EXIST: {
                        response = this.evaluateDeleteMutation(requestContext, evaluator, mutation);
                        break;
                    }
                    case INSERT: {
                        if (mutation.allocateKey()) {
                            Preconditions.checkState(V3Paths.hasIncompleteLastElement(mutation.key()), "For auto ids the authorization should happen before id assignment. This is likely because the retry logic do not set proper retry point to skip the authorization in the case of rpc failure.");
                        }
                        response = this.evaluateInsertMutation(requestContext, evaluator, mutation);
                        break;
                    }
                    case UPDATE: {
                        response = this.evaluateUpdateMutation(requestContext, evaluator, mutation);
                        break;
                    }
                    case UPSERT: {
                        RequestAuthorizationResponse responseFromInsert = this.evaluateInsertMutation(requestContext, evaluator, mutation);
                        RequestAuthorizationResponse responseFromUpdate = this.evaluateUpdateMutation(requestContext, evaluator, mutation);
                        if (responseFromInsert == RequestAuthorizationResponse.AUTHORIZED && responseFromUpdate == RequestAuthorizationResponse.AUTHORIZED) {
                            response = RequestAuthorizationResponse.AUTHORIZED;
                            break;
                        }
                        if (responseFromInsert == RequestAuthorizationResponse.UNAUTHORIZED && responseFromUpdate == RequestAuthorizationResponse.UNAUTHORIZED) {
                            throw RulesAuthorizerImpl.firstPhaseDenied(requestContext);
                        }
                        response = RequestAuthorizationResponse.AUTHORIZATION_UNKNOWN;
                        break;
                    }
                    default: {
                        String string = String.valueOf((Object)mutation.op());
                        throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("Cannot find operation: ").append(string).toString());
                    }
                }
                authorizationStates.put(mutation.key(), new CommitAuthorizationInfo(mutation.allocateKey() ? (OnestoreEntity.Reference)mutation.key().clone() : mutation.key(), response, mutation));
            }
            if (authorizationStates.values().stream().anyMatch(rec$ -> ((CommitAuthorizationInfo)rec$).authorizationIsUnknown())) {
                object = new CommitAuthorizerImpl(requestContext, evaluator, authorizationStates);
                return object;
            }
            requestContext.stats().setLabel(RulesStats.RulesCategory.RULE_EVALUATION_OUTCOME, RulesStats.RuleEvaluationOutcome.RULES_FIRST_PHASE_ALLOWED);
            object = PREAUTHORIZED;
            return object;
        }
    }

    private RequestAuthorizationResponse evaluateUpdateMutation(RulesRequestContext requestContext, AuthRuleEvaluator evaluator, Mutation mutation) throws DatastoreException {
        Preconditions.checkArgument(mutation.op() == Mutation.Op.UPDATE || mutation.op() == Mutation.Op.UPSERT);
        ImmutableList.Builder<Trackable> trackables = ImmutableList.builder();
        DatastoreRuleContextBuilder contextBuilder = this.makeWriteContext(requestContext, mutation.key(), mutation);
        ((ImmutableList.Builder)trackables.add((Object)contextBuilder.trackDynamicCalls())).add(contextBuilder.trackResourceAccess());
        RulesAuthorizerImpl.addRequestResourceForWrite(mutation, trackables, contextBuilder);
        Trackable trackable = Trackables.of((ImmutableList<Trackable>)trackables.build());
        RequestAuthorizationResponse response = RulesAuthorizerImpl.evaluateRequest(evaluator, contextBuilder.build(Constants.ActionIds.UPDATE));
        if (mutation.op() != Mutation.Op.UPSERT) {
            RulesAuthorizerImpl.checkFirstPhaseMaybeAuthorized(requestContext, response, trackable);
        }
        return response;
    }

    private RequestAuthorizationResponse evaluateInsertMutation(RulesRequestContext requestContext, AuthRuleEvaluator evaluator, Mutation mutation) throws DatastoreException {
        Preconditions.checkArgument(mutation.op() == Mutation.Op.INSERT || mutation.op() == Mutation.Op.UPSERT);
        ImmutableList.Builder<Trackable> trackables = ImmutableList.builder();
        DatastoreRuleContextBuilder contextBuilder = this.makeWriteContext(requestContext, mutation.key(), mutation);
        if (mutation.op() == Mutation.Op.INSERT) {
            contextBuilder.supplyRequestField(Constants.RequestFields.AUTO_ID, ExpressionValueUtils.createValue(mutation.allocateKey()));
        }
        RulesAuthorizerImpl.addRequestResourceForWrite(mutation, trackables, contextBuilder);
        ((ImmutableList.Builder)trackables.add((Object)contextBuilder.trackDynamicCalls())).add(contextBuilder.trackResourceAccess());
        Trackable trackable = Trackables.of((ImmutableList<Trackable>)trackables.build());
        RequestAuthorizationResponse response = RulesAuthorizerImpl.evaluateRequest(evaluator, contextBuilder.build(Constants.ActionIds.CREATE));
        if (mutation.op() != Mutation.Op.UPSERT) {
            RulesAuthorizerImpl.checkFirstPhaseMaybeAuthorized(requestContext, response, trackable);
        }
        return response;
    }

    private static void addRequestResourceForWrite(Mutation mutation, ImmutableList.Builder<Trackable> trackables, DatastoreRuleContextBuilder contextBuilder) {
        if (mutation.ignoresExistingEntityData()) {
            contextBuilder.supplyRequestResource(mutation.entity());
        } else {
            contextBuilder.supplyRequestField(Constants.RequestFields.RESOURCE, EXPECTED_UNDEFINED);
            trackables.add((Object)contextBuilder.trackRequestVariableAccess());
        }
    }

    private RequestAuthorizationResponse evaluateDeleteMutation(RulesRequestContext requestContext, AuthRuleEvaluator evaluator, Mutation mutation) throws DatastoreException {
        Preconditions.checkArgument(mutation.op().isDelete());
        ImmutableList.Builder<Trackable> trackables = ImmutableList.builder();
        DatastoreRuleContextBuilder contextBuilder = this.makeWriteContext(requestContext, mutation.key(), mutation);
        ((ImmutableList.Builder)trackables.add((Object)contextBuilder.trackDynamicCalls())).add(contextBuilder.trackResourceAccess());
        RulesAuthorizerImpl.addRequestResourceForWrite(mutation, trackables, contextBuilder);
        Trackable trackable = Trackables.of((ImmutableList<Trackable>)trackables.build());
        RequestAuthorizationResponse response = RulesAuthorizerImpl.evaluateRequest(evaluator, contextBuilder.build(Constants.ActionIds.DELETE));
        RulesAuthorizerImpl.checkFirstPhaseMaybeAuthorized(requestContext, response, trackable);
        return response;
    }

    private void evaluateQueryInTwoPhase(AuthRuleEvaluator evaluator, ImmutableList<RuleContextBuilderAndResource> ruleContextBuilderAndResources, RulesAuthorizer.LookupHandler lookupHandler, RulesRequestContext requestContext, Constants.ActionIds actionId) throws DatastoreException {
        ArrayList<RuleContextBuilderAndResource> needSecondPhase = new ArrayList<RuleContextBuilderAndResource>();
        for (RuleContextBuilderAndResource contextBuilder : ruleContextBuilderAndResources) {
            RequestAuthorizationResponse authorizationResponse = contextBuilder.runFirstPhase(requestContext, evaluator, actionId);
            if (authorizationResponse != RequestAuthorizationResponse.AUTHORIZATION_UNKNOWN) continue;
            needSecondPhase.add(contextBuilder);
        }
        if (!needSecondPhase.isEmpty()) {
            LookupManager lookupManager = this.makeLookupManager(requestContext);
            for (RuleContextBuilderAndResource contextBuilder : needSecondPhase) {
                contextBuilder.runSecondPhase(requestContext, evaluator, actionId, lookupManager, lookupHandler);
            }
        } else {
            requestContext.stats().setLabel(RulesStats.RulesCategory.RULE_EVALUATION_OUTCOME, RulesStats.RuleEvaluationOutcome.RULES_FIRST_PHASE_ALLOWED);
        }
    }

    private ExpressionValue propertyPathListToExpressionValue(ImmutableList<PropertyPath> propertyPaths) {
        if (propertyPaths.isEmpty()) {
            return ExpressionValueUtils.NULL;
        }
        ExpressionListValue.Builder listBuilder = ExpressionListValue.newBuilder();
        for (PropertyPath propertyPath : propertyPaths) {
            listBuilder.addValues(PropertyPathToExpressionValue.INSTANCE.apply(propertyPath));
        }
        return ExpressionValueUtils.createValue(listBuilder.build());
    }

    private ExpressionValue queryToExpression(Query query) {
        String ancestorPropertyName = query.isShallow() ? "parent" : "ancestor";
        return ExpressionValueUtils.createValue(ExpressionMapValue.newBuilder().putFields("distinct", ExpressionValueUtils.createValue(query.allowDuplicateResults())).putFields("selectOnlyKeys", ExpressionValueUtils.createValue(query.selectOnlyKeys())).putFields("groupBy", ExpressionValueUtils.createValue(query.groupBy().stream().collect(Collectors.toMap(PropertyPathToExpressionValue.INSTANCE::asString, path -> ExpressionValueUtils.createValue(true))))).putFields("kind", ExpressionValueUtils.createValue((Object)query.kind())).putFields(ancestorPropertyName, query.ancestor() != null ? ExpressionValueUtils.createValue(DatastoreRuleContextBuilder.makeReferencePath(query.ancestor()).build()) : ExpressionValueUtils.NULL).putFields("orderBy", ExpressionValueUtils.createValue(query.orderBy().stream().collect(Collectors.toMap(pathAndDirection -> PropertyPathToExpressionValue.INSTANCE.asString(pathAndDirection.propertyPath()), pathAndDirection -> pathAndDirection.direction() == Direction.ASCENDING ? "ASC" : "DESC", (direction1, direction2) -> direction1)))).putFields("limit", ExpressionValueUtils.createValue(query.limit())).putFields("offset", ExpressionValueUtils.createValue(query.offset())).putFields("allDescendants", ExpressionValueUtils.createValue(!query.isShallow() && query.semantics().equals((Object)Query.Semantics.FIRESTORE))).build());
    }

    private DatastoreRuleContextBuilder makeGetRuleContext(RulesRequestContext requestContext, Lookup lookup, OnestoreEntity.Reference reference) throws DatastoreException {
        return this.makeRulesContext(requestContext).path(reference).supplyTransaction(requestContext.transactionHandle()).supplyRequestField(Constants.RequestFields.FIELDS, PropertyMaskHelper.convertPropertyMaskToExpressionValue(lookup.propertyMask()));
    }

    private DatastoreRuleContextBuilder makeWriteContext(RulesRequestContext requestContext, OnestoreEntity.Reference key, Mutation mutation) throws DatastoreException {
        DatastoreRuleContextBuilder contextBuilder = this.makeRulesContext(requestContext).path(key);
        ExpressionValue modifiedFieldsList = ExpressionValueUtils.NULL;
        if (mutation.transformation() != null) {
            modifiedFieldsList = ExpressionValueUtils.transformList(mutation.transformation().propertyTransformations(), propertyTransformation -> PropertyPathToExpressionValue.INSTANCE.apply(propertyTransformation.propertyPath()));
        }
        contextBuilder.supplyRequestField(Constants.RequestFields.TRANSFORMS, modifiedFieldsList);
        ExpressionValue maskPropertiesList = PropertyMaskHelper.convertPropertyMaskToExpressionValue(mutation.writePropertyMask());
        if (maskPropertiesList.hasListValue() && modifiedFieldsList.hasListValue()) {
            modifiedFieldsList = ExpressionValue.newBuilder().setListValue(ExpressionListValue.newBuilder(modifiedFieldsList.getListValue()).addAllValues(maskPropertiesList.getListValue().getValuesList())).build();
        } else if (maskPropertiesList.hasListValue()) {
            modifiedFieldsList = maskPropertiesList;
        }
        contextBuilder.supplyRequestField(Constants.RequestFields.WRITE_FIELDS, modifiedFieldsList);
        contextBuilder.supplyRequestField(Constants.RequestFields.READ_FIELDS, PropertyMaskHelper.convertPropertyMaskToExpressionValue(mutation.readPropertyMask()));
        return contextBuilder;
    }

    private static RequestAuthorizationResponse evaluateRequest(AuthRuleEvaluator evaluator, AuthRuleEvaluator.RuleContext ruleContext) {
        try {
            AuthRuleEvaluator.RuleResult result = (AuthRuleEvaluator.RuleResult)evaluator.evaluate(ruleContext).get();
            if (result.permit()) {
                return RequestAuthorizationResponse.AUTHORIZED;
            }
            return RequestAuthorizationResponse.UNAUTHORIZED;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            return RequestAuthorizationResponse.AUTHORIZATION_UNKNOWN;
        }
    }

    private static void checkFirstPhaseMaybeAuthorized(RulesRequestContext requestContext, RequestAuthorizationResponse response, Trackable trackable) throws DatastoreException {
        switch (response) {
            case AUTHORIZED: {
                break;
            }
            case UNAUTHORIZED: {
                throw RulesAuthorizerImpl.firstPhaseDenied(requestContext);
            }
            case AUTHORIZATION_UNKNOWN: {
                if (trackable.isCalled()) break;
                requestContext.stats().setLabel(RulesStats.RulesCategory.RULE_EVALUATION_OUTCOME, RulesStats.RuleEvaluationOutcome.RULES_FIRST_PHASE_ERROR);
                throw DatastoreExceptionHelper.permissionDenied();
            }
        }
    }

    @CheckReturnValue
    private static DatastoreException firstPhaseDenied(RulesRequestContext requestContext) {
        requestContext.stats().setLabel(RulesStats.RulesCategory.RULE_EVALUATION_OUTCOME, RulesStats.RuleEvaluationOutcome.RULES_FIRST_PHASE_DENIED);
        return DatastoreExceptionHelper.permissionDenied();
    }

    private static void evaluate(RulesRequestContext requestContext, AuthRuleEvaluator evaluator, AuthRuleEvaluator.RuleContext ruleContext) throws DatastoreException {
        try {
            AuthRuleEvaluator.RuleResult result = (AuthRuleEvaluator.RuleResult)evaluator.evaluate(ruleContext).get();
            if (!result.permit()) {
                requestContext.stats().setLabel(RulesStats.RulesCategory.RULE_EVALUATION_OUTCOME, RulesStats.RuleEvaluationOutcome.RULES_SECOND_PHASE_DENIED);
                throw DatastoreExceptionHelper.permissionDenied();
            }
            requestContext.stats().setLabel(RulesStats.RulesCategory.RULE_EVALUATION_OUTCOME, RulesStats.RuleEvaluationOutcome.RULES_SECOND_PHASE_ALLOWED);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            requestContext.stats().setLabel(RulesStats.RulesCategory.RULE_EVALUATION_OUTCOME, RulesStats.RuleEvaluationOutcome.RULES_SECOND_PHASE_ERROR);
            throw DatastoreExceptionHelper.permissionDenied(e.getCause());
        }
    }

    private AuthRuleEvaluator getEvaluator(RulesRequestContext requestContext) throws DatastoreException {
        AuthRuleEvaluator.AuthRuleEvaluatorRequest evaluatorRequest = AuthRuleEvaluator.AuthRuleEvaluatorRequest.release(requestContext.databaseRef().projectId(), this.defaultReleaseName);
        try {
            AuthRuleEvaluator evaluator = this.ruleClient.getEvaluator(evaluatorRequest);
            if (evaluator == null) {
                throw DatastoreExceptionHelper.permissionDenied();
            }
            requestContext.stats().setRulesetId(RulesAuthorizerImpl.rulesetNameToId(evaluator.getRulesetName()));
            requestContext.rulesAccessCollector().setReleaseName(evaluatorRequest.releaseName()).setRulesetName(evaluator.getRulesetName());
            return evaluator;
        }
        catch (RpcException e) {
            if (e.getStatus().getCanonicalCode() == Codes.Code.NOT_FOUND) {
                throw DatastoreExceptionHelper.permissionDenied(e);
            }
            throw DatastoreExceptionHelper.internalError(e);
        }
    }

    private static String rulesetNameToId(String rulesetName) {
        int lastIndex = rulesetName.lastIndexOf(47);
        Preconditions.checkArgument(lastIndex > 0 && lastIndex < rulesetName.length() - 1);
        return rulesetName.substring(lastIndex + 1);
    }

    private DatastoreRuleContextBuilder makeRulesContext(RulesRequestContext requestContext) throws DatastoreException {
        return DatastoreRuleContextBuilder.builder(requestContext, this.entityToExpressionValueConverter);
    }

    private LookupManager makeLookupManager(RulesRequestContext requestContext) {
        return new LookupManager(requestContext, this.entityToExpressionValueConverter, this.firebaseRulesAuthorizerOptions, this.ticker);
    }

    private static class RuleContextBuilderAndResource {
        private final DatastoreRuleContextBuilder datastoreRuleContextBuilder;
        @Nullable
        private final ExpressionValue resource;
        @Nullable
        private final ExpressionPathValue resourcePath;

        private RuleContextBuilderAndResource(DatastoreRuleContextBuilder datastoreRuleContextBuilder, @Nullable ExpressionValue resource, @Nullable ExpressionPathValue resourcePath) {
            this.datastoreRuleContextBuilder = Preconditions.checkNotNull(datastoreRuleContextBuilder);
            Preconditions.checkArgument(resource == null || resourcePath == null);
            this.resource = resource;
            this.resourcePath = resourcePath;
        }

        RequestAuthorizationResponse runFirstPhase(RulesRequestContext requestContext, AuthRuleEvaluator evaluator, Constants.ActionIds actionId) throws DatastoreException {
            Trackable tracker = this.datastoreRuleContextBuilder.trackDynamicCalls();
            if (this.resourcePath != null) {
                tracker = Trackables.of(this.datastoreRuleContextBuilder.trackResourceAccess(), tracker);
            } else if (this.resource != null) {
                this.datastoreRuleContextBuilder.supplyResource(this.resource);
            }
            RequestAuthorizationResponse response = RulesAuthorizerImpl.evaluateRequest(evaluator, this.datastoreRuleContextBuilder.build(actionId));
            RulesAuthorizerImpl.checkFirstPhaseMaybeAuthorized(requestContext, response, tracker);
            return response;
        }

        void runSecondPhase(RulesRequestContext requestContext, AuthRuleEvaluator evaluator, Constants.ActionIds actionId, LookupManager lookupManager, RulesAuthorizer.LookupHandler lookupHandler) throws DatastoreException {
            if (this.resourcePath == null) {
                lookupManager.addDynamicLookupFunctionsAndVariables(lookupHandler, this.datastoreRuleContextBuilder);
            } else {
                lookupManager.addDynamicLookupFunctionsAndVariables(lookupHandler, this.datastoreRuleContextBuilder, this.resourcePath);
            }
            AuthRuleEvaluator.RuleContext context = this.datastoreRuleContextBuilder.build(actionId);
            RulesAuthorizerImpl.evaluate(requestContext, evaluator, context);
        }

        static RuleContextBuilderAndResource none(DatastoreRuleContextBuilder datastoreRuleContextBuilder) {
            return new RuleContextBuilderAndResource(datastoreRuleContextBuilder, null, null);
        }

        static RuleContextBuilderAndResource eager(DatastoreRuleContextBuilder datastoreRuleContextBuilder, ExpressionValue resource) {
            return new RuleContextBuilderAndResource(datastoreRuleContextBuilder, resource, null);
        }

        static RuleContextBuilderAndResource lazy(DatastoreRuleContextBuilder datastoreRuleContextBuilder, ExpressionPathValue resourcePath) {
            return new RuleContextBuilderAndResource(datastoreRuleContextBuilder, null, resourcePath);
        }
    }

    private class CommitAuthorizerImpl
    implements RulesAuthorizer.PerEntityWriteAuthorizer {
        private final RulesRequestContext requestContext;
        private final AuthRuleEvaluator evaluator;
        private final Supplier<ImmutableMap<OnestoreEntity.Reference, CommitAuthorizationInfo>> authorizationStatesSupplier;
        private final LookupManager lookupManager;

        CommitAuthorizerImpl(RulesRequestContext requestContext, AuthRuleEvaluator evaluator, IdentityHashMap<OnestoreEntity.Reference, CommitAuthorizationInfo> authorizationStates) {
            this.requestContext = requestContext;
            this.evaluator = evaluator;
            this.lookupManager = RulesAuthorizerImpl.this.makeLookupManager(requestContext);
            this.authorizationStatesSupplier = Suppliers.memoize(() -> ImmutableMap.copyOf(authorizationStates));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void checkAccess(RulesAuthorizer.LookupHandler lookupHandler, ReadResult oldEntity, OnestoreEntity.EntityProto newEntity, Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> writeBatch) throws DatastoreException {
            try (NonThrowingAutoCloseable tracker = this.requestContext.phaseExecutionTimer().enter(RulesExecutionTracker.RulesPhase.EVALUATION);){
                OnestoreEntity.Reference key = oldEntity.reference();
                ImmutableMap<OnestoreEntity.Reference, CommitAuthorizationInfo> authorizationStates = this.authorizationStatesSupplier.get();
                CommitAuthorizationInfo authorizationInfo = Preconditions.checkNotNull(authorizationStates.get(key), "%s was not part of the original request", (Object)key);
                if (authorizationInfo.requestAuthorizationResponse == RequestAuthorizationResponse.AUTHORIZED) {
                    return;
                }
                Mutation mutation = authorizationInfo.mutation;
                DatastoreRuleContextBuilder ruleContextBuilder = RulesAuthorizerImpl.this.makeWriteContext(this.requestContext, authorizationInfo.referenceBeforeAssignId, mutation);
                Mutation.Op op = mutation.op();
                if (op == Mutation.Op.UPSERT) {
                    op = !oldEntity.exists() ? Mutation.Op.INSERT : Mutation.Op.UPDATE;
                }
                switch (op) {
                    case DELETE: 
                    case DELETE_MUST_NOT_EXIST: 
                    case DELETE_MUST_EXIST: {
                        LazyCollectingSupplier resourceVariable = new LazyCollectingSupplier(RulesAuthorizerImpl.this.entityToExpressionValueConverter, this.requestContext, oldEntity);
                        this.lookupManager.addDynamicLookupFunctionsAndVariables(lookupHandler, ruleContextBuilder, resourceVariable, writeBatch);
                        ruleContextBuilder.supplyRequestResource(newEntity);
                        RulesAuthorizerImpl.evaluate(this.requestContext, this.evaluator, ruleContextBuilder.build(Constants.ActionIds.DELETE));
                        return;
                    }
                    case INSERT: {
                        if (mutation.op() == Mutation.Op.INSERT) {
                            ruleContextBuilder.supplyRequestField(Constants.RequestFields.AUTO_ID, ExpressionValueUtils.createValue(mutation.allocateKey()));
                        }
                        LazyCollectingSupplier resourceVariable = new LazyCollectingSupplier(RulesAuthorizerImpl.this.entityToExpressionValueConverter, this.requestContext, oldEntity);
                        this.lookupManager.addDynamicLookupFunctionsAndVariables(lookupHandler, ruleContextBuilder, resourceVariable, writeBatch);
                        ruleContextBuilder.supplyRequestResource(newEntity);
                        RulesAuthorizerImpl.evaluate(this.requestContext, this.evaluator, ruleContextBuilder.build(Constants.ActionIds.CREATE));
                        return;
                    }
                    case UPDATE: {
                        LazyCollectingSupplier resourceVariable = new LazyCollectingSupplier(RulesAuthorizerImpl.this.entityToExpressionValueConverter, this.requestContext, oldEntity);
                        this.lookupManager.addDynamicLookupFunctionsAndVariables(lookupHandler, ruleContextBuilder, resourceVariable, writeBatch);
                        ruleContextBuilder.supplyRequestResource(newEntity);
                        RulesAuthorizerImpl.evaluate(this.requestContext, this.evaluator, ruleContextBuilder.build(Constants.ActionIds.UPDATE));
                        return;
                    }
                    default: {
                        String string = String.valueOf((Object)mutation.op());
                        throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("Cannot find operation: ").append(string).toString());
                    }
                }
            }
        }
    }

    private static class CommitAuthorizationInfo {
        private final OnestoreEntity.Reference referenceBeforeAssignId;
        private final RequestAuthorizationResponse requestAuthorizationResponse;
        private final Mutation mutation;

        CommitAuthorizationInfo(OnestoreEntity.Reference referenceBeforeAssignId, RequestAuthorizationResponse requestAuthorizationResponse, Mutation mutation) {
            this.referenceBeforeAssignId = referenceBeforeAssignId;
            this.requestAuthorizationResponse = requestAuthorizationResponse;
            this.mutation = mutation;
        }

        private boolean authorizationIsUnknown() {
            return RequestAuthorizationResponse.AUTHORIZATION_UNKNOWN.equals((Object)this.requestAuthorizationResponse);
        }
    }

    private class GetAuthorizer
    implements RulesAuthorizer.PerEntityReadAuthorizer {
        private final RulesRequestContext requestContext;
        private final Lookup lookup;
        private final AuthRuleEvaluator evaluator;
        private final ImmutableMap<OnestoreEntity.Reference, RequestAuthorizationResponse> authorizationStates;
        private final LookupManager lookupManager;

        GetAuthorizer(RulesRequestContext requestContext, Lookup lookup, AuthRuleEvaluator evaluator, ImmutableMap<OnestoreEntity.Reference, RequestAuthorizationResponse> authorizationStates) {
            this.requestContext = requestContext;
            this.lookup = lookup;
            this.evaluator = evaluator;
            this.authorizationStates = authorizationStates;
            this.lookupManager = RulesAuthorizerImpl.this.makeLookupManager(requestContext);
        }

        @Override
        public boolean isPreAuthorized() {
            return false;
        }

        @Override
        public void checkAccess(RulesAuthorizer.LookupHandler lookupHandler, ReadResult entityUnderAuthorization) throws DatastoreException {
            try (NonThrowingAutoCloseable tracker = this.requestContext.phaseExecutionTimer().enter(RulesExecutionTracker.RulesPhase.EVALUATION);){
                OnestoreEntity.Reference key = entityUnderAuthorization.reference();
                RequestAuthorizationResponse authorizationState = Preconditions.checkNotNull(this.authorizationStates.get(key), "%s was not part of the original request", (Object)key);
                if (authorizationState == RequestAuthorizationResponse.AUTHORIZED) {
                    return;
                }
                DatastoreRuleContextBuilder ruleContextBuilder = RulesAuthorizerImpl.this.makeGetRuleContext(this.requestContext, this.lookup, key);
                LazyCollectingSupplier resourceVariable = new LazyCollectingSupplier(RulesAuthorizerImpl.this.entityToExpressionValueConverter, this.requestContext, entityUnderAuthorization);
                ruleContextBuilder.supplyResource(resourceVariable);
                this.lookupManager.addDynamicLookupFunctionsAndVariables(lookupHandler, ruleContextBuilder, resourceVariable);
                RulesAuthorizerImpl.evaluate(this.requestContext, this.evaluator, ruleContextBuilder.build(Constants.ActionIds.GET));
            }
        }
    }

    static enum RequestAuthorizationResponse {
        AUTHORIZED,
        UNAUTHORIZED,
        AUTHORIZATION_UNKNOWN;

    }
}

