/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.auth.rules;

import com.google.cloud.datastore.core.auth.rules.RulesAuthorizerImpl;
import com.google.cloud.datastore.core.auth.rules.Trackable;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.v1.ExpressionMapValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;

class TrackingVariableSupplier
implements Supplier<ListenableFuture<ExpressionValue>>,
Trackable {
    private boolean called;
    private final Supplier<ListenableFuture<ExpressionValue>> supplier;

    private TrackingVariableSupplier(Supplier<ListenableFuture<ExpressionValue>> supplier) {
        this.supplier = supplier;
    }

    @Override
    public ListenableFuture<ExpressionValue> get() {
        this.called = true;
        return this.supplier.get();
    }

    @Override
    public boolean isCalled() {
        return this.called;
    }

    static TrackingVariableSupplier lazyMap(ExpressionMapValue.Builder mapBuilder) {
        return new TrackingVariableSupplier(() -> Futures.immediateFuture(ExpressionValueUtils.createValue(mapBuilder.build())));
    }

    static TrackingVariableSupplier undefined() {
        return new TrackingVariableSupplier(Suppliers.ofInstance(Futures.immediateFuture(RulesAuthorizerImpl.EXPECTED_UNDEFINED)));
    }
}

