/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.cloudv1.converter;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.appengv3.converter.CompiledCursorUtil;
import com.google.cloud.datastore.core.cloudv1.converter.EntityV3V1Converter;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.names.ProjectIdAppIdResolver;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.common.base.Preconditions;
import com.google.datastore.v1.CompositeFilter;
import com.google.datastore.v1.EntityResult;
import com.google.datastore.v1.GeoRegion;
import com.google.datastore.v1.Projection;
import com.google.datastore.v1.PropertyFilter;
import com.google.datastore.v1.PropertyOrder;
import com.google.datastore.v1.Query;
import com.google.datastore.v1.QueryResultBatch;
import com.google.datastore.v1.StContainsFilter;
import com.google.datastore.v1.Value;
import com.google.protobuf.ByteString;
import com.google.protobuf.NullValue;
import com.google.type.LatLng;

public class AppEngV3ToCloudDatastoreV1Converter {
    private final Config.DatastoreConfig datastoreConfig;

    public AppEngV3ToCloudDatastoreV1Converter(Config.DatastoreConfig datastoreConfig) {
        this.datastoreConfig = Preconditions.checkNotNull(datastoreConfig);
    }

    public ByteString toV1QueryCursor(DatastoreV3Pb.CompiledCursor compiledCursor) {
        return this.toV1CursorBytes(compiledCursor.toByteString());
    }

    public Query.Builder toV1Query(ProjectIdAppIdResolver resolver, DatastoreV3Pb.Query query) throws InvalidConversionException {
        Query.Builder builder = Query.newBuilder();
        if (query.hasLimit()) {
            builder.getLimitBuilder().setValue(query.getLimit());
        }
        if (query.getOffset() != 0) {
            builder.setOffset(query.getOffset());
        }
        if (query.hasCompiledCursor()) {
            builder.setStartCursor(this.toV1QueryCursor(query.getCompiledCursor()));
        }
        if (query.hasEndCompiledCursor()) {
            builder.setEndCursor(this.toV1QueryCursor(query.getEndCompiledCursor()));
        }
        if (query.hasKind()) {
            builder.addKindBuilder().setName(query.getKind());
        }
        InvalidConversionException.checkConversion(query.propertyNameSize() <= 0 || !query.isKeysOnly(), "projection and keys_only cannot both be set", new Object[0]);
        for (String name : query.propertyNames()) {
            Projection.Builder projBuilder = builder.addProjectionBuilder();
            projBuilder.getPropertyBuilder().setName(name);
        }
        if (query.isKeysOnly()) {
            Projection.Builder projBuilder = builder.addProjectionBuilder();
            projBuilder.getPropertyBuilder().setName(PropertyPath.KEY.asStringLossy());
        }
        for (String name : query.groupByPropertyNames()) {
            builder.addDistinctOnBuilder().setName(name);
        }
        CompositeFilter.Builder filter = CompositeFilter.newBuilder();
        filter.setOp(CompositeFilter.Operator.AND);
        if (query.hasAncestor() || query.isShallow()) {
            PropertyFilter.Builder propFilter = filter.addFiltersBuilder().getPropertyFilterBuilder();
            propFilter.setOp(query.isShallow() ? PropertyFilter.Operator.HAS_PARENT : PropertyFilter.Operator.HAS_ANCESTOR);
            propFilter.getPropertyBuilder().setName(PropertyPath.KEY.asStringLossy());
            if (query.hasAncestor()) {
                propFilter.setValue(Value.newBuilder().setKeyValue(EntityV3V1Converter.INSTANCE.toV1Key(resolver, query.getAncestor())));
            } else {
                propFilter.setValue(Value.newBuilder().setNullValue(NullValue.NULL_VALUE));
            }
        }
        for (DatastoreV3Pb.Query.Filter filterV3 : query.filters()) {
            InvalidConversionException.checkConversion(filterV3.propertySize() == 1, "invalid filter", new Object[0]);
            DatastoreV3Pb.Query.Filter.Operator operatorV3 = filterV3.getOpEnum();
            String propertyName = filterV3.getProperty(0).getName();
            if (operatorV3 == DatastoreV3Pb.Query.Filter.Operator.CONTAINED_IN_REGION) {
                StContainsFilter.Builder stContainsFilter = filter.addFiltersBuilder().getStContainsFilterBuilder();
                stContainsFilter.getPropertyBuilder().setName(propertyName);
                stContainsFilter.setContainedIn(this.toV1GeoRegion(filterV3.getGeoRegion()));
                continue;
            }
            PropertyFilter.Builder propFilter = filter.addFiltersBuilder().getPropertyFilterBuilder();
            propFilter.setOp(this.toV1PropertyFilterOperator(operatorV3));
            propFilter.getPropertyBuilder().setName(propertyName);
            propFilter.setValue(EntityV3V1Converter.INSTANCE.toV1Value(resolver, filterV3.getProperty(0), true));
        }
        if (filter.getFiltersCount() == 1) {
            builder.setFilter(filter.getFiltersBuilder(0));
        } else if (filter.getFiltersCount() > 1) {
            builder.getFilterBuilder().setCompositeFilter(filter);
        }
        for (DatastoreV3Pb.Query.Order order : query.orders()) {
            PropertyOrder.Builder orderV1 = builder.addOrderBuilder();
            orderV1.getPropertyBuilder().setName(order.getProperty());
            if (!order.hasDirection()) continue;
            switch (order.getDirectionEnum()) {
                case ASCENDING: {
                    orderV1.setDirection(PropertyOrder.Direction.ASCENDING);
                    break;
                }
                case DESCENDING: {
                    orderV1.setDirection(PropertyOrder.Direction.DESCENDING);
                }
            }
        }
        return builder;
    }

    private PropertyFilter.Operator toV1PropertyFilterOperator(DatastoreV3Pb.Query.Filter.Operator operatorV3) throws InvalidConversionException {
        switch (operatorV3) {
            case LESS_THAN: {
                return PropertyFilter.Operator.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return PropertyFilter.Operator.LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return PropertyFilter.Operator.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return PropertyFilter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case EQUAL: 
            case IN: {
                return PropertyFilter.Operator.EQUAL;
            }
            case EXISTS: {
                String string = String.valueOf(operatorV3);
                throw new InvalidConversionException(new StringBuilder(20 + String.valueOf(string).length()).append("unsupported filter: ").append(string).toString());
            }
        }
        throw InvalidConversionException.unrecognizedEnumValue("property_filter.op", operatorV3);
    }

    private GeoRegion toV1GeoRegion(DatastoreV3Pb.GeoRegion regionV3) throws InvalidConversionException {
        GeoRegion.Builder region = GeoRegion.newBuilder();
        if (regionV3.hasCircle()) {
            DatastoreV3Pb.CircleRegion circleV3 = regionV3.getCircle();
            region.getCircleBuilder().setCenter(this.toV1LatLng(circleV3.getCenter())).setRadiusMeters(circleV3.getRadiusMeters());
        } else if (regionV3.hasRectangle()) {
            DatastoreV3Pb.RectangleRegion rectangleV3 = regionV3.getRectangle();
            region.getRectangleBuilder().setSouthwest(this.toV1LatLng(rectangleV3.getSouthwest())).setNortheast(this.toV1LatLng(rectangleV3.getNortheast()));
        } else {
            String string = String.valueOf(regionV3);
            throw new InvalidConversionException(new StringBuilder(24 + String.valueOf(string).length()).append("unsupported geo region: ").append(string).toString());
        }
        return region.build();
    }

    private LatLng toV1LatLng(DatastoreV3Pb.RegionPoint pointV3) {
        return LatLng.newBuilder().setLatitude(pointV3.getLatitude()).setLongitude(pointV3.getLongitude()).build();
    }

    public QueryResultBatch.Builder toV1QueryResultBatch(ProjectIdAppIdResolver resolver, DatastoreV3Pb.QueryResult result) throws InvalidConversionException {
        QueryResultBatch.Builder batchV1 = this.toV1QueryResultBatchMetadata(result);
        this.addResultsToV1QueryResultBatch(resolver, batchV1, result);
        return batchV1;
    }

    public QueryResultBatch.Builder toV1QueryResultBatchMetadata(DatastoreV3Pb.QueryResult result) throws InvalidConversionException {
        QueryResultBatch.Builder builder = QueryResultBatch.newBuilder();
        builder.setMoreResults(result.isMoreResults() ? QueryResultBatch.MoreResultsType.NOT_FINISHED : QueryResultBatch.MoreResultsType.MORE_RESULTS_AFTER_LIMIT);
        if (result.hasCompiledCursor()) {
            builder.setEndCursor(this.toV1QueryCursor(result.getCompiledCursor()));
        }
        if (result.hasSkippedResultsCompiledCursor()) {
            builder.setSkippedCursor(this.toV1QueryCursor(result.getSkippedResultsCompiledCursor()));
        }
        builder.setEntityResultType(result.isKeysOnly() ? EntityResult.ResultType.KEY_ONLY : (result.isIndexOnly() ? EntityResult.ResultType.PROJECTION : EntityResult.ResultType.FULL));
        if (result.hasSkippedResults()) {
            builder.setSkippedResults(result.getSkippedResults());
        }
        int numOfResults = result.resultSize();
        int numOfCursors = result.resultCompiledCursorSize();
        InvalidConversionException.checkConversion(numOfCursors == 0 || numOfCursors == numOfResults, "query results contains inconsistent number of cursors", new Object[0]);
        return builder;
    }

    private void addResultsToV1QueryResultBatch(ProjectIdAppIdResolver resolver, QueryResultBatch.Builder batchV1, DatastoreV3Pb.QueryResult resultV3) throws InvalidConversionException {
        for (int i = 0; i < resultV3.resultSize(); ++i) {
            EntityResult.Builder entity = batchV1.addEntityResultsBuilder();
            entity.setEntity(EntityV3V1Converter.INSTANCE.toV1Entity(resolver, resultV3.getResult(i)));
            if (this.datastoreConfig.getAllowMutationBaseVersion() && resultV3.versionSize() > 0) {
                entity.setVersion(resultV3.getVersion(i));
            }
            if (resultV3.resultCompiledCursorSize() != resultV3.resultSize()) continue;
            entity.setCursor(this.toV1QueryCursor(resultV3.getResultCompiledCursor(i)));
        }
    }

    public EntityResult.Builder toV1EntityResult(ProjectIdAppIdResolver resolver, DatastoreV3Pb.GetResponse.Entity entityV3) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!entityV3.hasEntity() || !entityV3.hasKey(), "Get Response cannot have both an entity and key", new Object[0]);
        EntityResult.Builder builder = EntityResult.newBuilder();
        if (entityV3.hasEntity()) {
            builder.setEntity(EntityV3V1Converter.INSTANCE.toV1Entity(resolver, entityV3.getEntity()));
        } else if (entityV3.hasKey()) {
            builder.getEntityBuilder().setKey(EntityV3V1Converter.INSTANCE.toV1Key(resolver, entityV3.getKey()));
        }
        if (this.datastoreConfig.getAllowMutationBaseVersion() && entityV3.hasVersion()) {
            builder.setVersion(entityV3.getVersion());
        }
        return builder;
    }

    private ByteString toV1CursorBytes(ByteString cursorBytesV3) {
        if (cursorBytesV3.isEmpty()) {
            return CompiledCursorUtil.V1_EMPTY_CURSOR;
        }
        return cursorBytesV3;
    }
}

