/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.cloudv1.converter;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.SpecialPropertyDescriptor;
import com.google.cloud.datastore.core.rep.converter.PropertyPathToMaskConverter;
import com.google.cloud.datastore.core.rep.validator.ValidationConstraint;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CloudDatastoreV1PropertyPathToRepConverter {
    private final PropertyPathToMaskConverter propertyPathToMaskConverter;

    public CloudDatastoreV1PropertyPathToRepConverter(PropertyPathToMaskConverter propertyPathToMaskConverter) {
        this.propertyPathToMaskConverter = Preconditions.checkNotNull(propertyPathToMaskConverter);
    }

    public PropertyMask convertPropertyMask(com.google.datastore.v1.PropertyMask apiPropertyMask, ValidationConstraint constraint) throws InvalidConversionException {
        ArrayList<PropertyPath> propertyPaths = new ArrayList<PropertyPath>();
        for (ByteString apiPropertyPathByteString : apiPropertyMask.getPathsList().asByteStringList()) {
            propertyPaths.add(this.convertPropertyPath(apiPropertyPathByteString));
        }
        propertyPaths.add(PropertyPath.KEY);
        return this.propertyPathToMaskConverter.validateAndConvertPathsToMask(propertyPaths, constraint);
    }

    public PropertyPath convertPropertyPath(ByteString apiPathByteString) throws InvalidConversionException {
        PropertyPath propertyPath = PropertyPath.createFromSegments(this.convertPropertyPathToPropertyPathSegments(apiPathByteString));
        return propertyPath;
    }

    private List<PropertyPathSegment> convertPropertyPathToPropertyPathSegments(ByteString apiPathByteString) throws InvalidConversionException {
        int numBytes = apiPathByteString.size();
        InvalidConversionException.checkConversion(numBytes != 0, "a property path must not be empty.", new Object[0]);
        byte[] byteArray = new byte[numBytes];
        ArrayList<PropertyPathSegment> segments = new ArrayList<PropertyPathSegment>();
        int nameIndex = 0;
        for (int pathIndex = 0; pathIndex < numBytes; ++pathIndex) {
            byte b = apiPathByteString.byteAt(pathIndex);
            if (b == 46) {
                this.addPropertyName(segments, byteArray, nameIndex);
                nameIndex = 0;
                continue;
            }
            if (b == 92) {
                InvalidConversionException.checkConversion(++pathIndex < numBytes, "property path ends in %c", (byte)92);
                b = apiPathByteString.byteAt(pathIndex);
                InvalidConversionException.checkConversion(b == 46 || b == 92, "unnown escaped character %c in property path", b);
            }
            byteArray[nameIndex] = b;
            ++nameIndex;
        }
        this.addPropertyName(segments, byteArray, nameIndex);
        return segments;
    }

    private void addPropertyName(List<PropertyPathSegment> segments, byte[] byteArray, int numBytes) throws InvalidConversionException {
        InvalidConversionException.checkConversion(numBytes > 0, "property path contains empty name", new Object[0]);
        byte[] propertyNameByteArray = Arrays.copyOf(byteArray, numBytes);
        PropertyName propertyName = PropertyName.from(propertyNameByteArray);
        SpecialPropertyDescriptor special = propertyName.special();
        InvalidConversionException.checkConversion(special != SpecialPropertyDescriptor.KIND && special != SpecialPropertyDescriptor.SCATTER && special != SpecialPropertyDescriptor.SPLITS && special != SpecialPropertyDescriptor.UNAPPLIED_LOG_TIMESTAMP_US, "property path contains reserved name", new Object[0]);
        segments.add(PropertyPathSegment.Member.create(propertyName));
    }
}

