/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.cloudv1.converter;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.cloud.datastore.core.appengv3.converter.CompiledCursorUtil;
import com.google.cloud.datastore.core.cloudv1.converter.EntityV3V1Converter;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.names.ProjectIdAppIdResolver;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.common.base.Preconditions;
import com.google.datastore.v1.CompositeFilter;
import com.google.datastore.v1.EntityResult;
import com.google.datastore.v1.Filter;
import com.google.datastore.v1.FilterOrBuilder;
import com.google.datastore.v1.GeoRegion;
import com.google.datastore.v1.GeoRegionOrBuilder;
import com.google.datastore.v1.PartitionIdOrBuilder;
import com.google.datastore.v1.Projection;
import com.google.datastore.v1.PropertyFilter;
import com.google.datastore.v1.PropertyFilterOrBuilder;
import com.google.datastore.v1.PropertyOrder;
import com.google.datastore.v1.PropertyReference;
import com.google.datastore.v1.QueryOrBuilder;
import com.google.datastore.v1.QueryResultBatch;
import com.google.datastore.v1.QueryResultBatchOrBuilder;
import com.google.datastore.v1.StContainsFilter;
import com.google.datastore.v1.Value;
import com.google.datastore.v1.ValueOrBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.storage.onestore.v3.OnestoreEntity;
import com.google.type.LatLngOrBuilder;
import java.util.Arrays;

public class CloudDatastoreV1ToAppEngV3Converter {
    private static final byte[] KEY_PROPERTY_NAME_BYTE_ARRAY = ByteString.copyFromUtf8(ReservedName.KEY.asString()).toByteArray();

    public static ByteString toV3CursorBytes(ByteString cursorBytesV1) {
        Preconditions.checkArgument(!cursorBytesV1.isEmpty(), "cannot convert empty v1 cursor bytes");
        if (cursorBytesV1.equals(CompiledCursorUtil.V1_EMPTY_CURSOR)) {
            return ByteString.EMPTY;
        }
        return cursorBytesV1;
    }

    public DatastoreV3Pb.CompiledCursor toV3CompiledCursor(ByteString cursorBytesV1) throws InvalidConversionException {
        try {
            return DatastoreV3Pb.CompiledCursor.parser().parseFrom(CloudDatastoreV1ToAppEngV3Converter.toV3CursorBytes(cursorBytesV1));
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidConversionException(e);
        }
    }

    public DatastoreV3Pb.Query toV3Query(ProjectIdAppIdResolver resolver, PartitionIdOrBuilder partitionId, QueryOrBuilder query) throws InvalidConversionException {
        DatastoreV3Pb.Query result = new DatastoreV3Pb.Query();
        result.setApp(resolver.toAppId(partitionId.getProjectId()));
        if (!partitionId.getDatabaseId().isEmpty()) {
            result.setDatabaseId(partitionId.getDatabaseId());
        }
        if (!partitionId.getNamespaceId().isEmpty()) {
            result.setNameSpace(partitionId.getNamespaceId());
        }
        result.setPersistOffset(true);
        result.setRequirePerfectPlan(true);
        result.setCompile(true);
        if (query.hasLimit()) {
            result.setLimit(query.getLimit().getValue());
        }
        if (query.getOffset() != 0) {
            result.setOffset(query.getOffset());
        }
        if (!query.getStartCursor().isEmpty()) {
            result.setCompiledCursor(this.toV3CompiledCursor(query.getStartCursor()));
        }
        if (!query.getEndCursor().isEmpty()) {
            result.setEndCompiledCursor(this.toV3CompiledCursor(query.getEndCursor()));
        }
        if (query.getKindCount() > 0) {
            InvalidConversionException.checkConversion(query.getKindCount() == 1, "multiple kinds not supported", new Object[0]);
            result.setKind(query.getKind(0).getName());
        }
        boolean hasKeyProjection = false;
        for (Projection projection : query.getProjectionList()) {
            String propName = projection.getProperty().getName();
            if (propName.equals(ReservedName.KEY.asString())) {
                hasKeyProjection = true;
                continue;
            }
            result.addPropertyName(propName);
        }
        if (hasKeyProjection && result.propertyNameSize() == 0) {
            result.setKeysOnly(true);
        }
        for (PropertyReference propertyReference : query.getDistinctOnList()) {
            result.addGroupByPropertyName(propertyReference.getName());
        }
        if (query.hasFilter()) {
            this.populateV3Filters(resolver, query.getFilter(), result);
        }
        for (PropertyOrder propertyOrder : query.getOrderList()) {
            DatastoreV3Pb.Query.Order orderV3 = result.addOrder();
            orderV3.setProperty(propertyOrder.getProperty().getName());
            switch (propertyOrder.getDirection()) {
                case DIRECTION_UNSPECIFIED: {
                    break;
                }
                case ASCENDING: {
                    orderV3.setDirection(DatastoreV3Pb.Query.Order.Direction.ASCENDING);
                    break;
                }
                case DESCENDING: {
                    orderV3.setDirection(DatastoreV3Pb.Query.Order.Direction.DESCENDING);
                    break;
                }
                case UNRECOGNIZED: {
                    throw InvalidConversionException.unrecognizedEnumValue("direction", propertyOrder.getDirection());
                }
            }
        }
        return result;
    }

    private void populateV3Filters(ProjectIdAppIdResolver resolver, FilterOrBuilder filter, DatastoreV3Pb.Query query) throws InvalidConversionException {
        switch (filter.getFilterTypeCase()) {
            case PROPERTY_FILTER: {
                PropertyFilterOrBuilder propertyFilter = filter.getPropertyFilterOrBuilder();
                PropertyReference propertyReference = propertyFilter.getProperty();
                byte[] propertyNameAsByteArray = propertyReference.getNameBytes().toByteArray();
                PropertyFilter.Operator op = propertyFilter.getOp();
                ValueOrBuilder value = propertyFilter.getValueOrBuilder();
                if (op == PropertyFilter.Operator.HAS_ANCESTOR || op == PropertyFilter.Operator.HAS_PARENT) {
                    if (op == PropertyFilter.Operator.HAS_PARENT) {
                        InvalidConversionException.checkConversion(value.getValueTypeCase() == Value.ValueTypeCase.KEY_VALUE || value.getValueTypeCase() == Value.ValueTypeCase.NULL_VALUE, "HAS_PARENT requires a key value or null", new Object[0]);
                    } else {
                        InvalidConversionException.checkConversion(value.getValueTypeCase() == Value.ValueTypeCase.KEY_VALUE, "HAS_ANCESTOR requires a key value", new Object[0]);
                    }
                    InvalidConversionException.checkConversion(Arrays.equals(propertyNameAsByteArray, KEY_PROPERTY_NAME_BYTE_ARRAY), "property must be %s", ReservedName.KEY.asString());
                    InvalidConversionException.checkConversion(!query.isShallow() && !query.hasAncestor(), "duplicate ancestor or parent constraint", new Object[0]);
                    query.setShallow(op == PropertyFilter.Operator.HAS_PARENT);
                    if (value.getValueTypeCase() != Value.ValueTypeCase.KEY_VALUE) break;
                    query.setAncestor(EntityV3V1Converter.INSTANCE.toV3Reference(resolver, value.getKeyValueOrBuilder()));
                    break;
                }
                DatastoreV3Pb.Query.Filter result = query.addFilter();
                result.setOp(op.getNumber());
                InvalidConversionException.checkConversion(value.getArrayValue().getValuesCount() == 0, "unsupported value type, list_value, in property filter on '%s'", propertyReference.getName());
                result.addProperty().setMultiple(false).setNameAsBytes(propertyNameAsByteArray).setValue(EntityV3V1Converter.INSTANCE.toV3PropertyValue(resolver, propertyFilter.getValue()));
                break;
            }
            case COMPOSITE_FILTER: {
                InvalidConversionException.checkConversion(filter.getCompositeFilter().getOp() == CompositeFilter.Operator.AND, "unsupported composite property operator", new Object[0]);
                for (Filter subFilter : filter.getCompositeFilterOrBuilder().getFiltersList()) {
                    this.populateV3Filters(resolver, subFilter, query);
                }
                break;
            }
            case ST_CONTAINS_FILTER: {
                StContainsFilter stContainsFilter = filter.getStContainsFilter();
                DatastoreV3Pb.Query.Filter result = query.addFilter();
                result.addProperty().setMultiple(false).setName(stContainsFilter.getProperty().getName()).setValue(new OnestoreEntity.PropertyValue());
                result.setOp(DatastoreV3Pb.Query.Filter.Operator.CONTAINED_IN_REGION);
                result.setGeoRegion(this.toV3GeoRegion(stContainsFilter.getContainedIn()));
                break;
            }
            case FILTERTYPE_NOT_SET: {
                query.addFilter();
            }
        }
    }

    public DatastoreV3Pb.GeoRegion toV3GeoRegion(GeoRegionOrBuilder region) throws InvalidConversionException {
        DatastoreV3Pb.GeoRegion result = new DatastoreV3Pb.GeoRegion();
        switch (region.getShapeCase()) {
            case CIRCLE: {
                GeoRegion.Circle circle = region.getCircle();
                result.getMutableCircle().setRadiusMeters(circle.getRadiusMeters()).setCenter(this.toV3RegionPoint(circle.getCenter()));
                break;
            }
            case RECTANGLE: {
                GeoRegion.Rectangle rectangle = region.getRectangle();
                result.getMutableRectangle().setSouthwest(this.toV3RegionPoint(rectangle.getSouthwest())).setNortheast(this.toV3RegionPoint(rectangle.getNortheast()));
                break;
            }
            default: {
                throw InvalidConversionException.unrecognizedEnumValue("shape", region.getShapeCase());
            }
        }
        return result;
    }

    public DatastoreV3Pb.RegionPoint toV3RegionPoint(LatLngOrBuilder latLng) {
        DatastoreV3Pb.RegionPoint result = new DatastoreV3Pb.RegionPoint();
        result.setLatitude(latLng.getLatitude());
        result.setLongitude(latLng.getLongitude());
        return result;
    }

    public DatastoreV3Pb.QueryResult toV3QueryResult(ProjectIdAppIdResolver resolver, QueryResultBatchOrBuilder batch) throws InvalidConversionException {
        DatastoreV3Pb.QueryResult result = new DatastoreV3Pb.QueryResult();
        result.setMoreResults(batch.getMoreResults() == QueryResultBatch.MoreResultsType.NOT_FINISHED);
        if (!batch.getSkippedCursor().isEmpty()) {
            result.setSkippedResultsCompiledCursor(this.toV3CompiledCursor(batch.getSkippedCursor()));
        }
        if (!batch.getEndCursor().isEmpty()) {
            result.setCompiledCursor(this.toV3CompiledCursor(batch.getEndCursor()));
        }
        if (batch.getEntityResultType() == EntityResult.ResultType.PROJECTION) {
            result.setIndexOnly(true);
        } else if (batch.getEntityResultType() == EntityResult.ResultType.KEY_ONLY) {
            result.setKeysOnly(true);
        }
        if (batch.getSkippedResults() != 0) {
            result.setSkippedResults(batch.getSkippedResults());
        }
        for (EntityResult entityResult : batch.getEntityResultsList()) {
            OnestoreEntity.EntityProto entity = EntityV3V1Converter.INSTANCE.toV3Entity(resolver, entityResult.getEntity());
            if (batch.getEntityResultType() != EntityResult.ResultType.FULL) {
                entity.setEntityGroup(OnestoreEntity.Path.IMMUTABLE_DEFAULT_INSTANCE);
            }
            result.addResult(entity);
            if (entityResult.getCursor().isEmpty()) continue;
            result.addResultCompiledCursor(this.toV3CompiledCursor(entityResult.getCursor()));
        }
        return result;
    }
}

