/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.cloudv1.converter;

import com.google.cloud.datastore.core.cloudv1.converter.CloudDatastoreV1PropertyPathToRepConverter;
import com.google.cloud.datastore.core.cloudv1.converter.EntityV3V1Converter;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.names.ProjectIdAppIdResolver;
import com.google.cloud.datastore.core.rep.Lookup;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.validator.ValidationConstraint;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.LookupRequestOrBuilder;
import com.google.datastore.v1.Mutation;
import com.google.datastore.v1.ReadOptions;
import com.google.protobuf.ByteString;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import javax.annotation.Nullable;

public class CloudDatastoreV1ToRepConverter {
    protected final CloudDatastoreV1PropertyPathToRepConverter propertyPathToRepConverter;

    public CloudDatastoreV1ToRepConverter(CloudDatastoreV1PropertyPathToRepConverter propertyPathToRepConverter) {
        this.propertyPathToRepConverter = propertyPathToRepConverter;
    }

    public Lookup toLookup(ProjectIdAppIdResolver resolver, LookupRequestOrBuilder req, @Nullable ByteString newTxnBytes) throws InvalidConversionException {
        ReadOptions.ConsistencyTypeCase consistencyType = req.getReadOptions().getConsistencyTypeCase();
        Preconditions.checkArgument(newTxnBytes != null == (consistencyType == ReadOptions.ConsistencyTypeCase.NEW_TRANSACTION));
        Lookup.Builder builder = Lookup.builder().allowDefer(true);
        block0 : switch (consistencyType) {
            case CONSISTENCYTYPE_NOT_SET: {
                break;
            }
            case NEW_TRANSACTION: 
            case TRANSACTION: {
                break;
            }
            case READ_CONSISTENCY: {
                ReadOptions.ReadConsistency readConsistency = req.getReadOptionsOrBuilder().getReadConsistency();
                switch (readConsistency) {
                    case READ_CONSISTENCY_UNSPECIFIED: 
                    case STRONG: {
                        break block0;
                    }
                    case EVENTUAL: {
                        builder.isStrong(false);
                        builder.allowFailover(true);
                        break block0;
                    }
                    case UNRECOGNIZED: {
                        throw new IllegalArgumentException(String.format("Unhandled read consistency: %s", readConsistency.name()));
                    }
                }
            }
        }
        ImmutableList.Builder v3Keys = ImmutableList.builder();
        for (Key key : req.getKeysList()) {
            v3Keys.add(EntityV3V1Converter.INSTANCE.toV3Reference(resolver, key));
        }
        builder.keys(v3Keys.build());
        if (req.hasPropertyMask()) {
            builder.propertyMask(this.toPropertyMask(req.getPropertyMask(), ValidationConstraint.LOOKUP));
        }
        return builder.build();
    }

    public PropertyMask toPropertyMask(com.google.datastore.v1.PropertyMask propertyMask, ValidationConstraint constraint) throws InvalidConversionException {
        return this.propertyPathToRepConverter.convertPropertyMask(propertyMask, constraint);
    }

    public ImmutableList<com.google.cloud.datastore.core.rep.Mutation> toMutationList(ProjectIdAppIdResolver resolver, List<Mutation> requestMutations) throws InvalidConversionException {
        ImmutableList.Builder internalMutations = ImmutableList.builder();
        block16: for (Mutation mutation : requestMutations) {
            Long baseVersion = null;
            switch (mutation.getConflictDetectionStrategyCase()) {
                case CONFLICTDETECTIONSTRATEGY_NOT_SET: {
                    InvalidConversionException.checkConversion(mutation.getConflictResolutionStrategy() == Mutation.ConflictResolutionStrategy.STRATEGY_UNSPECIFIED, "cannot set a conflict resolution strategy if no detection strategy was set", new Object[0]);
                    break;
                }
                case BASE_VERSION: {
                    baseVersion = mutation.getBaseVersion();
                    InvalidConversionException.checkConversion(baseVersion >= 0L, "Invalid base_version: %d, it should be >= 0", baseVersion);
                }
            }
            Mutation.ConflictResolutionStrategy resolutionStrategy = null;
            if (baseVersion != null) {
                switch (mutation.getConflictResolutionStrategy()) {
                    case STRATEGY_UNSPECIFIED: 
                    case SERVER_VALUE: {
                        resolutionStrategy = Mutation.ConflictResolutionStrategy.SERVER_VALUE;
                        break;
                    }
                    case CLIENT_VALUE: {
                        resolutionStrategy = Mutation.ConflictResolutionStrategy.CLIENT_VALUE;
                        break;
                    }
                    case FAIL: {
                        resolutionStrategy = Mutation.ConflictResolutionStrategy.FAIL;
                        break;
                    }
                    case UNRECOGNIZED: {
                        throw new InvalidConversionException("Unknown conflict resolution strategy.");
                    }
                }
            }
            PropertyMask mask = mutation.hasPropertyMask() ? this.toPropertyMask(mutation.getPropertyMask(), this.getValidationConstraint(mutation)) : PropertyMask.FULL;
            switch (mutation.getOperationCase()) {
                case INSERT: {
                    OnestoreEntity.EntityProto insertEntity = EntityV3V1Converter.INSTANCE.toV3Entity(resolver, mutation.getInsert());
                    internalMutations.add(com.google.cloud.datastore.core.rep.Mutation.insert(insertEntity).writePropertyMask(mask).baseVersion(baseVersion).conflictResolutionStrategy(resolutionStrategy).build());
                    continue block16;
                }
                case UPDATE: {
                    OnestoreEntity.EntityProto updateEntity = EntityV3V1Converter.INSTANCE.toV3Entity(resolver, mutation.getUpdate());
                    internalMutations.add(com.google.cloud.datastore.core.rep.Mutation.update(updateEntity).writePropertyMask(mask).baseVersion(baseVersion).conflictResolutionStrategy(resolutionStrategy).build());
                    continue block16;
                }
                case UPSERT: {
                    OnestoreEntity.EntityProto upsertEntity = EntityV3V1Converter.INSTANCE.toV3Entity(resolver, mutation.getUpsert());
                    internalMutations.add(com.google.cloud.datastore.core.rep.Mutation.upsert(upsertEntity).writePropertyMask(mask).baseVersion(baseVersion).conflictResolutionStrategy(resolutionStrategy).build());
                    continue block16;
                }
                case DELETE: {
                    internalMutations.add(com.google.cloud.datastore.core.rep.Mutation.delete(EntityV3V1Converter.INSTANCE.toV3Reference(resolver, mutation.getDelete())).baseVersion(baseVersion).conflictResolutionStrategy(resolutionStrategy).build());
                    continue block16;
                }
            }
            throw new InvalidConversionException("Mutation is missing operation.");
        }
        return internalMutations.build();
    }

    private ValidationConstraint getValidationConstraint(Mutation mutation) throws InvalidConversionException {
        switch (mutation.getOperationCase()) {
            case INSERT: {
                return ValidationConstraint.INSERT;
            }
            case UPDATE: {
                return ValidationConstraint.UPDATE;
            }
            case UPSERT: {
                return ValidationConstraint.UPSERT;
            }
            case DELETE: {
                return ValidationConstraint.DELETE;
            }
        }
        throw new IllegalArgumentException("invalid mutation case");
    }
}

