/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.cloudv1.converter;

import com.google.cloud.datastore.core.cloudv1.converter.Token;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    @Override
    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        StringBuffer expected = new StringBuffer();
        int maxSize = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                expected.append(this.tokenImage[this.expectedTokenSequences[i][j]]).append(" ");
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected.append("...");
            }
            expected.append(this.eol).append("    ");
        }
        String retval = "Encountered \"";
        Token tok = this.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval = String.valueOf(retval).concat(" ");
            }
            if (tok.kind == 0) {
                String string = String.valueOf(retval);
                String string2 = String.valueOf(this.tokenImage[0]);
                retval = string2.length() != 0 ? string.concat(string2) : new String(string);
                break;
            }
            String string = String.valueOf(retval);
            String string3 = String.valueOf(this.add_escapes(tok.image));
            retval = string3.length() != 0 ? string.concat(string3) : new String(string);
            tok = tok.next;
        }
        String string = String.valueOf(retval);
        int n = this.currentToken.next.beginLine;
        int n2 = this.currentToken.next.beginColumn;
        retval = new StringBuilder(41 + String.valueOf(string).length()).append(string).append("\" at line ").append(n).append(", column ").append(n2).toString();
        string = String.valueOf(retval);
        String string4 = this.eol;
        retval = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string4).length()).append(string).append(".").append(string4).toString();
        if (this.expectedTokenSequences.length == 1) {
            string = String.valueOf(retval);
            string4 = this.eol;
            retval = new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string4).length()).append(string).append("Was expecting:").append(string4).append("    ").toString();
        } else {
            string = String.valueOf(retval);
            string4 = this.eol;
            retval = new StringBuilder(25 + String.valueOf(string).length() + String.valueOf(string4).length()).append(string).append("Was expecting one of:").append(string4).append("    ").toString();
        }
        String string5 = String.valueOf(retval);
        String string6 = String.valueOf(expected.toString());
        retval = string6.length() != 0 ? string5.concat(string6) : new String(string5);
        return retval;
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String string = String.valueOf(Integer.toString(ch, 16));
                        String s = string.length() != 0 ? "0000".concat(string) : new String("0000");
                        String string2 = String.valueOf(s.substring(s.length() - 4, s.length()));
                        retval.append(string2.length() != 0 ? "\\u".concat(string2) : new String("\\u"));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

