/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.exception;

import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.cloud.datastore.core.exception.LegacyProblem;
import com.google.cloud.datastore.core.exception.Problem;
import com.google.cloud.datastore.core.exception.ProblemCode;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class DatastoreException
extends Exception {
    private final RetryOptions retryOptions;
    private final DatastoreV3Pb.Error.ErrorCode errorCode;
    private final Problem problem;

    public static Builder builder() {
        return new Builder();
    }

    public boolean isNeverRetryable() {
        return this.retryOptions() == RetryOptions.NOT_RETRYABLE || this.errorCode.equals(DatastoreV3Pb.Error.ErrorCode.INTERNAL_ERROR);
    }

    public RetryOptions retryOptions() {
        return this.retryOptions;
    }

    public DatastoreException(String message, DatastoreV3Pb.Error.ErrorCode errorCode, @Nullable Throwable cause) {
        this(message, errorCode, LegacyProblem.create(message), cause, RetryOptions.DEFAULT);
    }

    public DatastoreException(ProblemCode problemCode, String message, DatastoreV3Pb.Error.ErrorCode errorCode) {
        this(message, errorCode, Problem.create(Preconditions.checkNotNull(problemCode)), null, RetryOptions.DEFAULT);
    }

    public DatastoreException(ProblemCode problemCode, String message, DatastoreV3Pb.Error.ErrorCode errorCode, @Nullable Throwable cause) {
        this(message, errorCode, Problem.create(Preconditions.checkNotNull(problemCode)), cause, RetryOptions.DEFAULT);
    }

    private DatastoreException(String message, DatastoreV3Pb.Error.ErrorCode errorCode, Problem problem, @Nullable Throwable cause, RetryOptions retryOptions) {
        super(Preconditions.checkNotNull(message), cause);
        this.errorCode = Preconditions.checkNotNull(errorCode);
        this.problem = problem;
        this.retryOptions = retryOptions;
    }

    public DatastoreV3Pb.Error.ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public DatastoreException withProblemCode(ProblemCode problemCode) {
        return this.withProblem(Problem.create(Preconditions.checkNotNull(problemCode)));
    }

    public DatastoreException withProblem(Problem problem) {
        return new DatastoreException(this.getMessage(), this.errorCode, Preconditions.checkNotNull(problem), this.getCause(), this.retryOptions);
    }

    public boolean sameErrorAndMessage(DatastoreException other) {
        return this.getErrorCode().equals(other.getErrorCode()) && this.getMessage().equals(other.getMessage()) && this.getProblem().getProblemCode().equals((Object)other.getProblem().getProblemCode());
    }

    public static class Builder {
        private RetryOptions retryOptions = RetryOptions.DEFAULT;
        private DatastoreV3Pb.Error.ErrorCode errorCode;
        private Problem problem;
        private String message;
        @Nullable
        private Throwable cause;

        public Builder forceNonRetryable() {
            Preconditions.checkArgument(this.retryOptions == RetryOptions.DEFAULT, "RetryOptions already set.");
            this.retryOptions = RetryOptions.NOT_RETRYABLE;
            return this;
        }

        public Builder continuation() {
            Preconditions.checkArgument(this.retryOptions == RetryOptions.DEFAULT, "RetryOptions already set.");
            this.retryOptions = RetryOptions.CONTINUATION;
            return this;
        }

        public Builder retryOptions(RetryOptions retryOptions) {
            this.retryOptions = Preconditions.checkNotNull(retryOptions);
            return this;
        }

        public Builder errorCode(DatastoreV3Pb.Error.ErrorCode errorCode) {
            this.errorCode = Preconditions.checkNotNull(errorCode);
            return this;
        }

        public Builder problemCode(ProblemCode problemCode) {
            this.problem = Preconditions.checkNotNull(Problem.create(problemCode));
            return this;
        }

        public Builder problem(Problem problem) {
            this.problem = Preconditions.checkNotNull(problem);
            return this;
        }

        public Builder message(String message) {
            this.message = Preconditions.checkNotNull(message);
            return this;
        }

        public Builder cause(@Nullable Throwable cause) {
            this.cause = cause;
            return this;
        }

        public DatastoreException build() {
            if (this.problem == null) {
                this.problem = LegacyProblem.create(this.message);
            }
            return new DatastoreException(this.message, this.errorCode, this.problem, this.cause, this.retryOptions);
        }
    }

    public static enum RetryOptions {
        DEFAULT,
        NOT_RETRYABLE,
        CONTINUATION;

    }
}

