/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.names.ProjectIdAppIdResolver;
import com.google.cloud.datastore.core.names.ProjectIds;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.common.base.Preconditions;

public class FirestoreV1AppIdResolver
extends ProjectIdAppIdResolver.ProjectIdResolver {
    private final DatabaseRef databaseRef;

    public FirestoreV1AppIdResolver(DatabaseRef databaseRef) {
        this.databaseRef = Preconditions.checkNotNull(databaseRef);
    }

    @Override
    public String toAppId(String projectId) throws InvalidConversionException {
        if (projectId.equals(this.databaseRef.projectId())) {
            return this.databaseRef.appId();
        }
        if (this.databaseRef.hasAppPartition()) {
            return ProjectIds.projectIdToApp(this.databaseRef.partitionId(), projectId);
        }
        return projectId;
    }
}

