/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class FirestoreV1ConverterHelper {
    private static final char ESCAPED_ID_ESCAPE_CHAR = '~';
    private static final char ESCAPED_ID_ESCAPED_CHAR_FOR_ESCAPE_CHAR = '0';
    private static final char ESCAPED_ID_ESCAPED_CHAR_FOR_SLASH = '1';
    private static final char ESCAPED_ID_ESCAPED_CHAR_FOR_DOT = '2';
    private static final String ESC_STRING_ID_PREFIX = "__esc";
    private static final Pattern ESC_STRING_RESOURCE_ID_REGEX = Pattern.compile("__esc(.*)__", 32);
    private static final String LONG_RESOURCE_ID_PREFIX = "__id";
    private static final Pattern LONG_RESOURCE_ID_REGEX = Pattern.compile("__id(-?[1-9][0-9]*)__");
    public static final String LONG_RESOURCE_ID_FORMAT = "__id%d__";
    public static final String DOT_RESOURCE_ID = ".";
    public static final String DOT_DOT_RESOURCE_ID = "..";
    private static final String ESCAPED_ID_ESCAPED_DOT = "~2";
    private static final String ESCAPED_DOT_RESOURCE_ID = "__esc~2__";
    private static final String ESCAPED_DOT_DOT_RESOURCE_ID = "__esc~2~2__";

    @Nullable
    public static String escapedIdToUnescapedIdOrNull(String contextFlavor, String escapedId) throws InvalidConversionException {
        if (!escapedId.startsWith(ESC_STRING_ID_PREFIX)) {
            return null;
        }
        Matcher patternMatch = ESC_STRING_RESOURCE_ID_REGEX.matcher(escapedId);
        if (!patternMatch.matches()) {
            return null;
        }
        String escapedText = patternMatch.group(1);
        int numEscapedTextChars = escapedText.length();
        StringBuilder stringBuilder = new StringBuilder(numEscapedTextChars);
        boolean containsEscapedSlashChar = false;
        for (int escapedTextIndex = 0; escapedTextIndex < numEscapedTextChars; ++escapedTextIndex) {
            char c = escapedText.charAt(escapedTextIndex);
            if (c == '~') {
                FirestoreV1ConverterHelper.checkEscapedIdToUnescapedIdOrNullConversion(++escapedTextIndex < numEscapedTextChars, contextFlavor, escapedId, "contains escaped text that ends with escape character '%c'.", Character.valueOf('~'));
                c = escapedText.charAt(escapedTextIndex);
                switch (c) {
                    case '0': {
                        c = '~';
                        break;
                    }
                    case '1': {
                        containsEscapedSlashChar = true;
                        c = '/';
                        break;
                    }
                    case '2': {
                        if (escapedId.equals(ESCAPED_DOT_RESOURCE_ID)) {
                            return DOT_RESOURCE_ID;
                        }
                        if (escapedId.equals(ESCAPED_DOT_DOT_RESOURCE_ID)) {
                            return DOT_DOT_RESOURCE_ID;
                        }
                        FirestoreV1ConverterHelper.checkEscapedIdToUnescapedIdOrNullConversion(false, contextFlavor, escapedId, "contains unnecessarily %c-escaped character '.'.", Character.valueOf('~'));
                        throw new AssertionError();
                    }
                    default: {
                        FirestoreV1ConverterHelper.checkEscapedIdToUnescapedIdOrNullConversion(false, contextFlavor, escapedId, "contains unknown %c-escaped character '%c'.", Character.valueOf('~'), Character.valueOf(c));
                        throw new AssertionError();
                    }
                }
            }
            stringBuilder.append(c);
        }
        FirestoreV1ConverterHelper.checkEscapedIdToUnescapedIdOrNullConversion(containsEscapedSlashChar, contextFlavor, escapedId, "is unnecessarily escaped.", new Object[0]);
        return stringBuilder.toString();
    }

    private static void checkEscapedIdToUnescapedIdOrNullConversion(boolean predicate, String contextFlavor, String escapedId, String moreFormat, Object ... moreFormatArgs) throws InvalidConversionException {
        if (predicate) {
            return;
        }
        ArrayList<Object> formatArgs = new ArrayList<Object>();
        formatArgs.add(contextFlavor);
        formatArgs.add(escapedId);
        formatArgs.addAll(Arrays.asList(moreFormatArgs));
        String string = String.valueOf(moreFormat);
        InvalidConversionException.checkConversion(false, string.length() != 0 ? "%s \"%s\" ".concat(string) : new String("%s \"%s\" "), formatArgs.toArray());
    }

    @Nullable
    public static String unescapedIdToEscapedId(String unescapedId) {
        if (unescapedId.equals(DOT_RESOURCE_ID)) {
            return ESCAPED_DOT_RESOURCE_ID;
        }
        if (unescapedId.equals(DOT_DOT_RESOURCE_ID)) {
            return ESCAPED_DOT_DOT_RESOURCE_ID;
        }
        if (unescapedId.indexOf(47) < 0) {
            return unescapedId;
        }
        int numChars = unescapedId.length();
        StringBuilder stringBuilder = new StringBuilder(numChars + 16);
        stringBuilder.append(ESC_STRING_ID_PREFIX);
        for (int index = 0; index < numChars; ++index) {
            char c = unescapedId.charAt(index);
            if (c == '~') {
                stringBuilder.append('~');
                stringBuilder.append('0');
                continue;
            }
            if (c == '/') {
                stringBuilder.append('~');
                stringBuilder.append('1');
                continue;
            }
            stringBuilder.append(c);
        }
        stringBuilder.append("__");
        return stringBuilder.toString();
    }

    public static long stringEntityResourceIdToLongEntityResourceIdOrZero(String stringResourceId) throws InvalidConversionException {
        long longValue;
        if (!stringResourceId.startsWith(LONG_RESOURCE_ID_PREFIX)) {
            return 0L;
        }
        Matcher patternMatch = LONG_RESOURCE_ID_REGEX.matcher(stringResourceId);
        if (!patternMatch.matches()) {
            return 0L;
        }
        String longText = patternMatch.group(1);
        try {
            longValue = Long.decode(longText);
        }
        catch (NumberFormatException exception) {
            InvalidConversionException.checkConversion(false, "Resource id \"%s\" is invalid because it is not a 64 bit integer.", stringResourceId);
            throw new AssertionError((Object)exception);
        }
        return longValue;
    }
}

