/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.cloud.datastore.core.rep.JndexValue;
import com.google.cloud.datastore.core.rep.proto.IndexValue;
import com.google.protobuf.Empty;
import com.google.protobuf.NullValue;
import java.util.Map;

public class FirestoreV1IndexValueFromRepConverter {
    public static final FirestoreV1IndexValueFromRepConverter INSTANCE = new FirestoreV1IndexValueFromRepConverter();
    private static final IndexValue API_NULL = IndexValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
    public static final IndexValue API_FALSE = IndexValue.newBuilder().setBooleanValue(false).build();
    public static final IndexValue API_TRUE = IndexValue.newBuilder().setBooleanValue(true).build();
    public static final IndexValue API_NAN = IndexValue.newBuilder().setNanValue(Empty.getDefaultInstance()).build();

    private FirestoreV1IndexValueFromRepConverter() {
    }

    public IndexValue convertEntityRefRelDatabase(JndexValue.EntityRef indexValueEntityRef) {
        return this.convertIndexValueEntityRef(true, indexValueEntityRef);
    }

    public IndexValue convertIndexValue(JndexValue indexValue) {
        switch (indexValue.type()) {
            case NULL: {
                return API_NULL;
            }
            case BOOLEAN: {
                return indexValue.asBoolean() ? API_TRUE : API_FALSE;
            }
            case NUMBER: {
                if (indexValue.equals(JndexValue.NAN)) {
                    return API_NAN;
                }
                IndexValue.NumberValue.Builder apiNumberValueBuilder = IndexValue.NumberValue.newBuilder();
                if (indexValue.isNumberDouble()) {
                    apiNumberValueBuilder.setDoubleValue(indexValue.asNumberDouble());
                } else {
                    apiNumberValueBuilder.setLongValue(indexValue.asNumberLong());
                }
                return IndexValue.newBuilder().setNumberValue(apiNumberValueBuilder.build()).build();
            }
            case TIMESTAMP: {
                return IndexValue.newBuilder().setTimestampValue(indexValue.asTimestamp()).build();
            }
            case STRING: {
                return IndexValue.newBuilder().setStringValue(this.partConvertStringIndexValue(indexValue)).build();
            }
            case BYTES: {
                return IndexValue.newBuilder().setBytesValue(IndexValue.BytesValue.newBuilder().setValue(indexValue.asBytes()).setTruncated(indexValue.isShallowTruncated()).build()).build();
            }
            case ENTITY_REF: {
                return this.convertIndexValueEntityRef(false, indexValue.asEntityRef());
            }
            case GEO_POINT: {
                return IndexValue.newBuilder().setGeoPointValue(indexValue.asGeoPoint()).build();
            }
            case ARRAY: {
                return this.convertArrayIndexValue(indexValue);
            }
            case MAP: {
                return this.convertMapIndexValue(indexValue);
            }
            case LEGACY_USER: 
            case ABSENT_TYPE: {
                throw new IllegalArgumentException();
            }
        }
        return null;
    }

    private IndexValue convertIndexValueEntityRef(boolean relDatabase, JndexValue.EntityRef entityRef) {
        IndexValue.DocumentResourceName.Builder apiDocumentResourceNameBuilder = IndexValue.DocumentResourceName.newBuilder();
        if (!relDatabase) {
            apiDocumentResourceNameBuilder.setProjectId(this.partConvertStringIndexValue(entityRef.projectId));
            apiDocumentResourceNameBuilder.setDatabaseId(this.partConvertStringIndexValue(entityRef.databaseId));
        }
        if (entityRef.namespaceId != JndexValue.ABSENT) {
            apiDocumentResourceNameBuilder.setNamespaceId(this.partConvertStringIndexValue(entityRef.namespaceId));
            boolean isDocumentResourceNameTruncated = false;
            if (entityRef.segments == JndexValue.ABSENT) {
                isDocumentResourceNameTruncated = !entityRef.namespaceId.isShallowTruncated();
            } else {
                for (JndexValue segment : entityRef.segments.asArray()) {
                    IndexValue.DocumentResourceName.Segment.Builder apiSegmentBuilder = IndexValue.DocumentResourceName.Segment.newBuilder();
                    if (segment.type() == JndexValue.Type.STRING) {
                        apiSegmentBuilder.setStringId(this.partConvertStringIndexValue(segment));
                    } else {
                        apiSegmentBuilder.setIntegerId(segment.asNumberLong());
                    }
                    apiDocumentResourceNameBuilder.addSegments(apiSegmentBuilder.build());
                }
                isDocumentResourceNameTruncated = entityRef.segments.isShallowTruncated();
            }
            apiDocumentResourceNameBuilder.setTruncated(isDocumentResourceNameTruncated);
        }
        return IndexValue.newBuilder().setResourceNameValue(IndexValue.ResourceName.newBuilder().setDocumentResourceName(apiDocumentResourceNameBuilder.build()).build()).build();
    }

    private IndexValue convertArrayIndexValue(JndexValue arrayIndexValue) {
        IndexValue.ArrayValue.Builder apiArrayValueBuilder = IndexValue.ArrayValue.newBuilder();
        for (JndexValue elementIndexValue : arrayIndexValue.asArray()) {
            apiArrayValueBuilder.addValues(this.convertIndexValue(elementIndexValue));
        }
        apiArrayValueBuilder.setTruncated(arrayIndexValue.isShallowTruncated());
        return IndexValue.newBuilder().setArrayValue(apiArrayValueBuilder.build()).build();
    }

    private IndexValue convertMapIndexValue(JndexValue mapIndexValue) {
        IndexValue.MapValue.Builder apiMapValueBuilder = IndexValue.MapValue.newBuilder();
        for (Map.Entry mapEntry : mapIndexValue.asMap().entrySet()) {
            JndexValue keyIndexValue = (JndexValue)mapEntry.getKey();
            JndexValue valueIndexValue = (JndexValue)mapEntry.getValue();
            IndexValue.MapValue.MapEntry.Builder apiMapEntryBuilder = IndexValue.MapValue.MapEntry.newBuilder();
            apiMapEntryBuilder.setKey(this.partConvertStringIndexValue(keyIndexValue));
            if (valueIndexValue != JndexValue.ABSENT) {
                apiMapEntryBuilder.setValue(this.convertIndexValue(valueIndexValue));
            }
            apiMapValueBuilder.addEntries(apiMapEntryBuilder.build());
        }
        apiMapValueBuilder.setTruncated(mapIndexValue.isShallowTruncated());
        return IndexValue.newBuilder().setMapValue(apiMapValueBuilder.build()).build();
    }

    private IndexValue.StringValue partConvertStringIndexValue(JndexValue stringIndexValue) {
        return IndexValue.StringValue.newBuilder().setValue(stringIndexValue.asString()).setTruncated(stringIndexValue.isShallowTruncated()).build();
    }
}

