/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.JndexValue;
import com.google.cloud.datastore.core.rep.proto.IndexValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;

public class FirestoreV1IndexValueToRepConverter {
    public static final FirestoreV1IndexValueToRepConverter INSTANCE = new FirestoreV1IndexValueToRepConverter();

    private FirestoreV1IndexValueToRepConverter() {
    }

    public JndexValue.EntityRef convertEntityRefRelDatabase(DatabaseRef databaseRef, IndexValue apiEntityRefIndexValue) throws InvalidConversionException {
        InvalidConversionException.checkConversion(apiEntityRefIndexValue.getValueTypeCase() == IndexValue.ValueTypeCase.RESOURCE_NAME_VALUE, "Expected document resource name.", new Object[0]);
        return this.convertIndexValueEntityRef(databaseRef, apiEntityRefIndexValue.getResourceNameValue());
    }

    public JndexValue convertIndexValue(IndexValue apiIndexValue) throws InvalidConversionException {
        switch (apiIndexValue.getValueTypeCase()) {
            case NULL_VALUE: {
                return JndexValue.NULL;
            }
            case BOOLEAN_VALUE: {
                return JndexValue.createBoolean(apiIndexValue.getBooleanValue());
            }
            case NAN_VALUE: {
                return JndexValue.NAN;
            }
            case NUMBER_VALUE: {
                IndexValue.NumberValue apiNumberIndexValue = apiIndexValue.getNumberValue();
                switch (apiNumberIndexValue.getNumberTypeCase()) {
                    case LONG_VALUE: {
                        return JndexValue.createNumberLong(apiNumberIndexValue.getLongValue());
                    }
                    case DOUBLE_VALUE: {
                        return JndexValue.createNumberDouble(apiNumberIndexValue.getDoubleValue());
                    }
                }
                throw new InvalidConversionException("Unknown IndexValue.NumberValue.number_type.");
            }
            case TIMESTAMP_VALUE: {
                return JndexValue.createTimestamp(apiIndexValue.getTimestampValue());
            }
            case STRING_VALUE: {
                return this.convertStringIndexValue(apiIndexValue.getStringValue());
            }
            case BYTES_VALUE: {
                IndexValue.BytesValue apiBytesIndexValue = apiIndexValue.getBytesValue();
                return JndexValue.createBytes(apiBytesIndexValue.getTruncated(), apiBytesIndexValue.getValue());
            }
            case RESOURCE_NAME_VALUE: {
                return JndexValue.createEntityRef(this.convertIndexValueEntityRef(null, apiIndexValue.getResourceNameValue()));
            }
            case GEO_POINT_VALUE: {
                return JndexValue.createGeoPoint(apiIndexValue.getGeoPointValue());
            }
            case MAP_VALUE: {
                return this.convertMapIndexValue(apiIndexValue.getMapValue());
            }
            case ARRAY_VALUE: {
                return this.convertArrayIndexValue(apiIndexValue.getArrayValue());
            }
        }
        throw new InvalidConversionException("Unknown IndexValue.value_type.");
    }

    private JndexValue.EntityRef convertIndexValueEntityRef(@Nullable DatabaseRef databaseRef, IndexValue.ResourceName apiResourceName) throws InvalidConversionException {
        switch (apiResourceName.getResourceTypeCase()) {
            case DOCUMENT_RESOURCE_NAME: {
                JndexValue segments;
                boolean apiHasSegments;
                JndexValue databaseId;
                JndexValue projectId;
                IndexValue.DocumentResourceName apiDocumentName = apiResourceName.getDocumentResourceName();
                if (databaseRef == null) {
                    IndexValue.StringValue apiProjectId = apiDocumentName.getProjectId();
                    InvalidConversionException.checkConversion(!apiProjectId.getTruncated(), "Truncated IndexValue.DocumentResourceName.project_id.", new Object[0]);
                    projectId = this.convertStringIndexValue(apiProjectId);
                    IndexValue.StringValue apiDatabaseId = apiDocumentName.getDatabaseId();
                    InvalidConversionException.checkConversion(!apiDatabaseId.getTruncated(), "Truncated IndexValue.DocumentResourceName.database_id.", new Object[0]);
                    databaseId = this.convertStringIndexValue(apiDatabaseId);
                } else {
                    InvalidConversionException.checkConversion(!apiDocumentName.hasProjectId(), "Unexpected IndexValue.DocumentResourceName.project_id.", new Object[0]);
                    projectId = JndexValue.createString(false, databaseRef.projectId());
                    InvalidConversionException.checkConversion(!apiDocumentName.hasDatabaseId(), "Unexpected IndexValue.DocumentResourceName.database_id.", new Object[0]);
                    databaseId = JndexValue.createString(false, databaseRef.databaseId());
                }
                JndexValue namespaceId = apiDocumentName.hasNamespaceId() ? this.convertStringIndexValue(apiDocumentName.getNamespaceId()) : JndexValue.ABSENT;
                boolean bl = apiHasSegments = apiDocumentName.getSegmentsCount() != 0;
                if (namespaceId.isShallowTruncated()) {
                    InvalidConversionException.checkConversion(!apiHasSegments, "Unexpected IndexValue.DocumentResourceName.segments.", new Object[0]);
                    InvalidConversionException.checkConversion(!apiDocumentName.getTruncated(), "Unexpected IndexValue.DocumentResourceName.truncated.", new Object[0]);
                    segments = JndexValue.ABSENT;
                } else if (!apiHasSegments) {
                    segments = apiDocumentName.getTruncated() ? JndexValue.ABSENT : JndexValue.EMPTY_ARRAY;
                } else {
                    ImmutableList.Builder segmentsBuilder = ImmutableList.builder();
                    for (IndexValue.DocumentResourceName.Segment apiSegment : apiDocumentName.getSegmentsList()) {
                        JndexValue segment;
                        switch (apiSegment.getIdTypeCase()) {
                            case INTEGER_ID: {
                                segment = JndexValue.createNumberLong(apiSegment.getIntegerId());
                                break;
                            }
                            case STRING_ID: {
                                segment = this.convertStringIndexValue(apiSegment.getStringId());
                                break;
                            }
                            default: {
                                throw new InvalidConversionException("Unknown IndexValue.DocumentResourceName.id_type.");
                            }
                        }
                        segmentsBuilder.add(segment);
                    }
                    segments = JndexValue.createArray(apiDocumentName.getTruncated(), (ImmutableList<JndexValue>)segmentsBuilder.build());
                }
                return new JndexValue.EntityRef(projectId, databaseId, namespaceId, segments);
            }
        }
        throw new InvalidConversionException("Unknown IndexValue.ResourceName.resource_type.");
    }

    private JndexValue convertArrayIndexValue(IndexValue.ArrayValue apiArrayIndexValue) throws InvalidConversionException {
        ImmutableList.Builder elementsBuilder = ImmutableList.builder();
        for (IndexValue apiElement : apiArrayIndexValue.getValuesList()) {
            elementsBuilder.add(this.convertIndexValue(apiElement));
        }
        return JndexValue.createArray(apiArrayIndexValue.getTruncated(), (ImmutableList<JndexValue>)elementsBuilder.build());
    }

    private JndexValue convertMapIndexValue(IndexValue.MapValue apiMapIndexValue) throws InvalidConversionException {
        ImmutableMap.Builder<JndexValue, JndexValue> mapBuilder = ImmutableMap.builder();
        for (IndexValue.MapValue.MapEntry apiMapEntry : apiMapIndexValue.getEntriesList()) {
            InvalidConversionException.checkConversion(apiMapEntry.hasKey(), "Expected IndexValue.MapValue.MapEntry.", new Object[0]);
            JndexValue keyIndexValue = this.convertStringIndexValue(apiMapEntry.getKey());
            JndexValue valueIndexValue = apiMapEntry.hasValue() ? this.convertIndexValue(apiMapEntry.getValue()) : JndexValue.ABSENT;
            mapBuilder.put(keyIndexValue, valueIndexValue);
        }
        return JndexValue.createMap(apiMapIndexValue.getTruncated(), mapBuilder.build());
    }

    private JndexValue convertStringIndexValue(IndexValue.StringValue apiStringIndexValue) throws InvalidConversionException {
        return JndexValue.createString(apiStringIndexValue.getTruncated(), apiStringIndexValue.getValue());
    }
}

