/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.cloud.datastore.core.common.DatastoreCoreConfig;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1EntityToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1IndexValueToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1PropertyPathToRepConverter;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1ResourceRefToRepConverter;
import com.google.cloud.datastore.core.index.IndexValueConverter;
import com.google.cloud.datastore.core.index.firestore.FirestoreIndexValueToValueConverter;
import com.google.cloud.datastore.core.index.firestore.ValueToFirestoreIndexValueConverter;
import com.google.cloud.datastore.core.names.ProjectIdAppIdResolver;
import com.google.cloud.datastore.core.rep.Condition;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.JndexValue;
import com.google.cloud.datastore.core.rep.LogicalCondition;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.PropertyPathWithDirection;
import com.google.cloud.datastore.core.rep.PropertyValueCondition;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.QueryScope;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.UnifiedIndexValue;
import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.proto.IndexValue;
import com.google.cloud.datastore.core.rep.proto.QueryResumeToken;
import com.google.cloud.datastore.internal.InternalHeader;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.StructuredQuery;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import javax.annotation.Nullable;

public class FirestoreV1QueryToRepConverter {
    private final FirestoreV1PropertyPathToRepConverter propertyPathToRepConverter;
    private final FirestoreV1EntityToRepConverter entityToRepConverter;
    private final FirestoreV1ResourceRefToRepConverter resourceRefToRepConverter;

    public FirestoreV1QueryToRepConverter(FirestoreV1PropertyPathToRepConverter propertyPathToRepConverter, FirestoreV1EntityToRepConverter entityToRepConverter, FirestoreV1ResourceRefToRepConverter resourceRefToRepConverter) {
        this.propertyPathToRepConverter = Preconditions.checkNotNull(propertyPathToRepConverter);
        this.entityToRepConverter = Preconditions.checkNotNull(entityToRepConverter);
        this.resourceRefToRepConverter = Preconditions.checkNotNull(resourceRefToRepConverter);
    }

    public Query convertQueryResumeState(Query baseQuery, long baseQueryFingerprint, QueryResumeToken queryResumeToken) throws InvalidConversionException {
        InvalidConversionException.checkConversion(queryResumeToken.getVersionCase() == QueryResumeToken.VersionCase.V1, "unexpected QueryResumeToken version", new Object[0]);
        QueryResumeToken.V1 apiQrtV1 = queryResumeToken.getV1();
        long apiFingerprint = apiQrtV1.getFingerprint();
        InvalidConversionException.checkConversion(apiFingerprint != 0L, "Query resume token lacks fingerprint.", new Object[0]);
        InvalidConversionException.checkConversion(apiFingerprint == baseQueryFingerprint, "Query resume token fingerprint does not match query.", new Object[0]);
        List<IndexValue> apiIndexValues = apiQrtV1.getIndexValuesList();
        int keyIndex = apiIndexValues.size() - 1;
        IndexValue apiIndexValueEntityRef = apiIndexValues.get(keyIndex);
        DatabaseRef databaseRef = baseQuery.scope().partition().databaseRef();
        EntityRef indexValueKeyEntityRef = null;
        EntityRef jndexValueKeyEntityRef = null;
        if (DatastoreCoreConfig.compareIndexValueJndexValue || !DatastoreCoreConfig.useJndexValue) {
            indexValueKeyEntityRef = IndexValueConverter.INSTANCE.toEntityRef(databaseRef, apiIndexValueEntityRef);
        }
        if (DatastoreCoreConfig.compareIndexValueJndexValue || DatastoreCoreConfig.useJndexValue) {
            jndexValueKeyEntityRef = FirestoreIndexValueToValueConverter.INSTANCE.convertEntityRef(databaseRef.partitionId(), FirestoreV1IndexValueToRepConverter.INSTANCE.convertEntityRefRelDatabase(databaseRef, apiIndexValueEntityRef));
        }
        if (DatastoreCoreConfig.compareIndexValueJndexValue && !indexValueKeyEntityRef.equals(jndexValueKeyEntityRef)) {
            DatastoreCoreConfig.hackReportProblem(DatastoreCoreConfig.ProblemType.INDEX_JNDEX_FIELD_QUERY_RESUME_TOKEN_MISMATCH, baseQuery.scope().partition().databaseRef(), new Exception(apiIndexValues.toString()));
        }
        EntityRef keyEntityRef = DatastoreCoreConfig.useJndexValue ? jndexValueKeyEntityRef : indexValueKeyEntityRef;
        ImmutableList.Builder indexValuesBuilder = ImmutableList.builder();
        for (int index = 0; index < keyIndex; ++index) {
            JndexValue jndexValue;
            IndexValue apiIndexValue = apiIndexValues.get(index);
            if (DatastoreCoreConfig.compareIndexValueJndexValue || DatastoreCoreConfig.useJndexValue) {
                jndexValue = FirestoreV1IndexValueToRepConverter.INSTANCE.convertIndexValue(apiIndexValue);
                if (DatastoreCoreConfig.compareIndexValueJndexValue) {
                    jndexValue.setXjProto(apiIndexValue);
                }
            } else {
                jndexValue = JndexValue.xjCreateProto(apiIndexValue);
            }
            UnifiedIndexValue unifiedIndexValue = UnifiedIndexValue.create(jndexValue);
            indexValuesBuilder.add(unifiedIndexValue);
        }
        com.google.cloud.datastore.core.rep.Cursor resumeCursor = com.google.cloud.datastore.core.rep.Cursor.create(keyEntityRef, null, (ImmutableList<UnifiedIndexValue>)indexValuesBuilder.build());
        Query.Builder newQueryBuilder = baseQuery.toBuilder();
        newQueryBuilder.startCursor(null);
        newQueryBuilder.resumeCursor(resumeCursor);
        newQueryBuilder.offset(apiQrtV1.getOffsetRemaining());
        if (apiQrtV1.hasLimitRemaining()) {
            newQueryBuilder.limit(apiQrtV1.getLimitRemaining().getValue());
        }
        return newQueryBuilder.build();
    }

    public Query convertStructuredQuery(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, QueryScope scope, @Nullable EntityRef rootEntity, StructuredQuery apiQuery) throws InvalidConversionException {
        int apiOffset;
        Direction firstOrderByDirection;
        List<StructuredQuery.Order> apiOrderBys;
        Query.Builder queryBuilder = Query.builder();
        queryBuilder.scope(scope);
        queryBuilder.semantics(Query.Semantics.FIRESTORE);
        queryBuilder.ancestor(rootEntity);
        queryBuilder.isShallow(true);
        List<StructuredQuery.CollectionSelector> apiFroms = apiQuery.getFromList();
        if (!apiFroms.isEmpty()) {
            InvalidConversionException.checkConversion(apiFroms.size() == 1, "StructuredQuery.from cannot have more than one collection selector.", new Object[0]);
            StructuredQuery.CollectionSelector collectionSelector = apiFroms.get(0);
            String apiCollectionId = collectionSelector.getCollectionId();
            if (!apiCollectionId.isEmpty()) {
                queryBuilder.kind(this.resourceRefToRepConverter.convertEntityCollectionId(apiCollectionId));
            }
            queryBuilder.isShallow(!collectionSelector.getAllDescendants());
            if (collectionSelector.getAllDescendants() && rootEntity != null) {
                Value ancestorValue = Value.createEntityRef(rootEntity).withV3Value(V3Paths.toReferenceProperty(rootEntity.v3Reference()), OnestoreEntity.Property.Meaning.NO_MEANING);
                queryBuilder.addCondition(PropertyValueCondition.create(Condition.Op.GT, PropertyPath.KEY, ancestorValue));
            }
        }
        if (apiQuery.hasWhere()) {
            queryBuilder.addCondition(this.convertCondition(apiVersion, resolver, apiQuery.getWhere()));
        }
        if (apiQuery.hasSelect()) {
            queryBuilder.propertyMask(this.propertyPathToRepConverter.convertPropertyMaskForV3(apiVersion, apiQuery.getSelect()));
        }
        ImmutableList<PropertyPathWithDirection> orderBys = (apiOrderBys = apiQuery.getOrderByList()).isEmpty() ? ImmutableList.of() : this.convertOrders(apiVersion, apiOrderBys);
        queryBuilder.orderBy(orderBys);
        Direction direction = firstOrderByDirection = orderBys.isEmpty() ? Direction.ASCENDING : ((PropertyPathWithDirection)orderBys.get(0)).direction();
        if (apiQuery.hasStartAt() || apiQuery.hasEndAt()) {
            ImmutableList<PropertyPath> cursorPropertyPaths = this.makeCursorPropertyPaths(orderBys);
            if (apiQuery.hasStartAt()) {
                queryBuilder.startCursor(this.convertCursor(resolver, cursorPropertyPaths, firstOrderByDirection, apiQuery.getStartAt()));
            }
            if (apiQuery.hasEndAt()) {
                queryBuilder.endCursor(this.convertCursor(resolver, cursorPropertyPaths, firstOrderByDirection, apiQuery.getEndAt()));
            }
        }
        if ((apiOffset = apiQuery.getOffset()) != 0) {
            queryBuilder.offset(apiOffset);
        }
        if (apiQuery.hasLimit()) {
            queryBuilder.limit(apiQuery.getLimit().getValue());
        }
        return queryBuilder.build();
    }

    private ImmutableList<Condition> convertConditions(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, List<StructuredQuery.Filter> apiFilters) throws InvalidConversionException {
        ImmutableList.Builder conditionsBuilder = ImmutableList.builder();
        for (StructuredQuery.Filter apiFilter : apiFilters) {
            conditionsBuilder.add(this.convertCondition(apiVersion, resolver, apiFilter));
        }
        return conditionsBuilder.build();
    }

    private Condition convertCondition(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, StructuredQuery.Filter apiFilter) throws InvalidConversionException {
        switch (apiFilter.getFilterTypeCase()) {
            case COMPOSITE_FILTER: {
                return this.convertCondition(apiVersion, resolver, apiFilter.getCompositeFilter());
            }
            case FIELD_FILTER: {
                return this.convertCondition(apiVersion, resolver, apiFilter.getFieldFilter());
            }
            case UNARY_FILTER: {
                return this.convertCondition(apiVersion, apiFilter.getUnaryFilter());
            }
        }
        throw new InvalidConversionException("Unknown Filter type.");
    }

    private Condition convertCondition(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, StructuredQuery.CompositeFilter apiFilter) throws InvalidConversionException {
        Condition.Op op;
        switch (apiFilter.getOp()) {
            case AND: {
                op = Condition.Op.AND;
                break;
            }
            default: {
                throw new InvalidConversionException("Unknown CompositeFilter operator.");
            }
        }
        return LogicalCondition.create(op, this.convertConditions(apiVersion, resolver, apiFilter.getFiltersList()));
    }

    private Condition convertCondition(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, StructuredQuery.FieldFilter apiFilter) throws InvalidConversionException {
        Condition.Op op;
        PropertyPath propertyPath = this.convertPropertyRef(apiVersion, apiFilter.getField());
        switch (apiFilter.getOp()) {
            case LESS_THAN: {
                op = Condition.Op.LT;
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                op = Condition.Op.LE;
                break;
            }
            case GREATER_THAN: {
                op = Condition.Op.GT;
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                op = Condition.Op.GE;
                break;
            }
            case EQUAL: {
                op = Condition.Op.EQ;
                break;
            }
            case ARRAY_CONTAINS: {
                op = Condition.Op.EQ;
                propertyPath = PropertyPath.create(propertyPath, PropertyPathSegment.AllArrayElements.create());
                break;
            }
            default: {
                InvalidConversionException.checkConversion(false, "Unknown FieldFilter operator.", new Object[0]);
                throw new AssertionError();
            }
        }
        Value value = this.entityToRepConverter.convertValue(resolver, apiFilter.getValue()).withDatastoreIndexing(Value.DatastoreIndexing.INCLUDE);
        if (value.isNull()) {
            return this.makeFalseCondition(propertyPath);
        }
        return PropertyValueCondition.create(op, propertyPath, value);
    }

    private Condition convertCondition(InternalHeader.ApiVersion apiVersion, StructuredQuery.UnaryFilter apiFilter) throws InvalidConversionException {
        PropertyPath propertyPath;
        switch (apiFilter.getOperandTypeCase()) {
            case FIELD: {
                propertyPath = this.convertPropertyRef(apiVersion, apiFilter.getField());
                break;
            }
            default: {
                InvalidConversionException.checkConversion(false, "Unknown UnaryFilter operand type.", new Object[0]);
                throw new AssertionError();
            }
        }
        switch (apiFilter.getOp()) {
            case IS_NULL: {
                return PropertyValueCondition.create(Condition.Op.EQ, propertyPath, Value.NULL);
            }
            case IS_NAN: {
                return PropertyValueCondition.create(Condition.Op.REALLY_EQUALS, propertyPath, Value.NAN);
            }
        }
        InvalidConversionException.checkConversion(false, "Unknown UnaryFilter operator.", new Object[0]);
        throw new AssertionError();
    }

    private Condition makeFalseCondition(PropertyPath path) {
        if (path.isArrayElements()) {
            return PropertyValueCondition.create(Condition.Op.EQ, path, Value.EMPTY_ARRAY);
        }
        return LogicalCondition.create(Condition.Op.AND, PropertyValueCondition.create(Condition.Op.EQ, path, Value.TRUE), PropertyValueCondition.create(Condition.Op.EQ, path, Value.FALSE));
    }

    private ImmutableList<PropertyPathWithDirection> convertOrders(InternalHeader.ApiVersion apiVersion, List<StructuredQuery.Order> apiOrderBys) throws InvalidConversionException {
        ImmutableList.Builder projectionPropertyPathWithDirections = ImmutableList.builder();
        for (StructuredQuery.Order apiOrderBy : apiOrderBys) {
            PropertyPath propertyPath = this.convertPropertyRef(apiVersion, apiOrderBy.getField());
            Direction direction = apiOrderBy.getDirection() == StructuredQuery.Direction.DESCENDING ? Direction.DESCENDING : Direction.ASCENDING;
            projectionPropertyPathWithDirections.add(PropertyPathWithDirection.create(propertyPath, direction));
        }
        return projectionPropertyPathWithDirections.build();
    }

    private ImmutableList<PropertyPath> makeCursorPropertyPaths(ImmutableList<PropertyPathWithDirection> orderBys) {
        ImmutableList.Builder cursorPropertyPathsBuilder = ImmutableList.builder();
        for (PropertyPathWithDirection orderBy : orderBys) {
            cursorPropertyPathsBuilder.add(orderBy.propertyPath());
        }
        return cursorPropertyPathsBuilder.build();
    }

    public com.google.cloud.datastore.core.rep.Cursor convertCursor(ProjectIdAppIdResolver resolver, ImmutableList<PropertyPath> propertyPaths, Direction firstOrderByDirection, Cursor apiPosition) throws InvalidConversionException {
        int numProperties = propertyPaths.size();
        List<com.google.firestore.v1.Value> apiValueList = apiPosition.getValuesList();
        int numValues = apiValueList.size();
        InvalidConversionException.checkConversion(numValues <= numProperties, "Cursor has too many values.", new Object[0]);
        EntityRef key = null;
        ImmutableList.Builder indexValuesBuilder = ImmutableList.builder();
        for (int index = 0; index < numValues; ++index) {
            JndexValue jndexValue;
            PropertyPath propertyPath = (PropertyPath)propertyPaths.get(index);
            com.google.firestore.v1.Value apiValue = apiValueList.get(index);
            Value value = this.entityToRepConverter.convertValue(resolver, apiValue);
            if (propertyPath.isKey()) {
                InvalidConversionException.checkConversion(value.type() == Value.Type.ENTITY_REF, "Cursor %s value is not a document reference.", ReservedName.KEY.asString());
                key = value.asEntityRef();
                break;
            }
            IndexValue indexValue = null;
            if (DatastoreCoreConfig.compareIndexValueJndexValue || !DatastoreCoreConfig.useJndexValue) {
                indexValue = IndexValueConverter.INSTANCE.toTruncatedIndexValue(value);
            }
            if (DatastoreCoreConfig.compareIndexValueJndexValue || DatastoreCoreConfig.useJndexValue) {
                jndexValue = ValueToFirestoreIndexValueConverter.DEFAULT.convertValueTruncateIfThresholdExceeded(value);
                jndexValue.setXjProto(indexValue);
            } else {
                jndexValue = JndexValue.xjCreateProto(indexValue);
            }
            UnifiedIndexValue unifiedIndexValue = UnifiedIndexValue.create(jndexValue);
            indexValuesBuilder.add(unifiedIndexValue);
        }
        return com.google.cloud.datastore.core.rep.Cursor.create(key, propertyPaths, (ImmutableList<UnifiedIndexValue>)indexValuesBuilder.build(), apiPosition.getBefore(), firstOrderByDirection);
    }

    private PropertyPath convertPropertyRef(InternalHeader.ApiVersion apiVersion, StructuredQuery.FieldReference apiFieldReference) throws InvalidConversionException {
        return this.propertyPathToRepConverter.convertFieldPathToPropertyPath(apiVersion, apiFieldReference.getFieldPath());
    }
}

