/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1ConverterHelper;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.OtherServiceResourceRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.ResourceRef;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;

public class FirestoreV1ResourceRefFromRepConverter {
    public static final FirestoreV1ResourceRefFromRepConverter INSTANCE = new FirestoreV1ResourceRefFromRepConverter();

    private FirestoreV1ResourceRefFromRepConverter() {
    }

    public String convertResourceRef(ResourceRef resourceRef) throws InvalidConversionException {
        if (resourceRef instanceof EntityRef) {
            return this.convertEntityRefServiceRelative((EntityRef)resourceRef);
        }
        if (resourceRef instanceof DatabaseRef) {
            return this.convertDatabaseRefServiceRelative((DatabaseRef)resourceRef);
        }
        if (resourceRef instanceof PartitionRef) {
            return this.convertPartitionRefServiceRelative((PartitionRef)resourceRef);
        }
        if (resourceRef instanceof OtherServiceResourceRef) {
            return this.convertOtherServiceResourceRef((OtherServiceResourceRef)resourceRef);
        }
        throw new InvalidConversionException("Unknown resource reference type.");
    }

    public String convertDatabaseRefWithServicePrefix(DatabaseRef databaseRef) {
        return this.convertDatabaseRefHelper(true, databaseRef);
    }

    public String convertDatabaseRefServiceRelative(DatabaseRef databaseRef) {
        return this.convertDatabaseRefHelper(false, databaseRef);
    }

    private String convertDatabaseRefHelper(boolean withServicePrefix, DatabaseRef databaseRef) {
        StringBuilder stringBuilder = this.makeStringBuilder();
        if (withServicePrefix) {
            stringBuilder.append("//firestore.googleapis.com/");
        }
        this.appendDatabaseRef(stringBuilder, databaseRef);
        return stringBuilder.toString();
    }

    public String convertPartitionRefWithServicePrefix(PartitionRef partitionRef) {
        return this.convertPartitionRefHelper(true, partitionRef);
    }

    public String convertPartitionRefServiceRelative(PartitionRef partitionRef) {
        return this.convertPartitionRefHelper(false, partitionRef);
    }

    private String convertPartitionRefHelper(boolean withServicePrefix, PartitionRef partitionRef) {
        StringBuilder stringBuilder = this.makeStringBuilder();
        if (withServicePrefix) {
            stringBuilder.append("//firestore.googleapis.com/");
        }
        this.appendDatabaseRef(stringBuilder, partitionRef.databaseRef());
        stringBuilder.append('/');
        stringBuilder.append("namespaces");
        stringBuilder.append('/');
        String namespaceId = partitionRef.namespace();
        if (namespaceId.isEmpty()) {
            namespaceId = "(default)";
        }
        stringBuilder.append(namespaceId);
        return stringBuilder.toString();
    }

    public String convertEntityRefWithServicePrefix(EntityRef entityRef) throws InvalidConversionException {
        return this.convertEntityRefHelper(true, entityRef);
    }

    public String convertEntityRefServiceRelativeUnchecked(EntityRef entityRef) {
        try {
            return this.convertEntityRefHelper(false, entityRef);
        }
        catch (InvalidConversionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String convertEntityRefServiceRelative(EntityRef entityRef) throws InvalidConversionException {
        return this.convertEntityRefHelper(false, entityRef);
    }

    private String convertEntityRefHelper(boolean withServicePrefix, EntityRef entityRef) throws InvalidConversionException {
        StringBuilder stringBuilder = this.makeStringBuilder();
        if (withServicePrefix) {
            stringBuilder.append("//firestore.googleapis.com/");
        }
        this.appendEntityRef(stringBuilder, true, true, entityRef);
        return stringBuilder.toString();
    }

    public String convertEntityRefDatabaseRelative(EntityRef entityRef) throws InvalidConversionException {
        StringBuilder stringBuilder = this.makeStringBuilder();
        this.appendEntityRef(stringBuilder, false, true, entityRef);
        return stringBuilder.toString();
    }

    public String convertEntityRefNamespaceRelative(EntityRef entityRef) throws InvalidConversionException {
        StringBuilder stringBuilder = this.makeStringBuilder();
        this.appendEntityRef(stringBuilder, false, false, entityRef);
        return stringBuilder.toString();
    }

    private void appendEntityRef(StringBuilder stringBuilder, boolean withDatabasePrefix, boolean withNamespacePrefix, EntityRef entityRef) throws InvalidConversionException {
        Preconditions.checkArgument(!withDatabasePrefix || withNamespacePrefix, "Can't elide the namespace prefix but keep the database prefix");
        if (withNamespacePrefix) {
            this.appendPartitionRef(stringBuilder, withDatabasePrefix, entityRef.partitionRef());
            stringBuilder.append('/');
        }
        ImmutableList<EntityRef.PathElement> entityPath = entityRef.pathElements();
        int entityPathLength = entityRef.pathElements().size();
        InvalidConversionException.checkConversion(entityPathLength != 0, "Entity reference has empty path.", new Object[0]);
        for (int i = 0; i < entityPathLength; ++i) {
            EntityRef.PathElement entityPathElement = (EntityRef.PathElement)entityPath.get(i);
            EntityRef.ResourceId resourceId = entityPathElement.resourceId();
            String collectionId = entityPathElement.collectionId();
            stringBuilder.append(FirestoreV1ConverterHelper.unescapedIdToEscapedId(collectionId));
            stringBuilder.append('/');
            String stringResourceId = this.convertEntityResourceId(resourceId);
            stringBuilder.append(stringResourceId);
            if (i >= entityPathLength - 1) continue;
            stringBuilder.append('/');
        }
    }

    private String convertEntityResourceId(@Nullable EntityRef.ResourceId entityResourceId) {
        if (entityResourceId == null) {
            return "__none__";
        }
        String stringEntityResourceId = entityResourceId.asString();
        if (stringEntityResourceId != null) {
            return FirestoreV1ConverterHelper.unescapedIdToEscapedId(stringEntityResourceId);
        }
        long longEntityResourceId = entityResourceId.asLong();
        return String.format("__id%d__", longEntityResourceId);
    }

    private void appendPartitionRef(StringBuilder stringBuilder, boolean withDatabasePrefix, PartitionRef partitionRef) {
        if (withDatabasePrefix) {
            DatabaseRef databaseRef = partitionRef.databaseRef();
            this.appendDatabaseRef(stringBuilder, databaseRef);
            stringBuilder.append('/');
        }
        String namespaceId = partitionRef.namespace();
        stringBuilder.append("documents");
        if (!namespaceId.isEmpty()) {
            stringBuilder.append('@');
            stringBuilder.append(namespaceId);
        }
    }

    private void appendDatabaseRef(StringBuilder stringBuilder, DatabaseRef databaseRef) {
        stringBuilder.append("projects");
        stringBuilder.append('/');
        stringBuilder.append(databaseRef.projectId());
        stringBuilder.append('/');
        stringBuilder.append("databases");
        stringBuilder.append('/');
        String databaseId = databaseRef.databaseId();
        stringBuilder.append(databaseId.isEmpty() ? "(default)" : databaseId);
    }

    public String convertOtherServiceResourceRef(OtherServiceResourceRef otherServiceResourceRef) {
        StringBuilder stringBuilder = this.makeStringBuilder();
        stringBuilder.append("//");
        stringBuilder.append(otherServiceResourceRef.service());
        for (String id : otherServiceResourceRef.ids()) {
            stringBuilder.append('/');
            stringBuilder.append(id);
        }
        return stringBuilder.toString();
    }

    private StringBuilder makeStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder(128);
        return stringBuilder;
    }

    public String convertEntityCollectionId(String entityCollectionId) {
        return FirestoreV1ConverterHelper.unescapedIdToEscapedId(entityCollectionId);
    }
}

