/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.firestorev1.converter;

import com.google.cloud.datastore.core.appengv3.converter.AppEngV3ResourceRefFromRepConverter;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1ConverterHelper;
import com.google.cloud.datastore.core.firestorev1.converter.FirestoreV1ResourceNameParser;
import com.google.cloud.datastore.core.names.Names;
import com.google.cloud.datastore.core.names.ProjectIdAppIdResolver;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.OtherServiceResourceRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.ResourceRef;
import com.google.cloud.datastore.internal.InternalHeader;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class FirestoreV1ResourceRefToRepConverter {
    private final boolean allowNamespaces;
    private final boolean allowNumberId;

    public FirestoreV1ResourceRefToRepConverter(boolean allowNamespaces, boolean allowNumberId) {
        this.allowNamespaces = allowNamespaces;
        this.allowNumberId = allowNumberId;
    }

    public ResourceRef convertResourceRef(ProjectIdAppIdResolver resolver, String resourceName) throws InvalidConversionException {
        return this.convertResourceRefHelper(resolver, true, resourceName);
    }

    public ResourceRef convertResourceRefAllowFirestoreRelative(ProjectIdAppIdResolver resolver, String resourceName) throws InvalidConversionException {
        return this.convertResourceRefHelper(resolver, false, resourceName);
    }

    public ResourceRef convertEntityParentRefAllowFirestoreRelative(InternalHeader.ApiVersion apiVersion, ProjectIdAppIdResolver resolver, String resourceName) throws InvalidConversionException {
        boolean requireDocumentSpecifier;
        boolean withServicePrefix = resourceName.startsWith("/");
        InvalidConversionException.checkConversion(!withServicePrefix || resourceName.startsWith("//firestore.googleapis.com/"), "Document parent \"%s\" not recognized.", resourceName);
        FirestoreV1ResourceNameParser parser = new FirestoreV1ResourceNameParser(withServicePrefix, "Document parent", resourceName);
        DatabaseRef databaseRef = this.parseDatabaseRef(resolver, parser);
        boolean bl = requireDocumentSpecifier = apiVersion != InternalHeader.ApiVersion.FIRESTORE_V1BETA1 && apiVersion != InternalHeader.ApiVersion.API_VERSION_UNSPECIFIED;
        if (!requireDocumentSpecifier && parser.isEnd()) {
            return PartitionRef.createFromDatabaseRef(databaseRef);
        }
        parser.parseSlash();
        PartitionRef partitionRef = this.parseDocumentSpecifier(resourceName, parser, databaseRef);
        if (parser.isEnd()) {
            return partitionRef;
        }
        return this.parseEntityCollectionIdResourceIdPairs(parser, partitionRef);
    }

    private ResourceRef convertResourceRefHelper(ProjectIdAppIdResolver resolver, boolean requireService, String resourceName) throws InvalidConversionException {
        FirestoreV1ResourceNameParser parser;
        if (resourceName.startsWith("/")) {
            if (!resourceName.startsWith("//firestore.googleapis.com/")) {
                return this.convertOtherServiceResourceRef(resourceName);
            }
            parser = new FirestoreV1ResourceNameParser(true, "Resource", resourceName);
        } else {
            InvalidConversionException.checkConversion(!requireService, "Resource name \"%s\" is not full.", resourceName);
            parser = new FirestoreV1ResourceNameParser(false, "Resource", resourceName);
        }
        DatabaseRef databaseRef = this.parseDatabaseRef(resolver, parser);
        if (parser.isEnd()) {
            parser.end();
            return databaseRef;
        }
        parser.parseSlash();
        if (parser.peekPrefix("documents")) {
            return this.parseDocumentNameDatabaseRelative(resourceName, parser, databaseRef);
        }
        if (parser.peek("namespaces")) {
            return this.parseNamespaceDatabaseRelative(parser, databaseRef);
        }
        InvalidConversionException.checkConversion(false, "Resource \"%s\" is not recognized.", resourceName);
        throw new AssertionError();
    }

    public DatabaseRef convertDatabaseRef(ProjectIdAppIdResolver resolver, String databaseName) throws InvalidConversionException {
        return this.convertDatabaseRefHelper(resolver, true, databaseName);
    }

    public DatabaseRef convertDatabaseRefServiceRelative(ProjectIdAppIdResolver resolver, String databaseName) throws InvalidConversionException {
        return this.convertDatabaseRefHelper(resolver, false, databaseName);
    }

    private DatabaseRef convertDatabaseRefHelper(ProjectIdAppIdResolver resolver, boolean withServicePrefix, String databaseName) throws InvalidConversionException {
        FirestoreV1ResourceNameParser parser = new FirestoreV1ResourceNameParser(withServicePrefix, "Database", databaseName);
        DatabaseRef databaseRef = this.parseDatabaseRef(resolver, parser);
        parser.end();
        return databaseRef;
    }

    public PartitionRef convertNamespaceRef(ProjectIdAppIdResolver resolver, String namespaceName) throws InvalidConversionException {
        return this.convertNamespaceRefHelper(resolver, true, namespaceName);
    }

    public PartitionRef convertNamespaceRefServiceRelative(ProjectIdAppIdResolver resolver, String namespaceName) throws InvalidConversionException {
        return this.convertNamespaceRefHelper(resolver, false, namespaceName);
    }

    private PartitionRef convertNamespaceRefHelper(ProjectIdAppIdResolver resolver, boolean withServicePrefix, String namespaceName) throws InvalidConversionException {
        FirestoreV1ResourceNameParser parser = new FirestoreV1ResourceNameParser(withServicePrefix, "Namespace", namespaceName);
        DatabaseRef databaseRef = this.parseDatabaseRef(resolver, parser);
        parser.parseSlash();
        return this.parseNamespaceDatabaseRelative(parser, databaseRef);
    }

    private PartitionRef parseNamespaceDatabaseRelative(FirestoreV1ResourceNameParser parser, DatabaseRef databaseRef) throws InvalidConversionException {
        parser.parseCollectionId("namespaces");
        parser.parseSlash();
        String namespaceId = parser.parseId("a namespace id");
        if (namespaceId.equals("(default)")) {
            namespaceId = "";
        }
        parser.end();
        return PartitionRef.createFromDatabaseRefAndNamespace(databaseRef, namespaceId);
    }

    public EntityRef convertEntityRefWithServicePrefix(ProjectIdAppIdResolver resolver, String documentName) throws InvalidConversionException {
        return this.convertEntityRefHelper(resolver, true, documentName);
    }

    public EntityRef convertEntityRefServiceRelative(ProjectIdAppIdResolver resolver, String documentName) throws InvalidConversionException {
        return this.convertEntityRefHelper(resolver, false, documentName);
    }

    public EntityRef convertEntityRefDatabaseRelative(DatabaseRef databaseRef, String documentName) throws InvalidConversionException {
        FirestoreV1ResourceNameParser parser = new FirestoreV1ResourceNameParser(false, "Document", documentName);
        return this.parseDocumentNameDatabaseRelative(documentName, parser, databaseRef);
    }

    private EntityRef convertEntityRefHelper(ProjectIdAppIdResolver resolver, boolean withServicePrefix, String documentName) throws InvalidConversionException {
        FirestoreV1ResourceNameParser parser = new FirestoreV1ResourceNameParser(withServicePrefix, "Document", documentName);
        DatabaseRef databaseRef = this.parseDatabaseRef(resolver, parser);
        parser.parseSlash();
        return this.parseDocumentNameDatabaseRelative(documentName, parser, databaseRef);
    }

    public DatabaseRef parseDatabaseRef(ProjectIdAppIdResolver resolver, FirestoreV1ResourceNameParser parser) throws InvalidConversionException {
        parser.parseCollectionId("projects");
        parser.parseSlash();
        String projectId = parser.parseId("a project id");
        parser.parseSlash();
        parser.parseCollectionId("databases");
        parser.parseSlash();
        String databaseId = parser.parseId("a database id");
        if (databaseId.equals("(default)")) {
            databaseId = "";
        }
        return DatabaseRef.createForApp(resolver.toAppId(projectId), databaseId);
    }

    private EntityRef parseDocumentNameDatabaseRelative(String documentName, FirestoreV1ResourceNameParser parser, DatabaseRef databaseRef) throws InvalidConversionException {
        PartitionRef partitionRef = this.parseDocumentSpecifier(documentName, parser, databaseRef);
        EntityRef entityRef = this.parseEntityCollectionIdResourceIdPairs(parser, partitionRef);
        parser.end();
        return entityRef;
    }

    private EntityRef parseEntityCollectionIdResourceIdPairs(FirestoreV1ResourceNameParser parser, PartitionRef partitionRef) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!parser.isEnd(), "%s name \"%s\" is invalid: Omit \"/%s\" when referencing a database (except as the parent of a document).", parser.resourceFlavor(), parser.text(), "documents");
        ImmutableList.Builder entityPathBuilder = ImmutableList.builder();
        boolean foundPair = false;
        do {
            if (foundPair) {
                parser.parseSlash();
            } else {
                parser.parseSlashAllowTrailing();
                InvalidConversionException.checkConversion(!parser.isEnd(), "%s name \"%s\" is invalid: Omit trailing \"/\".", parser.resourceFlavor(), parser.text());
            }
            String collectionId = this.convertEntityCollectionId(parser.parseId("a collection id"));
            parser.parseSlash();
            String stringResourceId = parser.parseId("a resource id");
            EntityRef.ResourceId entityResourceId = stringResourceId.equals("__none__") && parser.isEnd() ? null : this.convertEntityResourceId(stringResourceId);
            EntityRef.PathElement entityPathElement = EntityRef.PathElement.create(collectionId, entityResourceId);
            entityPathBuilder.add(entityPathElement);
            foundPair = true;
        } while (!parser.isEnd());
        EntityRef entityRef = EntityRef.create(partitionRef, (List<EntityRef.PathElement>)((Object)entityPathBuilder.build()));
        entityRef = entityRef.withV3Reference(AppEngV3ResourceRefFromRepConverter.INSTANCE.convertEntityRef(entityRef));
        return entityRef;
    }

    private PartitionRef parseDocumentSpecifier(String documentName, FirestoreV1ResourceNameParser parser, DatabaseRef databaseRef) throws InvalidConversionException {
        String namespaceId;
        String documentsText;
        String documentsAndNamespaceText = parser.parseId("a documents specifier");
        int namespaceDelimiterIndex = documentsAndNamespaceText.indexOf(64);
        if (namespaceDelimiterIndex < 0) {
            documentsText = documentsAndNamespaceText;
            namespaceId = "";
        } else {
            InvalidConversionException.checkConversion(this.allowNamespaces, "Namespaces are not supported.", new Object[0]);
            documentsText = documentsAndNamespaceText.substring(0, namespaceDelimiterIndex);
            namespaceId = documentsAndNamespaceText.substring(namespaceDelimiterIndex + 1);
            InvalidConversionException.checkConversion(!namespaceId.isEmpty(), "documents specifier missing namespace id", new Object[0]);
        }
        InvalidConversionException.checkConversion(documentsText.equals("documents"), "Document \"%s\" document specifier \"%s\" is not \"%s\".", documentName, documentsText, "documents");
        return PartitionRef.createFromDatabaseRefAndNamespace(databaseRef, namespaceId);
    }

    public OtherServiceResourceRef convertOtherServiceResourceRef(String otherServiceResourceName) throws InvalidConversionException {
        FirestoreV1ResourceNameParser parser = new FirestoreV1ResourceNameParser(false, "Database", otherServiceResourceName);
        parser.parseSlash();
        parser.parseSlash();
        String service = parser.parseId("a service name");
        ImmutableList.Builder idsBuilder = ImmutableList.builder();
        while (!parser.isEnd()) {
            parser.parseSlash();
            String id = parser.parseId("an id");
            idsBuilder.add(id);
        }
        return OtherServiceResourceRef.create(service, (ImmutableList<String>)idsBuilder.build());
    }

    public String convertEntityCollectionId(String possiblyEncodedEntityCollectionId) throws InvalidConversionException {
        this.checkIdForSlashOrDots("Collection", possiblyEncodedEntityCollectionId);
        String decodedEntityCollectionId = FirestoreV1ConverterHelper.escapedIdToUnescapedIdOrNull("Collection id", possiblyEncodedEntityCollectionId);
        if (decodedEntityCollectionId != null) {
            return decodedEntityCollectionId;
        }
        InvalidConversionException.checkConversion(!Names.isNameReserved(possiblyEncodedEntityCollectionId), "Collection id \"%s\" is invalid because it is reserved.", possiblyEncodedEntityCollectionId);
        return possiblyEncodedEntityCollectionId;
    }

    public EntityRef.ResourceId convertEntityResourceId(String possiblyEncodedEntityResourceId) throws InvalidConversionException {
        this.checkIdForSlashOrDots("Resource", possiblyEncodedEntityResourceId);
        long longResourceId = FirestoreV1ConverterHelper.stringEntityResourceIdToLongEntityResourceIdOrZero(possiblyEncodedEntityResourceId);
        if (longResourceId != 0L) {
            InvalidConversionException.checkConversion(this.allowNumberId, "__id<num>__ support disabled.", new Object[0]);
            return EntityRef.ResourceId.createLong(longResourceId);
        }
        String unescapedResourceId = FirestoreV1ConverterHelper.escapedIdToUnescapedIdOrNull("Resource id", possiblyEncodedEntityResourceId);
        if (unescapedResourceId != null) {
            return EntityRef.ResourceId.createString(unescapedResourceId);
        }
        InvalidConversionException.checkConversion(!Names.isNameReserved(possiblyEncodedEntityResourceId), "Resource id \"%s\" is invalid because it is reserved.", possiblyEncodedEntityResourceId);
        return EntityRef.ResourceId.createString(possiblyEncodedEntityResourceId);
    }

    private void checkIdForSlashOrDots(String idFlavor, String id) throws InvalidConversionException {
        InvalidConversionException.checkConversion(id.indexOf(47) < 0, "%s id \"%s\" is invalid because it contains \"/\".", idFlavor, id);
        InvalidConversionException.checkConversion(!id.equals(".") && !id.equals(".."), "%s id \"%s\" is invalid because it is reserved.", idFlavor, id);
    }
}

