/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.index;

import com.google.cloud.datastore.core.number.NumberComparisonHelper;
import com.google.cloud.datastore.core.rep.proto.IndexValue;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.type.LatLng;
import java.util.Comparator;
import java.util.Iterator;

public class IndexValueComparator {
    public static final Comparator<IndexValue> INDEX_VALUE_COMPARATOR = Comparator.comparing(IndexValue::getValueTypeCase).thenComparing(IndexValueComparator::compareSameType);
    private static final Comparator<Timestamp> TIMESTAMP_COMPARATOR = Comparator.comparing(Timestamp::getSeconds).thenComparing(Timestamp::getNanos);
    static final Comparator<ByteString> BYTE_STRING_COMPARATOR = ByteString.unsignedLexicographicalComparator();
    static final Comparator<IndexValue.BytesValue> BYTES_VALUE_COMPARATOR = Comparator.comparing(IndexValue.BytesValue::getValue, BYTE_STRING_COMPARATOR).thenComparing(IndexValue.BytesValue::getTruncated);
    public static final Comparator<IndexValue.StringValue> STRING_VALUE_COMPARATOR = Comparator.comparing(IndexValue.StringValue::getValueBytes, BYTE_STRING_COMPARATOR).thenComparing(IndexValue.StringValue::getTruncated);
    public static final Comparator<IndexValue.DocumentResourceName.Segment> PATH_SEGMENT_COMPARATOR = Comparator.comparing(IndexValue.DocumentResourceName.Segment::getIdTypeCase).thenComparing(IndexValue.DocumentResourceName.Segment::getIntegerId).thenComparing(IndexValue.DocumentResourceName.Segment::getStringId, STRING_VALUE_COMPARATOR);
    private static final Comparator<IndexValue.DocumentResourceName> DOCUMENT_RESOURCE_NAME_COMPARATOR = Comparator.comparing(IndexValue.DocumentResourceName::hasProjectId).thenComparing(IndexValue.DocumentResourceName::getProjectId, STRING_VALUE_COMPARATOR).thenComparing(IndexValue.DocumentResourceName::hasDatabaseId).thenComparing(IndexValue.DocumentResourceName::getDatabaseId, STRING_VALUE_COMPARATOR).thenComparing(IndexValue.DocumentResourceName::hasNamespaceId).thenComparing(IndexValue.DocumentResourceName::getNamespaceId, STRING_VALUE_COMPARATOR).thenComparing(IndexValue.DocumentResourceName::getSegmentsList, (p1, p2) -> IndexValueComparator.compare(p1.iterator(), p2.iterator(), PATH_SEGMENT_COMPARATOR)).thenComparing(IndexValue.DocumentResourceName::getTruncated);
    private static final Comparator<IndexValue.ResourceName> RESOURCE_NAME_COMPARATOR = Comparator.comparing(IndexValue.ResourceName::getResourceTypeCase).thenComparing(IndexValue.ResourceName::getDocumentResourceName, DOCUMENT_RESOURCE_NAME_COMPARATOR);
    private static final Comparator<LatLng> GEO_POINT_COMPARATOR = Comparator.comparing(LatLng::getLatitude).thenComparing(LatLng::getLongitude);
    private static final Comparator<IndexValue.MapValue> MAP_VALUE_COMPARATOR = Comparator.comparing(IndexValue.MapValue::getEntriesList, (m1, m2) -> IndexValueComparator.compare(m1.iterator(), m2.iterator(), Comparator.comparing(IndexValue.MapValue.MapEntry::hasKey).thenComparing(IndexValue.MapValue.MapEntry::getKey, STRING_VALUE_COMPARATOR).thenComparing(IndexValue.MapValue.MapEntry::hasValue).thenComparing(IndexValue.MapValue.MapEntry::getValue, INDEX_VALUE_COMPARATOR))).thenComparing(IndexValue.MapValue::getTruncated);
    private static final Comparator<IndexValue.ArrayValue> ARRAY_VALUE_COMPARATOR = Comparator.comparing(IndexValue.ArrayValue::getValuesList, (a1, a2) -> IndexValueComparator.compare(a1.iterator(), a2.iterator(), INDEX_VALUE_COMPARATOR)).thenComparing(IndexValue.ArrayValue::getTruncated);

    private IndexValueComparator() {
    }

    private static <T> int compare(Iterator<T> i1, Iterator<T> i2, Comparator<T> comparator) {
        while (i1.hasNext() && i2.hasNext()) {
            int cmp = comparator.compare(i1.next(), i2.next());
            if (cmp == 0) continue;
            return cmp;
        }
        if (i1.hasNext()) {
            return 1;
        }
        if (i2.hasNext()) {
            return -1;
        }
        return 0;
    }

    private static int compareNumberValues(IndexValue.NumberValue left, IndexValue.NumberValue right) {
        boolean isLeftNumberLong;
        IndexValue.NumberValue.NumberTypeCase leftNumberTypeCase = left.getNumberTypeCase();
        IndexValue.NumberValue.NumberTypeCase rightNumberTypeCase = right.getNumberTypeCase();
        boolean bl = isLeftNumberLong = leftNumberTypeCase == IndexValue.NumberValue.NumberTypeCase.LONG_VALUE;
        if (leftNumberTypeCase == rightNumberTypeCase) {
            if (isLeftNumberLong) {
                return Long.compare(left.getLongValue(), right.getLongValue());
            }
            return NumberComparisonHelper.firestoreCompareDoubles(left.getDoubleValue(), right.getDoubleValue());
        }
        if (isLeftNumberLong) {
            return -NumberComparisonHelper.firestoreCompareDoubleWithLong(right.getDoubleValue(), left.getLongValue());
        }
        return NumberComparisonHelper.firestoreCompareDoubleWithLong(left.getDoubleValue(), right.getLongValue());
    }

    private static int compareSameType(IndexValue v1, IndexValue v2) {
        Preconditions.checkArgument(v1.getValueTypeCase() == v2.getValueTypeCase());
        switch (v1.getValueTypeCase()) {
            case VALUETYPE_NOT_SET: 
            case NULL_VALUE: 
            case NAN_VALUE: {
                return 0;
            }
            case BOOLEAN_VALUE: {
                return Boolean.compare(v1.getBooleanValue(), v2.getBooleanValue());
            }
            case NUMBER_VALUE: {
                return IndexValueComparator.compareNumberValues(v1.getNumberValue(), v2.getNumberValue());
            }
            case TIMESTAMP_VALUE: {
                return TIMESTAMP_COMPARATOR.compare(v1.getTimestampValue(), v2.getTimestampValue());
            }
            case STRING_VALUE: {
                return STRING_VALUE_COMPARATOR.compare(v1.getStringValue(), v2.getStringValue());
            }
            case BYTES_VALUE: {
                return BYTES_VALUE_COMPARATOR.compare(v1.getBytesValue(), v2.getBytesValue());
            }
            case RESOURCE_NAME_VALUE: {
                return RESOURCE_NAME_COMPARATOR.compare(v1.getResourceNameValue(), v2.getResourceNameValue());
            }
            case GEO_POINT_VALUE: {
                return GEO_POINT_COMPARATOR.compare(v1.getGeoPointValue(), v2.getGeoPointValue());
            }
            case MAP_VALUE: {
                return MAP_VALUE_COMPARATOR.compare(v1.getMapValue(), v2.getMapValue());
            }
            case ARRAY_VALUE: {
                return ARRAY_VALUE_COMPARATOR.compare(v1.getArrayValue(), v2.getArrayValue());
            }
        }
        String string = String.valueOf(v1.getValueTypeCase());
        throw new IllegalArgumentException(new StringBuilder(17 + String.valueOf(string).length()).append("Unsupported type ").append(string).toString());
    }
}

