/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.index;

import com.google.cloud.datastore.core.index.IndexValueHelper;
import com.google.cloud.datastore.core.index.IndexValueSize;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.JndexValue;
import com.google.cloud.datastore.core.rep.OtherServiceResourceRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.ResourceRef;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.ValueToLegacyMapValueConverter;
import com.google.cloud.datastore.core.rep.proto.IndexValue;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleMath;
import com.google.protobuf.NullValue;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class IndexValueConverter {
    public static final IndexValueConverter INSTANCE = new IndexValueConverter();
    private static final ValueToLegacyMapValueConverter LEGACY_CONVERTER = new ValueToLegacyMapValueConverter();

    private IndexValueConverter() {
    }

    public IndexValue toTruncatedIndexValue(Value value) {
        return IndexValueSize.truncate(this.toIndexValue(value));
    }

    public IndexValue toIndexValue(Value value) {
        value = LEGACY_CONVERTER.shallowConvertValue(value);
        switch (value.type()) {
            case NULL: {
                return IndexValueHelper.NULL;
            }
            case BOOLEAN: {
                return IndexValueHelper.createBoolean(value.asBoolean());
            }
            case LONG: {
                return IndexValueHelper.createNumber(value.asLong());
            }
            case DOUBLE: {
                double num = value.asDouble();
                if (num >= -9.223372036854776E18 && num < 9.223372036854776E18 && DoubleMath.isMathematicalInteger(num)) {
                    return IndexValueHelper.createNumber((long)num);
                }
                return IndexValueHelper.createNumber(num);
            }
            case TIMESTAMP: {
                return IndexValue.newBuilder().setTimestampValue(value.asTimestamp()).build();
            }
            case ENTITY_REF: {
                return IndexValue.newBuilder().setResourceNameValue(IndexValue.ResourceName.newBuilder().setDocumentResourceName(this.toDocumentResourceName(true, value.asEntityRef()))).build();
            }
            case STRING: {
                return IndexValue.newBuilder().setStringValue(IndexValueConverter.toStringValue(value.asString())).build();
            }
            case BYTES: {
                return IndexValue.newBuilder().setBytesValue(IndexValue.BytesValue.newBuilder().setValue(value.asBytes())).build();
            }
            case GEO_POINT: {
                return IndexValue.newBuilder().setGeoPointValue(value.asGeoPoint()).build();
            }
            case ARRAY: {
                return IndexValue.newBuilder().setArrayValue(IndexValue.ArrayValue.newBuilder().addAllValues(value.asArray().stream().map(this::toIndexValue).collect(Collectors.toList()))).build();
            }
            case MAP: {
                return IndexValueHelper.createMap(value.asMap().entrySet().stream().collect(Collectors.toMap(entry -> IndexValueConverter.toStringValue((String)entry.getKey()), entry -> this.toIndexValue((Value)entry.getValue()))), false);
            }
            case LEGACY_USER: 
            case LEGACY_TIMESTAMP_MICROSECONDS: 
            case ENTITY: {
                throw new IllegalStateException("legacy types should already have been converted.");
            }
            case RESOURCE_REF: {
                ResourceRef resourceRef = value.asResourceRef();
                if (resourceRef instanceof OtherServiceResourceRef) {
                    Preconditions.checkArgument(resourceRef.equals(OtherServiceResourceRef.EMPTY), "only empty other service resource ref are allowed");
                    return IndexValue.newBuilder().setResourceNameValue(IndexValue.ResourceName.newBuilder().setDocumentResourceName(IndexValue.DocumentResourceName.getDefaultInstance())).build();
                }
                if (resourceRef instanceof DatabaseRef) {
                    return IndexValue.newBuilder().setResourceNameValue(IndexValue.ResourceName.newBuilder().setDocumentResourceName(this.toDocumentResourceName((DatabaseRef)resourceRef))).build();
                }
                if (resourceRef instanceof PartitionRef) {
                    return IndexValue.newBuilder().setResourceNameValue(IndexValue.ResourceName.newBuilder().setDocumentResourceName(this.toDocumentResourceName((PartitionRef)resourceRef))).build();
                }
                String string = String.valueOf(resourceRef.getClass());
                throw new IllegalArgumentException(new StringBuilder(25 + String.valueOf(string).length()).append("Unsupported resource ref ").append(string).toString());
            }
        }
        String string = String.valueOf((Object)value.type());
        throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("Unsupported Value type ").append(string).toString());
    }

    public IndexValue toIndexValue(EntityRef entityRef) {
        return this.toIndexValue(Value.createEntityRef(entityRef));
    }

    public IndexValue toIndexValueDatabaseRelative(EntityRef ref) {
        IndexValue.Builder builder = IndexValue.newBuilder();
        builder.getResourceNameValueBuilder().setDocumentResourceName(this.toDocumentResourceName(false, ref));
        return builder.build();
    }

    public IndexValue toIndexValue(PropertyPath propertyPath) {
        IndexValue.ArrayValue.Builder array = IndexValue.ArrayValue.newBuilder();
        while (propertyPath != null) {
            PropertyPathSegment segment;
            if (propertyPath.segment() instanceof PropertyPathSegment.Member) {
                segment = (PropertyPathSegment.Member)propertyPath.segment();
                array.addValuesBuilder().getStringValueBuilder().setValue(((PropertyPathSegment.Member)segment).name().string());
            } else if (propertyPath.segment() instanceof PropertyPathSegment.Index) {
                segment = (PropertyPathSegment.Index)propertyPath.segment();
                array.addValuesBuilder().getNumberValueBuilder().setLongValue(((PropertyPathSegment.Index)segment).index());
            } else {
                Preconditions.checkArgument(propertyPath.segment() instanceof PropertyPathSegment.AllArrayElements);
                array.addValuesBuilder().setNullValue(NullValue.NULL_VALUE);
            }
            propertyPath = propertyPath.next();
        }
        return IndexValue.newBuilder().setArrayValue(array).build();
    }

    public PropertyPath toPropertyPath(IndexValue value) {
        Preconditions.checkArgument(value.getValueTypeCase() == IndexValue.ValueTypeCase.ARRAY_VALUE);
        Preconditions.checkArgument(!value.getArrayValue().getTruncated());
        Preconditions.checkArgument(!value.getArrayValue().getValuesList().isEmpty());
        PropertyPath propertyPath = null;
        for (IndexValue indexSegment : value.getArrayValue().getValuesList()) {
            PropertyPathSegment segment;
            switch (indexSegment.getValueTypeCase()) {
                case STRING_VALUE: {
                    Preconditions.checkArgument(!indexSegment.getStringValue().getTruncated());
                    segment = PropertyPathSegment.Member.create(PropertyName.fromUtf8(indexSegment.getStringValue().getValue()));
                    break;
                }
                case NUMBER_VALUE: {
                    Preconditions.checkArgument(indexSegment.getNumberValue().getNumberTypeCase() == IndexValue.NumberValue.NumberTypeCase.LONG_VALUE);
                    segment = PropertyPathSegment.Index.create((int)indexSegment.getNumberValue().getLongValue());
                    break;
                }
                case NULL_VALUE: {
                    segment = PropertyPathSegment.AllArrayElements.create();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            propertyPath = PropertyPath.create(propertyPath, segment);
        }
        return propertyPath;
    }

    public PropertyPath toPropertyPath(JndexValue value) {
        Preconditions.checkArgument(value.type() == JndexValue.Type.ARRAY);
        Preconditions.checkArgument(!value.isShallowTruncated());
        Preconditions.checkArgument(!value.asArray().isEmpty());
        PropertyPath propertyPath = null;
        for (JndexValue indexSegment : value.asArray()) {
            PropertyPathSegment segment;
            Preconditions.checkArgument(!indexSegment.isShallowTruncated());
            switch (indexSegment.type()) {
                case STRING: {
                    segment = PropertyPathSegment.Member.create(PropertyName.fromUtf8(indexSegment.asString()));
                    break;
                }
                case NUMBER: {
                    Preconditions.checkArgument(!indexSegment.isNumberDouble());
                    segment = PropertyPathSegment.Index.create((int)indexSegment.asNumberLong());
                    break;
                }
                case NULL: {
                    segment = PropertyPathSegment.AllArrayElements.create();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            propertyPath = PropertyPath.create(propertyPath, segment);
        }
        return propertyPath;
    }

    public IndexValue convertKindToIndexValue(String kind) {
        return IndexValue.newBuilder().setStringValue(IndexValue.StringValue.newBuilder().setValue(kind)).build();
    }

    public IndexValue convertNamespaceToIndexValue(String namespace) {
        return IndexValue.newBuilder().setStringValue(IndexValue.StringValue.newBuilder().setValue(namespace)).build();
    }

    public IndexValue.DocumentResourceName toDocumentResourceName(PartitionRef partitionRef) {
        IndexValue.DocumentResourceName.Builder builder = IndexValue.DocumentResourceName.newBuilder();
        IndexValueConverter.setPartition(partitionRef, builder);
        return builder.build();
    }

    public IndexValue.DocumentResourceName toDocumentResourceName(EntityRef ref) {
        return this.toDocumentResourceName(true, ref);
    }

    private IndexValue.DocumentResourceName toDocumentResourceName(DatabaseRef databaseRef) {
        IndexValue.DocumentResourceName.Builder builder = IndexValue.DocumentResourceName.newBuilder();
        IndexValueConverter.setDatabaseRef(databaseRef, builder);
        return builder.build();
    }

    private IndexValue.DocumentResourceName toDocumentResourceName(boolean withDatabase, EntityRef ref) {
        IndexValue.DocumentResourceName.Builder builder = IndexValue.DocumentResourceName.newBuilder();
        IndexValueConverter.setPartition(ref.partitionRef(), builder);
        if (!withDatabase) {
            builder.clearProjectId();
            builder.clearDatabaseId();
        }
        for (EntityRef.PathElement pathElement : ref.pathElements()) {
            builder.addSegments(IndexValue.DocumentResourceName.Segment.newBuilder().setStringId(IndexValueConverter.toStringValue(pathElement.collectionId())));
            if (pathElement.resourceId() == null) continue;
            builder.addSegments(this.toSegment(pathElement.resourceId()));
        }
        return builder.build();
    }

    private static void setPartition(PartitionRef partitionRef, IndexValue.DocumentResourceName.Builder document) {
        IndexValueConverter.setDatabaseRef(partitionRef.databaseRef(), document);
        document.setNamespaceId(IndexValueConverter.toStringValue(partitionRef.namespace()));
    }

    private static void setDatabaseRef(DatabaseRef databaseRef, IndexValue.DocumentResourceName.Builder document) {
        document.setProjectId(IndexValueConverter.toStringValue(databaseRef.projectId()));
        document.setDatabaseId(IndexValueConverter.toStringValue(databaseRef.databaseId()));
    }

    private IndexValue.DocumentResourceName.Segment toSegment(EntityRef.ResourceId resourceId) {
        IndexValue.DocumentResourceName.Segment.Builder resultBuilder = IndexValue.DocumentResourceName.Segment.newBuilder();
        if (resourceId.asString() != null) {
            resultBuilder.setStringId(IndexValueConverter.toStringValue(resourceId.asString()));
        } else {
            resultBuilder.setIntegerId(resourceId.asLong());
        }
        return resultBuilder.build();
    }

    private static IndexValue.StringValue toStringValue(String utf8String) {
        return IndexValue.StringValue.newBuilder().setValue(utf8String).build();
    }

    public EntityRef toEntityRef(DatabaseRef database, IndexValue indexValue) {
        Preconditions.checkArgument(indexValue.getValueTypeCase() == IndexValue.ValueTypeCase.RESOURCE_NAME_VALUE);
        IndexValue.ResourceName resourceName = indexValue.getResourceNameValue();
        Preconditions.checkArgument(resourceName.getResourceTypeCase() == IndexValue.ResourceName.ResourceTypeCase.DOCUMENT_RESOURCE_NAME);
        IndexValue.DocumentResourceName documentResourceName = resourceName.getDocumentResourceName();
        Preconditions.checkArgument(!documentResourceName.getTruncated());
        Preconditions.checkArgument(!documentResourceName.hasProjectId());
        Preconditions.checkArgument(!documentResourceName.hasDatabaseId());
        IndexValue.StringValue namespaceStringValue = documentResourceName.getNamespaceId();
        Preconditions.checkArgument(!namespaceStringValue.getTruncated());
        PartitionRef partitionRef = PartitionRef.createFromDatabaseRefAndNamespace(database, namespaceStringValue.getValue());
        OnestoreEntity.Reference v3Ref = new OnestoreEntity.Reference();
        v3Ref.setApp(partitionRef.databaseRef().appId());
        v3Ref.setDatabaseId(partitionRef.databaseRef().databaseId());
        v3Ref.setNameSpace(partitionRef.namespace());
        EntityRef entityRef = EntityRef.create(partitionRef, this.toPath(documentResourceName, v3Ref).elements());
        return entityRef.withV3Reference(v3Ref);
    }

    public EntityRef.Path toPath(IndexValue.DocumentResourceName documentResourceName) {
        return this.toPath(documentResourceName, null);
    }

    private EntityRef.Path toPath(IndexValue.DocumentResourceName documentResourceName, @Nullable OnestoreEntity.Reference v3Ref) {
        List<IndexValue.DocumentResourceName.Segment> segments = documentResourceName.getSegmentsList();
        int numSegments = segments.size();
        ArrayList<EntityRef.PathElement> entityRefPathElements = new ArrayList<EntityRef.PathElement>();
        for (int segmentIndex = 0; segmentIndex < numSegments; ++segmentIndex) {
            IndexValue.DocumentResourceName.Segment collectionIdSegment = segments.get(segmentIndex);
            Preconditions.checkArgument(collectionIdSegment.getIdTypeCase() == IndexValue.DocumentResourceName.Segment.IdTypeCase.STRING_ID);
            IndexValue.StringValue collectionIdStringValue = collectionIdSegment.getStringId();
            Preconditions.checkArgument(!collectionIdStringValue.getTruncated());
            String collectionId = collectionIdStringValue.getValue();
            OnestoreEntity.Path.Element v3PathElement = null;
            if (v3Ref != null) {
                v3PathElement = v3Ref.getMutablePath().addElement();
                v3PathElement.setType(collectionId);
            }
            EntityRef.ResourceId resourceId = null;
            if (++segmentIndex < numSegments) {
                IndexValue.DocumentResourceName.Segment resourceIdSegment = segments.get(segmentIndex);
                switch (resourceIdSegment.getIdTypeCase()) {
                    case STRING_ID: {
                        IndexValue.StringValue nameResourceIdStringValue = resourceIdSegment.getStringId();
                        Preconditions.checkArgument(!nameResourceIdStringValue.getTruncated());
                        resourceId = EntityRef.ResourceId.createString(nameResourceIdStringValue.getValue());
                        if (v3PathElement == null) break;
                        v3PathElement.setName(resourceId.asString());
                        break;
                    }
                    case INTEGER_ID: {
                        resourceId = EntityRef.ResourceId.createLong(resourceIdSegment.getIntegerId());
                        if (v3PathElement == null) break;
                        v3PathElement.setId(resourceId.asLong());
                        break;
                    }
                    default: {
                        Preconditions.checkArgument(false);
                    }
                }
            }
            EntityRef.PathElement entityRefPathElement = EntityRef.PathElement.create(collectionId, resourceId);
            entityRefPathElements.add(entityRefPathElement);
        }
        return EntityRef.Path.create(entityRefPathElements);
    }
}

