/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.index;

import com.google.cloud.datastore.core.index.IndexValueComparator;
import com.google.cloud.datastore.core.rep.proto.IndexValue;
import com.google.cloud.datastore.core.rep.proto.IndexValueOrBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.protobuf.Empty;
import com.google.protobuf.NullValue;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class IndexValueHelper {
    public static final IndexValue NULL = IndexValue.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
    public static final IndexValue NAN = IndexValue.newBuilder().setNanValue(Empty.getDefaultInstance()).build();
    public static final IndexValue FALSE = IndexValue.newBuilder().setBooleanValue(false).build();
    public static final IndexValue TRUE = IndexValue.newBuilder().setBooleanValue(true).build();

    private IndexValueHelper() {
    }

    public static IndexValue createBoolean(boolean v) {
        return v ? TRUE : FALSE;
    }

    public static IndexValue createNumber(long number) {
        IndexValue.Builder builder = IndexValue.newBuilder();
        builder.getNumberValueBuilder().setLongValue(number);
        return builder.build();
    }

    public static IndexValue createNumber(double number) {
        if (Double.isNaN(number)) {
            return NAN;
        }
        IndexValue.Builder builder = IndexValue.newBuilder();
        builder.getNumberValueBuilder().setDoubleValue(number);
        return builder.build();
    }

    public static IndexValue createMap(Map<IndexValue.StringValue, IndexValue> v, boolean truncated) {
        IndexValue.Builder builder = IndexValue.newBuilder();
        builder.getMapValueBuilder().setTruncated(truncated);
        for (IndexValue.StringValue key : ImmutableSortedSet.copyOf(IndexValueComparator.STRING_VALUE_COMPARATOR, v.keySet())) {
            IndexValue.MapValue.MapEntry.Builder entry = IndexValue.MapValue.MapEntry.newBuilder();
            entry.setKey(key);
            if (v.get(key) != null) {
                entry.setValue(v.get(key));
            }
            builder.getMapValueBuilder().addEntries(entry);
        }
        return builder.build();
    }

    public static boolean checkTruncation(IndexValueOrBuilder value) {
        switch (value.getValueTypeCase()) {
            case NULL_VALUE: 
            case BOOLEAN_VALUE: 
            case NAN_VALUE: 
            case NUMBER_VALUE: 
            case TIMESTAMP_VALUE: 
            case GEO_POINT_VALUE: {
                return false;
            }
            case STRING_VALUE: {
                return IndexValueHelper.checkTruncation(value.getStringValue());
            }
            case BYTES_VALUE: {
                return value.getBytesValue().getTruncated();
            }
            case RESOURCE_NAME_VALUE: {
                return IndexValueHelper.checkTruncation(value.getResourceNameValue());
            }
            case MAP_VALUE: {
                return IndexValueHelper.checkTruncation(value.getMapValue().getEntriesList(), IndexValueHelper::checkTruncation, value.getMapValue().getTruncated());
            }
            case ARRAY_VALUE: {
                return IndexValueHelper.checkTruncation(value.getArrayValue().getValuesList(), IndexValueHelper::checkTruncation, value.getArrayValue().getTruncated());
            }
        }
        String string = String.valueOf(value.getValueTypeCase());
        throw new IllegalArgumentException(new StringBuilder(19 + String.valueOf(string).length()).append("unknown value type ").append(string).toString());
    }

    private static boolean checkTruncation(IndexValue.StringValue string) {
        return string.getTruncated();
    }

    private static boolean checkTruncation(IndexValue.DocumentResourceName.Segment segment) {
        switch (segment.getIdTypeCase()) {
            case INTEGER_ID: {
                return false;
            }
            case STRING_ID: {
                return IndexValueHelper.checkTruncation(segment.getStringId());
            }
        }
        String string = String.valueOf(segment.getIdTypeCase());
        throw new IllegalArgumentException(new StringBuilder(21 + String.valueOf(string).length()).append("unknown segment type ").append(string).toString());
    }

    private static boolean checkTruncation(IndexValue.ResourceName resourceName) {
        switch (resourceName.getResourceTypeCase()) {
            case DOCUMENT_RESOURCE_NAME: {
                return IndexValueHelper.checkTruncation(resourceName.getDocumentResourceName());
            }
        }
        String string = String.valueOf(resourceName.getResourceTypeCase());
        throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(string).length()).append("unknown resource name type ").append(string).toString());
    }

    private static boolean checkTruncation(IndexValue.DocumentResourceName documentResourceName) {
        if (!documentResourceName.hasProjectId() || IndexValueHelper.checkTruncation(documentResourceName.getProjectId())) {
            IndexValueHelper.checkTruncatedAtProject(documentResourceName);
        } else if (!documentResourceName.hasDatabaseId() || IndexValueHelper.checkTruncation(documentResourceName.getDatabaseId())) {
            IndexValueHelper.checkTruncatedAtDatabase(documentResourceName);
        } else if (!documentResourceName.hasNamespaceId() || IndexValueHelper.checkTruncation(documentResourceName.getNamespaceId())) {
            IndexValueHelper.checkTruncatedAtNamespace(documentResourceName);
        } else {
            return IndexValueHelper.checkTruncation(documentResourceName.getSegmentsList(), IndexValueHelper::checkTruncation, documentResourceName.getTruncated());
        }
        return true;
    }

    private static void checkTruncatedAtProject(IndexValue.DocumentResourceName documentResourceName) {
        Preconditions.checkArgument(!documentResourceName.hasDatabaseId(), "resource database must not be set.");
        IndexValueHelper.checkTruncatedAtDatabase(documentResourceName);
    }

    private static void checkTruncatedAtDatabase(IndexValue.DocumentResourceName documentResourceName) {
        Preconditions.checkArgument(!documentResourceName.hasNamespaceId(), "resource namespace must not be set.");
        IndexValueHelper.checkTruncatedAtNamespace(documentResourceName);
    }

    private static void checkTruncatedAtNamespace(IndexValue.DocumentResourceName documentResourceName) {
        Preconditions.checkArgument(documentResourceName.getSegmentsList().isEmpty(), "resource path must be empty.");
        Preconditions.checkArgument(!documentResourceName.getTruncated(), "resource must not be truncated");
    }

    private static boolean checkTruncation(IndexValue.MapValue.MapEntry entry) {
        Preconditions.checkArgument(entry.hasKey(), "a map entry must have a key.");
        if (IndexValueHelper.checkTruncation(entry.getKey())) {
            Preconditions.checkArgument(!entry.hasValue(), "a map entry with a truncated key must not have a value.");
        }
        return !entry.hasValue() || IndexValueHelper.checkTruncation(entry.getValue());
    }

    private static <T> boolean checkTruncation(List<T> list, Predicate<T> truncationPredicate, boolean listTruncation) {
        boolean hasTruncatedElement = false;
        for (int i = 0; i < list.size(); ++i) {
            hasTruncatedElement = truncationPredicate.test(list.get(i));
            if (!hasTruncatedElement) continue;
            Preconditions.checkArgument(!listTruncation, "a truncated value must not contain other truncated values.");
            Preconditions.checkArgument(i == list.size() - 1, "only the last repeated value can be truncated.");
        }
        return listTruncation || hasTruncatedElement;
    }
}

